/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.details;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FilteringStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.clazz.details.AnalysisLevel;
import org.eclipse.uml2.diagram.clazz.details.DetailsSuppressedLevel;
import org.eclipse.uml2.diagram.clazz.details.ImplementationLevel;
import org.eclipse.uml2.diagram.clazz.details.UMLDetailLevel;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.VisibilityKind;

public class UMLDetailLevelService {
    public static final String SORT_BY_VISIBILITY = "org.eclipse.uml2.diagram.clazz.sort.visibility";
    public static final String FILTER_BY_VISIBILITY = "org.eclipse.uml2.diagram.clazz.filter.visibility";
    public static final UMLDetailLevel DETAILS_SUPPRESSED_LEVEL = new DetailsSuppressedLevel();
    public static final UMLDetailLevel IMPLEMENTATION_LEVEL = new ImplementationLevel();
    public static final UMLDetailLevel ANALYSIS_LEVEL = new AnalysisLevel();
    public static final UMLDetailLevel DEFAULT_LEVEL = IMPLEMENTATION_LEVEL;
    public static final String ID_DETAIL_LEVEL_IMPLEMENTATION = "org.eclipse.uml2.diagram.clazz.detail_level_implementation";
    public static final String ID_DETAIL_LEVEL_ANALYSIS = "org.eclipse.uml2.diagram.clazz.detail_level_analysis";
    public static final String ID_DETAIL_LEVEL_DETAILS_SUPPRESSED = "org.eclipse.uml2.diagram.clazz.detail_level_suppressed";
    public static final UMLDetailLevel EMPTY_LEVEL = new UMLDetailLevel(){

        @Override
        public void init(View view) {
        }
    };

    public static UMLDetailLevel getLevel(View view) {
        Diagram diagram = view.getDiagram();
        if (diagram == null) {
            return DEFAULT_LEVEL;
        }
        FilteringStyle style = (FilteringStyle)diagram.getStyle(NotationPackage.eINSTANCE.getFilteringStyle());
        if (style == null) {
            return DEFAULT_LEVEL;
        }
        List<String> keys = UMLDetailLevelService.getFilteringKeysImpl(style);
        return keys.isEmpty() ? DEFAULT_LEVEL : UMLDetailLevelService.getLevel(keys.get(0));
    }

    public static UMLDetailLevel getLevel(String id) {
        if (ID_DETAIL_LEVEL_ANALYSIS.equals(id)) {
            return ANALYSIS_LEVEL;
        }
        if (ID_DETAIL_LEVEL_DETAILS_SUPPRESSED.equals(id)) {
            return DETAILS_SUPPRESSED_LEVEL;
        }
        if (ID_DETAIL_LEVEL_IMPLEMENTATION.equals(id)) {
            return IMPLEMENTATION_LEVEL;
        }
        return EMPTY_LEVEL;
    }

    public static List<View> filterChildrenByVisibility(View view) {
        if (view == null) {
            return Collections.emptyList();
        }
        EList visibleChildren = view.getVisibleChildren();
        ArrayList<View> result = new ArrayList<View>();
        for (Object child : visibleChildren) {
            EObject childElement;
            if (!(child instanceof View) || !((childElement = ((View)child).getElement()) instanceof NamedElement) || ((NamedElement)childElement).getVisibility() == VisibilityKind.PUBLIC_LITERAL) continue;
            result.add((View)child);
        }
        return result;
    }

    private static List<String> getFilteringKeysImpl(FilteringStyle style) {
        return style.getFilteringKeys();
    }
}

