/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.uml2.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLFactory;

public class AssociationInstanceCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;
    private final InstanceSpecification container;

    public AssociationInstanceCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = AssociationInstanceCreateCommand.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof InstanceSpecification)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof InstanceSpecification)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canCreateSlot_4015(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        Slot newElement = UMLFactory.eINSTANCE.createSlot();
        newElement.setOwningInstance(this.getSource());
        InstanceValue value = UMLFactory.eINSTANCE.createInstanceValue();
        value.setInstance(this.getTarget());
        newElement.getValues().add((Object)value);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(Slot newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected InstanceSpecification getSource() {
        return (InstanceSpecification)this.source;
    }

    protected InstanceSpecification getTarget() {
        return (InstanceSpecification)this.target;
    }

    public InstanceSpecification getContainer() {
        return this.container;
    }

    private static InstanceSpecification deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof InstanceSpecification) {
                return (InstanceSpecification)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

