/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.uml2.diagram.clazz.edit.helpers.DependencyEditHelper;
import org.eclipse.uml2.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class DependencyLinkCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;
    private final Package container;
    private final EClass linkEClass;

    public DependencyLinkCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = DependencyLinkCreateCommand.deduceContainer(source, target);
        this.linkEClass = (EClass)request.getParameter(DependencyEditHelper.PARAMETER_DEPENDENCY_TYPE);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof NamedElement)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof NamedElement)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canCreateDependency_4002(this.getContainer(), this.getSource(), this.getTarget()) && UMLBaseItemSemanticEditPolicy.LinkConstraints.canReallyExistDependency_4002(this.getSource(), this.getTarget(), this.linkEClass);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        EClass dependencyTypeHint = (EClass)this.getRequest().getParameter(DependencyEditHelper.PARAMETER_DEPENDENCY_TYPE);
        if (dependencyTypeHint == null) {
            dependencyTypeHint = UMLPackage.eINSTANCE.getDependency();
        }
        Dependency newElement = (Dependency)this.getContainer().createPackagedElement(null, dependencyTypeHint);
        newElement.getClients().add((Object)this.getSource());
        newElement.getSuppliers().add((Object)this.getTarget());
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(Dependency newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected NamedElement getSource() {
        return (NamedElement)this.source;
    }

    protected NamedElement getTarget() {
        return (NamedElement)this.target;
    }

    public Package getContainer() {
        return this.container;
    }

    private static Package deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Package) {
                return (Package)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

