/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.uml2.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.GeneralizationSet;

public class GeneralizationGeneralReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public GeneralizationGeneralReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof GeneralizationSet) && ((GeneralizationSet)this.referenceOwner).getGeneralization(this.getOldTarget()) != null) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        return false;
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Classifier) || !(this.newEnd instanceof Classifier)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistGeneralizationGeneral_4012(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().setGeneral(null);
        this.getNewSource().setGeneral(this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        for (Generalization g : this.getAllGeneralizations()) {
            g.setGeneral(this.getNewTarget());
        }
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Generalization getOldSource() {
        return ((GeneralizationSet)this.referenceOwner).getGeneralization(this.getOldTarget());
    }

    protected List<Generalization> getAllGeneralizations() {
        ArrayList<Generalization> result = new ArrayList<Generalization>();
        for (Generalization g : ((GeneralizationSet)this.referenceOwner).getGeneralizations()) {
            if (!this.getOldTarget().equals(g.getGeneral())) continue;
            result.add(g);
        }
        return result;
    }

    protected Generalization getNewSource() {
        return (Generalization)this.newEnd;
    }

    protected Classifier getOldTarget() {
        return (Classifier)this.oldEnd;
    }

    protected Classifier getNewTarget() {
        return (Classifier)this.newEnd;
    }
}

