/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.parser;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.uml2.diagram.clazz.parsers.AbstractParser;
import org.eclipse.uml2.diagram.clazz.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;

public class NamedElementParser
extends MessageFormatParser {
    private static final String PUBLIC = "";
    private static final String PROTECTED = "#";
    private static final String PRIVATE = "-";
    private static final String PACKAGE = "~";
    private static final EAttribute[] ourFeatures = new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Visibility(), UMLPackage.eINSTANCE.getNamedElement_Name()};

    public NamedElementParser() {
        super(ourFeatures);
        this.setViewPattern("{0}{1}");
        this.setEditPattern("{0} {1}");
    }

    @Override
    public String getPrintString(IAdaptable adapter, int flags) {
        return super.getPrintString(adapter, flags);
    }

    @Override
    protected Object getValue(EObject element, EAttribute feature) {
        Object value = element.eGet((EStructuralFeature)feature);
        if (UMLPackage.eINSTANCE.getNamedElement_Visibility().equals(feature)) {
            return NamedElementParser.getVisibilityLiteral((VisibilityKind)value);
        }
        return super.getValue(element, feature);
    }

    @Override
    protected Object getValidNewValue(EAttribute feature, Object value) {
        if (UMLPackage.eINSTANCE.getNamedElement_Visibility().equals(feature)) {
            return this.getVisibilityKind((String)value);
        }
        return super.getValidNewValue(feature, value);
    }

    @Override
    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        newString = this.getParsableEditString(newString);
        return super.getParseCommand(adapter, newString, flags);
    }

    @Override
    public IParserEditStatus isValidEditString(IAdaptable adapter, String editString) {
        editString = this.getParsableEditString(editString);
        return super.isValidEditString(adapter, editString);
    }

    private String getParsableEditString(String editString) {
        if (editString == null || editString.length() == 0) {
            return editString;
        }
        if (editString.startsWith(PROTECTED) || editString.startsWith(PRIVATE) || editString.startsWith(PACKAGE)) {
            StringBuffer result = new StringBuffer();
            result.append(editString.charAt(0));
            if (editString.length() > 1) {
                result.append(" ");
                result.append(editString.substring(1).trim());
            }
            return result.toString();
        }
        editString = " " + editString.trim();
        return editString;
    }

    private static String getVisibilityLiteral(VisibilityKind visibility) {
        switch (visibility.getValue()) {
            case 3: {
                return PACKAGE;
            }
            case 1: {
                return PRIVATE;
            }
            case 2: {
                return PROTECTED;
            }
            case 0: {
                return PUBLIC;
            }
        }
        throw new IllegalArgumentException("Unknown visibility : " + visibility);
    }

    private Object getVisibilityKind(String visibility) {
        if (PACKAGE.equals(visibility = visibility.trim())) {
            return VisibilityKind.PACKAGE_LITERAL;
        }
        if (PRIVATE.equals(visibility)) {
            return VisibilityKind.PRIVATE_LITERAL;
        }
        if (PROTECTED.equals(visibility)) {
            return VisibilityKind.PROTECTED_LITERAL;
        }
        if (PUBLIC.equals(visibility)) {
            return VisibilityKind.PUBLIC_LITERAL;
        }
        return new AbstractParser.InvalidValue(this, "Unknown visibility sign: " + visibility);
    }
}

