/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.usecase.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.usecase.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.UseCase;

public class IncludeReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public IncludeReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Include)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof UseCase) || !(this.newEnd instanceof UseCase)) {
            return false;
        }
        UseCase target = this.getLink().getAddition();
        if (!(this.getLink().eContainer() instanceof UseCase)) {
            return false;
        }
        UseCase container = (UseCase)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistInclude_4001(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof UseCase) || !(this.newEnd instanceof UseCase)) {
            return false;
        }
        UseCase source = this.getLink().getIncludingCase();
        if (!(this.getLink().eContainer() instanceof UseCase)) {
            return false;
        }
        UseCase container = (UseCase)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistInclude_4001(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setIncludingCase(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setAddition(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Include getLink() {
        return (Include)this.getElementToEdit();
    }

    protected UseCase getOldSource() {
        return (UseCase)this.oldEnd;
    }

    protected UseCase getNewSource() {
        return (UseCase)this.newEnd;
    }

    protected UseCase getOldTarget() {
        return (UseCase)this.oldEnd;
    }

    protected UseCase getNewTarget() {
        return (UseCase)this.newEnd;
    }
}

