/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.component.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.common.conventions.AssociationEndConvention;
import org.eclipse.uml2.diagram.component.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class AssociationReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public AssociationReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Association)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Type) || !(this.newEnd instanceof Type)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        Property targetEnd = AssociationEndConvention.getTargetEnd((Association)this.getLink());
        if (targetEnd == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistAssociation_4011(container, this.getLink(), this.getNewSource(), targetEnd.getType());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Type) || !(this.newEnd instanceof Type)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        Property sourceEnd = AssociationEndConvention.getSourceEnd((Association)this.getLink());
        if (sourceEnd == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistAssociation_4011(container, this.getLink(), sourceEnd.getType(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        Association association = this.getLink();
        Property actualSource = AssociationEndConvention.getSourceEnd((Association)association);
        actualSource.setType(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        Association association = this.getLink();
        Property actualTarget = AssociationEndConvention.getTargetEnd((Association)association);
        actualTarget.setType(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Association getLink() {
        return (Association)this.getElementToEdit();
    }

    protected Type getOldSource() {
        return (Type)this.oldEnd;
    }

    protected Type getNewSource() {
        return (Type)this.newEnd;
    }

    protected Type getOldTarget() {
        return (Type)this.oldEnd;
    }

    protected Type getNewTarget() {
        return (Type)this.newEnd;
    }
}

