/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.component.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.uml2.diagram.common.links.RefreshComplementaryLinksHelper;
import org.eclipse.uml2.diagram.component.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Usage;

public class ComponentRequiredReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ComponentRequiredReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Classifier)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSourceGen() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Component)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistComponentRequired_4007(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientSource() {
        return this.oldEnd instanceof Interface && this.newEnd instanceof Classifier;
    }

    protected boolean canReorientTargetGen() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Interface)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistComponentRequired_4007(this.getOldSource(), this.getNewTarget());
    }

    protected boolean canReorientTarget() {
        return this.oldEnd instanceof Interface && this.newEnd instanceof Interface;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        Usage usage = this.findUsage(this.getGeneralizedOldSource(), this.getOldTarget());
        if (usage != null) {
            usage.getClients().remove((Object)this.getGeneralizedOldSource());
            usage.getClients().add((Object)this.getGeneralizedNewSource());
        }
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        Classifier component = this.getGeneralizedOldSource();
        Usage usage = this.findUsage(component, this.getOldTarget());
        if (usage != null) {
            usage.getSuppliers().remove((Object)this.getOldTarget());
            usage.getSuppliers().add((Object)this.getNewTarget());
        }
        RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)this.getOldTarget(), (Object)NotationPackage.eINSTANCE.getView_TargetEdges(), "Required interface links of ports typed by unchanged usage source");
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Component getOldSource() {
        return (Component)this.referenceOwner;
    }

    protected Classifier getGeneralizedOldSource() {
        return (Classifier)this.referenceOwner;
    }

    protected Component getNewSource() {
        return (Component)this.newEnd;
    }

    protected Classifier getGeneralizedNewSource() {
        return (Classifier)this.newEnd;
    }

    protected Interface getOldTarget() {
        return (Interface)this.oldEnd;
    }

    protected Interface getNewTarget() {
        return (Interface)this.newEnd;
    }

    private Usage findUsage(Classifier component, Interface required) {
        for (Dependency next : component.getClientDependencies()) {
            if (!(next instanceof Usage) || !next.getSuppliers().contains((Object)required)) continue;
            return (Usage)next;
        }
        return null;
    }
}

