/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.component.part;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistryExt;
import org.eclipse.uml2.diagram.component.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.component.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.component.part.UMLNodeDescriptor;
import org.eclipse.uml2.diagram.component.part.VisualIDRegistryExtension;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.uml2.diagram.component/debug/visualID";
    public static final IVisualIDRegistry TYPED_ADAPTER = new IVisualIDRegistryExt(){
        private VisualIDRegistryExtension myExtension = new VisualIDRegistryExtension();

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }

        public boolean isShortcutDescendant(View view) {
            return UMLVisualIDRegistry.isShortcutDescendant(view);
        }

        public List<String> getAllHintedTypes() {
            return this.myExtension.getAllHintedTypes();
        }

        public List<IVisualIDRegistryExt.MenuTypeHint> getMenuTypeHints(String type) {
            return this.myExtension.getMenuTypeHints(type);
        }

        public String getSemanticHint(View childView, View newParentView) {
            return this.myExtension.getSemanticHint(childView, newParentView);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLComponent".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLComponent".equals(containerModelID) && !"UMLComponent".equals(containerModelID)) {
            return -1;
        }
        if ("UMLComponent".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (containerView instanceof Diagram && domainElement != null && domainElement.equals(containerView.getElement())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2004((Class)domainElement)) {
                    return 2004;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2007((Class)domainElement)) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 2009;
            }
            case 2001: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 2004: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 2007: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3001: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 3004: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7001: {
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3004((Class)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3006((Property)domainElement)) {
                    return 3006;
                }
                if (!UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isConnector_3015((Connector)domainElement)) break;
                return 3015;
            }
            case 7002: {
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3004((Class)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3006((Property)domainElement)) {
                    return 3006;
                }
                if (!UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isConnector_3015((Connector)domainElement)) break;
                return 3015;
            }
            case 7009: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 7010: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 7011: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 7004: {
                if (!UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7005: {
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3009((Class)domainElement)) {
                    return 3009;
                }
                if (!UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7006: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3011((Property)domainElement)) break;
                return 3011;
            }
            case 7007: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 7008: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3013;
            }
            case 7012: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3017((Property)domainElement)) break;
                return 3017;
            }
            case 7013: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 7014: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3020((Class)domainElement)) break;
                return 3020;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLComponent".equals(containerModelID) && !"UMLComponent".equals(containerModelID)) {
            return false;
        }
        if ("UMLComponent".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2008 == nodeVisualID) {
                    return true;
                }
                if (2009 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5020 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (5021 == nodeVisualID) {
                    return true;
                }
                if (7011 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5005 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (5023 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (5015 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (7008 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (5022 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (5026 == nodeVisualID) {
                    return true;
                }
                if (5027 == nodeVisualID) {
                    return true;
                }
                if (7012 == nodeVisualID) {
                    return true;
                }
                if (7013 == nodeVisualID) {
                    return true;
                }
                if (7014 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (5019 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 3003: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (7009 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (5016 == nodeVisualID) {
                    return true;
                }
                if (5017 == nodeVisualID) {
                    return true;
                }
                if (7010 != nodeVisualID) break;
                return true;
            }
            case 3004: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (5009 != nodeVisualID) break;
                return true;
            }
            case 3006: {
                if (5010 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (5013 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3013 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3017 != nodeVisualID) break;
                return true;
            }
            case 7013: {
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 7014: {
                if (3020 != nodeVisualID) break;
                return true;
            }
            case 4009: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6009 != nodeVisualID) break;
                return true;
            }
            case 4011: {
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6004 == nodeVisualID) {
                    return true;
                }
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6008 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInterfaceRealization_4001((InterfaceRealization)domainElement)) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConnector_4008((Connector)domainElement)) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4009((Dependency)domainElement)) {
            return 4009;
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
            return 4011;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isClass_2004(Class domainElement) {
        Object result = UMLOCLFactory.getExpression(4, (EClassifier)UMLPackage.eINSTANCE.getClass_(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_2007(Class domainElement) {
        Object result = UMLOCLFactory.getExpression(15, (EClassifier)UMLPackage.eINSTANCE.getClass_(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_3004(Class domainElement) {
        Object result = UMLOCLFactory.getExpression(4, (EClassifier)UMLPackage.eINSTANCE.getClass_(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3006(Property domainElement) {
        Object result = UMLOCLFactory.getExpression(7, (EClassifier)UMLPackage.eINSTANCE.getProperty(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConnector_3015(Connector domainElement) {
        Object result = UMLOCLFactory.getExpression(9, (EClassifier)UMLPackage.eINSTANCE.getConnector(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_3009(Class domainElement) {
        Object result = UMLOCLFactory.getExpression(12, (EClassifier)UMLPackage.eINSTANCE.getClass_(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3011(Property domainElement) {
        Object result = UMLOCLFactory.getExpression(17, (EClassifier)UMLPackage.eINSTANCE.getProperty(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3017(Property domainElement) {
        Object result = UMLOCLFactory.getExpression(17, (EClassifier)UMLPackage.eINSTANCE.getProperty(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_3020(Class domainElement) {
        Object result = UMLOCLFactory.getExpression(12, (EClassifier)UMLPackage.eINSTANCE.getClass_(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInterfaceRealization_4001(InterfaceRealization domainElement) {
        Object result = UMLOCLFactory.getExpression(25, (EClassifier)UMLPackage.eINSTANCE.getInterfaceRealization(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConnector_4008(Connector domainElement) {
        Object result = UMLOCLFactory.getExpression(29, (EClassifier)UMLPackage.eINSTANCE.getConnector(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDependency_4009(Dependency domainElement) {
        Object result = UMLOCLFactory.getExpression(31, (EClassifier)UMLPackage.eINSTANCE.getDependency(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (containerView == null) {
            return false;
        }
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }

    public static int getChildDescriptorVisualID(UMLNodeDescriptor container, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        switch (container.getVisualID()) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2004((Class)domainElement)) {
                    return 2004;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2007((Class)domainElement)) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 2009;
            }
            case 2001: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3004((Class)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3006((Property)domainElement)) {
                    return 3006;
                }
                if (!UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isConnector_3015((Connector)domainElement)) break;
                return 3015;
            }
            case 2002: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 2004: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 2005: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 2006: {
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3009((Class)domainElement)) {
                    return 3009;
                }
                if (!UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 2007: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3011((Property)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3013;
            }
            case 2009: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3017((Property)domainElement)) {
                    return 3017;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3018;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isClass_3020((Class)domainElement)) break;
                return 3020;
            }
            case 3001: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_3004((Class)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3006((Property)domainElement)) {
                    return 3006;
                }
                if (!UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isConnector_3015((Connector)domainElement)) break;
                return 3015;
            }
            case 3003: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 3016: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 3004: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
        }
        return -1;
    }

    protected static boolean canSubstitute(int visualId, int substituteCandidate) {
        if (visualId == substituteCandidate) {
            return true;
        }
        switch (visualId) {
            case 2003: {
                return substituteCandidate == 2009;
            }
            case 2004: {
                return substituteCandidate == 2007;
            }
            case 2007: {
                return substituteCandidate == 2004;
            }
            case 2009: {
                return substituteCandidate == 2003;
            }
        }
        return false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate || UMLVisualIDRegistry.canSubstitute(basic, candidate);
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: 
            case 7008: 
            case 7009: 
            case 7010: 
            case 7011: 
            case 7012: 
            case 7013: 
            case 7014: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 2003: 
            case 2008: 
            case 3002: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3014: 
            case 3015: 
            case 3017: 
            case 3018: 
            case 3020: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShortcutDescendant(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram && view != null) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return true;
            }
            view = (View)view.eContainer();
        }
        return false;
    }
}

