/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.activity.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.uml2.diagram.activity.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLFactory;

public class ObjectFlowCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;
    private final Activity container;

    public ObjectFlowCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = ObjectFlowCreateCommand.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof ActivityNode)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof ActivityNode)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canCreateObjectFlow_4002(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResultGen(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        ObjectFlow newElement = UMLFactory.eINSTANCE.createObjectFlow();
        this.getContainer().getEdges().add((Object)newElement);
        newElement.setSource(this.getSource());
        newElement.setTarget(this.getTarget());
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        ObjectFlow newElement = UMLFactory.eINSTANCE.createObjectFlow();
        StructuredActivityNode structuredActivityNode = this.getStructuredActivityNode();
        if (structuredActivityNode != null) {
            structuredActivityNode.getEdges().add((Object)newElement);
        } else {
            this.getContainer().getEdges().add((Object)newElement);
        }
        newElement.setSource(this.getSource());
        newElement.setTarget(this.getTarget());
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(ObjectFlow newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected ActivityNode getSource() {
        return (ActivityNode)this.source;
    }

    protected ActivityNode getTarget() {
        return (ActivityNode)this.target;
    }

    public Activity getContainer() {
        return this.container;
    }

    private StructuredActivityNode getStructuredActivityNode() {
        StructuredActivityNode sourceSAN = this.deduceStructuredActivityNode(this.source);
        if (sourceSAN instanceof StructuredActivityNode && sourceSAN == this.deduceStructuredActivityNode(this.target)) {
            return sourceSAN;
        }
        return null;
    }

    private StructuredActivityNode deduceStructuredActivityNode(EObject object) {
        EObject element = object;
        while (element != null) {
            if (element instanceof StructuredActivityNode) {
                return (StructuredActivityNode)element;
            }
            element = element.eContainer();
        }
        return null;
    }

    private static Activity deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Activity) {
                return (Activity)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

