/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.activity.parser;

import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.uml2.diagram.common.parser.ElementProvider;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.ObjectNodeOrderingKind;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class ObjectNodeAttributesParser
implements ISemanticParser {
    private static final String ORDERING_ATTRIBUTE = "ordering";
    private static final String CONTROL_TYPE_ATTRIBUTE = "isControlType";
    private static final String UPPER_BOUND_ATTRIBUTE = "upperBound";
    private static final String PLUGIN_ID = "org.eclipse.uml2.diagram.activity";
    private ElementProvider elementProvider;

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return this.isAffectingEvent(notification, 0);
    }

    public List<?> getSemanticElementsBeingParsed(EObject eObject) {
        return Collections.singletonList(eObject);
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        ValueSpecification upperBounds;
        boolean isControlType;
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (!(eObject instanceof ObjectNode)) {
            return "";
        }
        ObjectNode objectNode = (ObjectNode)eObject;
        StringBuffer result = new StringBuffer();
        ObjectNodeOrderingKind ordering = objectNode.getOrdering();
        if (!ObjectNodeOrderingKind.FIFO_LITERAL.equals((Object)ordering)) {
            result.append("ordering=");
            result.append(ordering.getName());
        }
        if (isControlType = objectNode.isControlType()) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append("isControlType=true");
        }
        if ((upperBounds = objectNode.getUpperBound()) != null) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append("upperBound=");
            result.append(upperBounds.stringValue());
        }
        return result.toString();
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        CompositeCommand resultCommand = new CompositeCommand("");
        StringTokenizer tokenizer = new StringTokenizer(newString, ",");
        while (tokenizer.hasMoreElements()) {
            NamedElement foundElement;
            String token = tokenizer.nextToken();
            int equalityPosition = token.indexOf("=");
            String key = token.substring(0, equalityPosition);
            String value = token.substring(equalityPosition + 1);
            if (ORDERING_ATTRIBUTE.equals(key)) {
                resultCommand.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.adaptToEObject(element), (EStructuralFeature)UMLPackage.eINSTANCE.getObjectNode_Ordering(), (Object)ObjectNodeOrderingKind.get((String)value))));
                continue;
            }
            if (CONTROL_TYPE_ATTRIBUTE.equals(key)) {
                resultCommand.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.adaptToEObject(element), (EStructuralFeature)UMLPackage.eINSTANCE.getObjectNode_IsControlType(), (Object)Boolean.parseBoolean(value))));
                continue;
            }
            if (!UPPER_BOUND_ATTRIBUTE.equals(key) || (foundElement = this.getElementProvider().findElement(this.adaptToEObject(element), value)) == null || !(foundElement instanceof ValueSpecification)) continue;
            resultCommand.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.adaptToEObject(element), (EStructuralFeature)UMLPackage.eINSTANCE.getObjectNode_UpperBound(), (Object)foundElement)));
        }
        return resultCommand;
    }

    public String getPrintString(IAdaptable element, int flags) {
        StringBuffer result = new StringBuffer(this.getEditString(element, flags));
        if (result.length() > 0) {
            result.insert(0, '{');
            result.append('}');
        }
        return result.toString();
    }

    public boolean isAffectingEvent(Object event, int flags) {
        if (event instanceof Notification) {
            Object feature = ((Notification)event).getFeature();
            return UMLPackage.eINSTANCE.getObjectNode_Ordering().equals(feature) || UMLPackage.eINSTANCE.getObjectNode_IsControlType().equals(feature) || UMLPackage.eINSTANCE.getObjectNode_UpperBound().equals(feature);
        }
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        StringTokenizer tokenizer = new StringTokenizer(editString, ",");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (token.contains("=")) continue;
            return new ParserEditStatus(4, PLUGIN_ID, 1, "Equals sign is not found in one of attributes", null);
        }
        return ParserEditStatus.EDITABLE_STATUS;
    }

    private EObject adaptToEObject(IAdaptable adaptable) {
        return (EObject)adaptable.getAdapter(EObject.class);
    }

    private ElementProvider getElementProvider() {
        if (this.elementProvider == null) {
            this.elementProvider = new ElementProvider();
        }
        return this.elementProvider;
    }
}

