/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.activity.part;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.uml2.diagram.activity.part.Messages;
import org.eclipse.uml2.diagram.activity.part.ModelElementSelectionPage;
import org.eclipse.uml2.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.activity.part.UMLDiagramEditorUtil;
import org.eclipse.uml2.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.NamedElement;

public class UMLNewDiagramFileWizard
extends Wizard {
    private WizardNewFileCreationPage myFileCreationPage;
    private ModelElementSelectionPage diagramRootElementSelectionPage;
    private TransactionalEditingDomain myEditingDomain;

    public UMLNewDiagramFileWizard(URI domainModelURI, EObject diagramRoot, TransactionalEditingDomain editingDomain) {
        assert (domainModelURI != null) : "Domain model uri must be specified";
        assert (diagramRoot != null) : "Doagram root element must be specified";
        assert (editingDomain != null) : "Editing domain must be specified";
        this.createDiagramRootSelectorPage(diagramRoot);
        this.createFileCreationPage(domainModelURI);
        this.myEditingDomain = editingDomain;
    }

    protected WizardNewFileCreationPage getFileCreationPage() {
        return this.myFileCreationPage;
    }

    protected ModelElementSelectionPage getDiagramRootElementSelectionPage() {
        return this.diagramRootElementSelectionPage;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return this.myEditingDomain;
    }

    private void createDiagramRootSelectorPage(EObject diagramRoot) {
        this.diagramRootElementSelectionPage = new DiagramRootElementSelectionPage(Messages.UMLNewDiagramFileWizard_RootSelectionPageName);
        this.diagramRootElementSelectionPage.setTitle(Messages.UMLNewDiagramFileWizard_RootSelectionPageTitle);
        this.diagramRootElementSelectionPage.setDescription(Messages.UMLNewDiagramFileWizard_RootSelectionPageDescription);
        this.diagramRootElementSelectionPage.setModelElement(diagramRoot);
    }

    private void createFileCreationPage(URI domainModelURI) {
        Path filePath;
        this.myFileCreationPage = new WizardNewFileCreationPage(Messages.UMLNewDiagramFileWizard_CreationPageName, (IStructuredSelection)StructuredSelection.EMPTY);
        this.myFileCreationPage.setTitle(Messages.UMLNewDiagramFileWizard_CreationPageTitle);
        this.myFileCreationPage.setDescription(NLS.bind((String)Messages.UMLNewDiagramFileWizard_CreationPageDescription, (Object)"UMLActivity"));
        String fileName = URI.decode((String)domainModelURI.trimFileExtension().lastSegment());
        if (domainModelURI.isPlatformResource()) {
            filePath = new Path(domainModelURI.trimSegments(1).toPlatformString(true));
        } else if (domainModelURI.isFile()) {
            filePath = new Path(domainModelURI.trimSegments(1).toFileString());
        } else {
            throw new IllegalArgumentException("Unsupported URI: " + domainModelURI);
        }
        this.myFileCreationPage.setContainerFullPath((IPath)filePath);
        this.myFileCreationPage.setFileName(UMLDiagramEditorUtil.getUniqueFileName((IPath)filePath, fileName, "umlact"));
        this.myFileCreationPage.setFileExtension("umlact");
    }

    public void addPages() {
        this.addPage((IWizardPage)this.diagramRootElementSelectionPage);
        this.addPage((IWizardPage)this.myFileCreationPage);
    }

    public boolean performFinish() {
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        IFile diagramFile = this.myFileCreationPage.createNewFile();
        UMLDiagramEditorUtil.setCharset(diagramFile);
        affectedFiles.add(diagramFile);
        URI diagramModelURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
        Resource diagramResource = resourceSet.createResource(diagramModelURI);
        CompositeTransactionalCommand result = new CompositeTransactionalCommand(this.myEditingDomain, Messages.UMLNewDiagramFileWizard_InitDiagramCommand);
        AbstractTransactionalCommand command = this.getCreateDiagramCommand(diagramResource, affectedFiles);
        result.add((IUndoableOperation)command);
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)result.reduce(), (IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(UMLDiagramEditorUtil.getSaveOptions());
            UMLDiagramEditorUtil.openDiagram(diagramResource);
        }
        catch (ExecutionException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        catch (IOException ex) {
            UMLDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramModelURI, ex);
        }
        catch (PartInitException ex) {
            UMLDiagramEditorPlugin.getInstance().logError("Unable to open editor", ex);
        }
        return true;
    }

    private AbstractTransactionalCommand getCreateDiagramCommand(final Resource diagramResource, List affectedFiles) {
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.myEditingDomain, Messages.UMLNewDiagramFileWizard_InitDiagramCommand, affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int diagramVID = UMLVisualIDRegistry.getDiagramVisualID(UMLNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement());
                if (diagramVID != 1000) {
                    return CommandResult.newErrorCommandResult((String)Messages.UMLNewDiagramFileWizard_IncorrectRootError);
                }
                Diagram diagram = null;
                diagram = ViewService.createDiagram((EObject)UMLNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement(), (String)"UMLActivity", (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        return command;
    }

    private static class DiagramRootElementSelectionPage
    extends ModelElementSelectionPage {
        protected DiagramRootElementSelectionPage(String pageName) {
            super(pageName);
        }

        @Override
        protected String getSelectionTitle() {
            return Messages.UMLNewDiagramFileWizard_RootSelectionPageSelectionTitle;
        }

        @Override
        protected boolean validatePage() {
            if (this.selectedModelElement == null) {
                this.setErrorMessage(Messages.UMLNewDiagramFileWizard_RootSelectionPageNoSelectionMessage);
                return false;
            }
            boolean result = ViewService.getInstance().provides((IOperation)new CreateDiagramViewOperation((IAdaptable)new EObjectAdapter(this.selectedModelElement), "UMLActivity", UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT));
            this.setErrorMessage(result ? null : Messages.UMLNewDiagramFileWizard_RootSelectionPageInvalidSelectionMessage);
            return result;
        }

        public IWizardPage getNextPage() {
            IWizardPage nextPage = super.getNextPage();
            if (nextPage instanceof WizardNewFileCreationPage) {
                String fileName = ((NamedElement)this.getModelElement()).getName();
                WizardNewFileCreationPage fileCreationPage = (WizardNewFileCreationPage)nextPage;
                fileCreationPage.setFileName(UMLDiagramEditorUtil.getUniqueFileName(fileCreationPage.getContainerFullPath(), fileName, "umlact"));
            }
            return nextPage;
        }
    }
}

