/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.activity.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.common.ui.preferences.CheckBoxFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.uml2.diagram.activity.part.Messages;
import org.eclipse.uml2.diagram.activity.part.UMLDiagramEditor;
import org.eclipse.uml2.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.activity.providers.UMLElementTypes;
import org.eclipse.uml2.diagram.common.preferences.IconStylePreferencePage;

public class DiagramIconStylePreferencePage
extends IconStylePreferencePage {
    private static Map<String, Integer> ourConnectorLabels2Vids = new HashMap<String, Integer>();
    private final List<CheckBoxFieldEditor> myByVisualIdEditors = new ArrayList<CheckBoxFieldEditor>();
    private RadioGroupFieldEditor myModeEditor;
    private Composite myCheckBoxesPanel;
    private IWorkbench myWorkbench;

    static {
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_ControlFlowName_6003, 6003);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_ControlFlowName_6005, 6005);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_ControlFlowName_6007, 6007);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_ObjectFlowName_6004, 6004);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_ObjectFlowName_6006, 6006);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_ObjectFlowName_6008, 6008);
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_ExceptionHandlerLabel_6002, 6002);
    }

    public static void initConnectorLabelDefaults(IPreferenceStore store) {
        for (Integer visualId : ourConnectorLabels2Vids.values()) {
            store.setDefault(DiagramIconStylePreferencePage.getConnectionLabelPreference((int)visualId), true);
        }
    }

    public DiagramIconStylePreferencePage() {
        this.setPreferenceStore(UMLDiagramEditorPlugin.getInstance().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        super.init(workbench);
        this.myWorkbench = workbench;
    }

    public boolean performOk() {
        super.performOk();
        UMLElementTypes.refreshImageRegistry();
        this.refreshDiagramEditors();
        return true;
    }

    private void refreshDiagramEditors() {
        IEditorReference[] editors = this.myWorkbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i].getEditor(false);
            if (editor != null && editor instanceof UMLDiagramEditor) {
                ((UMLDiagramEditor)editor).refresh();
            }
            ++i;
        }
    }

    protected void initHelp() {
    }

    protected void addFields(Composite parent) {
        super.addFields(parent);
        this.createShowHideIconsGroup(parent);
        this.createShowHideConnectorIconsGroup(parent);
    }

    protected CheckBoxFieldEditor addCheckBoxForVisualIds(Composite parent, String commonLabel, int ... visualIds) {
        StringBuffer propertyName = new StringBuffer("show.visual.id");
        int[] nArray = visualIds;
        int n = visualIds.length;
        int n2 = 0;
        while (n2 < n) {
            int nextVID = nArray[n2];
            propertyName.append('.').append(nextVID);
            ++n2;
        }
        CheckBoxFieldEditor result = new CheckBoxFieldEditor(propertyName.toString(), commonLabel, parent);
        this.addField((FieldEditor)result);
        this.myByVisualIdEditors.add(result);
        return result;
    }

    protected void initialize() {
        super.initialize();
        boolean stateShowSelected = "show.selected.visual.ids".equals(this.getPreferenceStore().getString("iconstyle.show-hide.mode"));
        this.enableVisualIdChoices(stateShowSelected);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if ("field_editor_value".equals(event.getProperty())) {
            boolean nowConfigurable = "show.selected.visual.ids".equals(event.getNewValue());
            boolean wasConfigurable = "show.selected.visual.ids".equals(event.getOldValue());
            if (nowConfigurable || wasConfigurable) {
                this.enableVisualIdChoices(nowConfigurable);
            }
        }
    }

    private void enableVisualIdChoices(boolean enabled) {
        for (CheckBoxFieldEditor next : this.myByVisualIdEditors) {
            next.setEnabled(enabled, this.myCheckBoxesPanel);
        }
    }

    private Composite createShowHideIconsGroup(Composite parent) {
        Composite showHideIconsGroup = new Composite(parent, 0);
        showHideIconsGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        showHideIconsGroup.setLayout((Layout)layout);
        String[][] choices = new String[][]{{LABEL_HIDE_ALL, "hide.all"}, {LABEL_SHOW_ALL, "show.all"}, {LABEL_SHOW_BY_VISUAL_ID, "show.selected.visual.ids"}};
        this.myModeEditor = new RadioGroupFieldEditor("iconstyle.show-hide.mode", LABEL_SHOW_HIDE_MODE, 1, choices, showHideIconsGroup, true);
        this.addField((FieldEditor)this.myModeEditor);
        Composite e = this.createExpansibleComposite(this.myModeEditor.getRadioBoxControl(showHideIconsGroup), "Elements");
        this.myCheckBoxesPanel = new Composite(e, 0);
        this.myCheckBoxesPanel.setLayout((Layout)new GridLayout());
        this.myCheckBoxesPanel.setLayoutData((Object)new GridData(768));
        this.addAllCheckBoxes(this.myCheckBoxesPanel);
        this.enableVisualIdChoices(false);
        return showHideIconsGroup;
    }

    private void addAllCheckBoxes(Composite parent) {
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Activity, 5030);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_ActivityParameterNode, 5031);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_AddStructuralFeatureValueAction, 5026, 5020, 5077);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_CallBehaviorAction, 5027, 5018, 5078);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_CallOperationAction, 5028, 5019, 5079);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_CentralBufferNode, 5032, 5033, 5070);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Comment, 5151);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_ConditionalNode, 5147, 5115, 5092);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_CreateObjectAction, 5025, 5017, 5076);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_DataStoreNode, 5034, 5035, 5067);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_InputPin, 5047, 5081);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_LiteralString, 3049, 3051);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_LoopNode, 5117, 5091);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_OpaqueAction, 5023, 5015, 5073);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_OutputPin, 5048, 5083);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Pin, 5024, 5016, 5074);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_StructuredActivityNode, 5090, 5089, 5122, 5121);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_ValueSpecificationAction, 5133, 5135);
    }

    private Composite createShowHideConnectorIconsGroup(Composite parent) {
        IconStylePreferencePage.ShowHideConnectorLabelGroup builder = new IconStylePreferencePage.ShowHideConnectorLabelGroup((IconStylePreferencePage)this);
        return builder.createShowHideConnectorLabelGroup(parent, ourConnectorLabels2Vids);
    }
}

