/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.parser;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.uml2.diagram.parser.ExternalParserException;
import org.eclipse.uml2.diagram.parser.lookup.Lookup;
import org.eclipse.uml2.diagram.parser.lookup.LookupResolveRequest;
import org.eclipse.uml2.diagram.parser.lookup.LookupResolver;
import org.eclipse.uml2.diagram.parser.lookup.LookupSuite;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class ExternalParserBase {
    private LookupSuite myLookups = LookupSuite.NULL_SUITE;
    private LookupResolver myLookupResolver = LookupResolver.NULL;
    private EObject myContext;

    public abstract EClass getSubjectClass();

    public abstract void parse(EObject var1, String var2) throws ExternalParserException;

    public final EObject parseNewObject(EObject context, String text) throws ExternalParserException {
        this.myContext = context;
        try {
            EObject result = this.createSubjectPrototype();
            this.parse(result, text);
            EObject eObject = result;
            return eObject;
        }
        finally {
            this.myContext = null;
        }
    }

    public final void parse(EObject target, String text, EObject context) throws ExternalParserException {
        this.myContext = context;
        try {
            this.parse(target, text);
        }
        finally {
            this.myContext = null;
        }
    }

    public final void setLookupSuite(LookupSuite suite) {
        this.myLookups = suite;
        if (this.myLookups == null) {
            this.myLookups = LookupSuite.NULL_SUITE;
        }
    }

    public final void setLookupResolver(LookupResolver lookupResolver) {
        this.myLookupResolver = lookupResolver;
        if (this.myLookupResolver == null) {
            this.myLookupResolver = LookupResolver.NULL;
        }
    }

    public final LookupSuite getLookupSuite() {
        return this.myLookups;
    }

    public final <T> T lookup(Class<T> clazz, String name) {
        Lookup<T> lookup = this.getLookupSuite().getLookup(clazz);
        return lookup.lookup(name, this.getContext());
    }

    public EObject createSubjectPrototype() {
        EClass subjectClass = this.getSubjectClass();
        return subjectClass.getEPackage().getEFactoryInstance().create(subjectClass);
    }

    protected final EObject getContext() {
        return this.myContext;
    }

    protected final void checkContext() {
        if (this.getContext() == null) {
            throw new IllegalStateException("I need context element to perform lookups");
        }
    }

    protected <T extends NamedElement> void applyLookup(Class<T> clazz, String name, LookupResolver.Callback callback) {
        Lookup<T> lookup = this.getLookupSuite().getLookup(clazz);
        NamedElement result = (NamedElement)lookup.lookup(name, this.getContext());
        if (result != null) {
            callback.lookupResolved(result);
            return;
        }
        List<IElementType> allowedTypes = lookup.getResolutionElementTypes();
        if (allowedTypes.isEmpty()) {
            return;
        }
        LookupResolveRequest request = new LookupResolveRequest(allowedTypes, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), name);
        this.myLookupResolver.addLookupResolveRequest(request, callback);
    }
}

