/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.parser;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.uml2.diagram.parser.ApplyStrategy;
import org.eclipse.uml2.diagram.parser.ExternalParserBase;
import org.eclipse.uml2.diagram.parser.ExternalParserException;
import org.eclipse.uml2.diagram.parser.ExternalToString;
import org.eclipse.uml2.diagram.parser.lookup.LookupResolver;
import org.eclipse.uml2.diagram.parser.lookup.LookupResolverImpl;
import org.eclipse.uml2.diagram.parser.lookup.LookupSuite;
import org.eclipse.uml2.internal.diagram.parser.MDTDiagramParserPlugin;

public class ParserAdapter
implements IParser {
    private static final String NOT_AN_OBJECT = "Unknown";
    private final ExternalParserBase myDelegate;
    private final EObject myTester;
    private final ApplyStrategy myApplier;
    private final ExternalToString myView;
    private final ExternalToString myEdit;
    private static final MessageFormatEscaper ourMessageFormatEscaper = new MessageFormatEscaper();

    public ParserAdapter(ExternalParserBase delegate, ApplyStrategy applier) {
        this(delegate, applier, ExternalToString.NOT_IMPLEMENTED);
    }

    public ParserAdapter(ExternalParserBase delegate, ApplyStrategy applier, ExternalToString viewAndEdit) {
        this(delegate, applier, viewAndEdit, viewAndEdit);
    }

    public ParserAdapter(ExternalParserBase delegate, ApplyStrategy applier, ExternalToString view, ExternalToString edit) {
        this.myDelegate = delegate;
        this.myApplier = applier;
        this.myView = view;
        this.myEdit = edit;
        this.myTester = this.myDelegate.createSubjectPrototype();
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getToString(element, flags, this.myEdit);
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.getToString(element, flags, this.myView);
    }

    public final boolean isAffectingEvent(Object event, int flags) {
        return this.isAffectingEvent(event);
    }

    protected boolean isAffectingEvent(Object event) {
        if (event instanceof Notification) {
            Object feature = ((Notification)event).getFeature();
            return feature instanceof EStructuralFeature && this.myView.isAffectingFeature((EStructuralFeature)feature);
        }
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable adapter, String editString) {
        EObject modelObject = (EObject)adapter.getAdapter(EObject.class);
        if (modelObject == null) {
            return new ParserEditStatus(MDTDiagramParserPlugin.getPluginID(), 1, "Can not find context object");
        }
        LookupSuite oldLookup = this.myDelegate.getLookupSuite();
        try {
            this.myDelegate.setLookupSuite(LookupSuite.NULL_SUITE);
            this.myDelegate.parse(this.myTester, editString, modelObject);
            ParserEditStatus parserEditStatus = ParserEditStatus.EDITABLE_STATUS;
            return parserEditStatus;
        }
        catch (ExternalParserException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "";
            }
            message = ourMessageFormatEscaper.getEscaped(message);
            ParserEditStatus parserEditStatus = new ParserEditStatus(MDTDiagramParserPlugin.getPluginID(), 1, "Invalid input: " + message);
            return parserEditStatus;
        }
        finally {
            this.myDelegate.setLookupSuite(oldLookup);
        }
    }

    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        EObject parsed;
        final EObject modelObject = (EObject)adapter.getAdapter(EObject.class);
        if (modelObject == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)modelObject);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        DiagramEditPart diagramEditPart = (DiagramEditPart)adapter.getAdapter(DiagramEditPart.class);
        LookupResolver resolver = LookupResolver.NULL;
        if (diagramEditPart != null) {
            resolver = new LookupResolverImpl((IGraphicalEditPart)diagramEditPart);
        }
        this.myDelegate.setLookupResolver(resolver);
        try {
            try {
                parsed = this.myDelegate.parseNewObject(modelObject, newString);
            }
            catch (ExternalParserException e) {
                UnexecutableCommand unexecutableCommand = UnexecutableCommand.INSTANCE;
                this.myDelegate.setLookupResolver(null);
                return unexecutableCommand;
            }
        }
        finally {
            this.myDelegate.setLookupResolver(null);
        }
        LinkedList<AbstractTransactionalCommand> commandList = new LinkedList<AbstractTransactionalCommand>();
        if (resolver.canResolve()) {
            AbstractTransactionalCommand resolveCommand = resolver.getResolveCommand();
            AbstractTransactionalCommand computeAndApplyCommand = new AbstractTransactionalCommand(editingDomain, "", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    for (ICommand next : ParserAdapter.this.myApplier.apply(modelObject, parsed)) {
                        next.execute(monitor, info);
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            commandList.add(resolveCommand);
            commandList.add(computeAndApplyCommand);
        } else {
            commandList.addAll(this.myApplier.apply(modelObject, parsed));
        }
        return new CompositeTransactionalCommand(editingDomain, this.getCommandLabel(commandList), commandList);
    }

    protected final ExternalToString getViewToString() {
        return this.myView;
    }

    private String getToString(IAdaptable element, int flags, ExternalToString toString) {
        EObject modelObject = (EObject)element.getAdapter(EObject.class);
        return this.isValidElement(modelObject) ? toString.getToString(modelObject, flags) : NOT_AN_OBJECT;
    }

    private String getCommandLabel(List commandList) {
        return "-not-implemented-";
    }

    protected final boolean isValidElement(Object object) {
        return object != null && this.myDelegate.getSubjectClass().isInstance(object);
    }

    private static class MessageFormatEscaper {
        private final char S_QUOTE = (char)39;

        private MessageFormatEscaper() {
        }

        public String getEscaped(String input) {
            if (!input.contains("'")) {
                return "'" + input + "'";
            }
            StringBuffer result = new StringBuffer(input.length() + 5);
            result.append('\'');
            int i = 0;
            while (i < input.length()) {
                char next = result.charAt(i);
                if (next == '\'') {
                    result.append('\'');
                }
                result.append(next);
                ++i;
            }
            result.append('\'');
            return result.toString();
        }
    }
}

