/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.parser.assist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.uml2.diagram.parser.assist.CompletionProcessorBase;
import org.eclipse.uml2.diagram.parser.lookup.Lookup;
import org.eclipse.uml2.uml.NamedElement;

public abstract class LookupCompletionProcessor<T extends NamedElement>
extends CompletionProcessorBase {
    protected static final Comparator<NamedElement> BY_NAME_COMPARATOR = new Comparator<NamedElement>(){

        @Override
        public int compare(NamedElement first, NamedElement second) {
            return first.getName().compareTo(second.getName());
        }
    };
    private final Lookup<T> myLookup;
    private final ILabelProvider myProposalsLabelProvider;

    protected abstract String getProposalPrefix(String var1);

    public LookupCompletionProcessor(Lookup<T> lookup, ILabelProvider proposalsLabelProvider) {
        this.myLookup = lookup;
        this.myProposalsLabelProvider = proposalsLabelProvider;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl subjectControl, int offset) {
        if (this.getContext() == null) {
            return NO_PROPOSALS;
        }
        String prefix = this.getControlTextBeforeSelection(subjectControl);
        String proposalPrefix = this.getProposalPrefix(prefix);
        if (proposalPrefix == null) {
            return NO_PROPOSALS;
        }
        List<T> proposedEObjects = this.computeLookupProposals(this.getContext());
        List<ICompletionProposal> proposals = this.createProposals(subjectControl.getSelectedRange(), proposalPrefix, proposedEObjects);
        return proposals.toArray(NO_PROPOSALS);
    }

    protected List<T> computeLookupProposals(EObject context) {
        List<T> resultList = this.myLookup.computeScope(context);
        Collections.sort(resultList, BY_NAME_COMPARATOR);
        return resultList;
    }

    protected List<ICompletionProposal> createProposals(Point selection, String proposalPrefix, List<T> proposals) {
        String ignoreCasePrefix = proposalPrefix.toLowerCase();
        int prefixLength = proposalPrefix.length();
        int selectionStart = selection.x;
        int selectionLength = selection.y;
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>(proposals.size());
        for (NamedElement next : proposals) {
            String nextName;
            if (next == null || (nextName = next.getName()) == null || !nextName.toLowerCase().startsWith(ignoreCasePrefix)) continue;
            Image image = this.getProposalImage(next);
            CompletionProposal proposal = new CompletionProposal(nextName, selectionStart - prefixLength, selectionLength + prefixLength, nextName.length(), image, nextName, null, null);
            result.add((ICompletionProposal)proposal);
        }
        return result;
    }

    protected Image getProposalImage(T proposedEObject) {
        return this.myProposalsLabelProvider == null ? null : this.myProposalsLabelProvider.getImage(proposedEObject);
    }

    protected static final String trimLeft(String text) {
        return text.startsWith(" ") ? text.replaceAll("\\A\\s+", "") : text;
    }
}

