/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.profile.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class ExtensionReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ExtensionReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Extension)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Stereotype) || !(this.newEnd instanceof Stereotype)) {
            return false;
        }
        Stereotype source = (Stereotype)this.newEnd;
        Profile profile = (Profile)this.getLink().eContainer();
        Class metaclass = this.getLink().getMetaclass();
        ElementImport target = profile.getElementImport((PackageableElement)metaclass, false);
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistExtension_4002((Package)profile, this.getLink(), source, target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ElementImport) || !(this.newEnd instanceof ElementImport)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Profile)) {
            return false;
        }
        Profile profile = (Profile)this.getLink().eContainer();
        Stereotype source = this.getLink().getStereotype();
        ElementImport target = (ElementImport)this.newEnd;
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistExtension_4002((Package)profile, this.getLink(), source, target);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        Extension extension = this.getLink();
        Stereotype oldSource = (Stereotype)this.oldEnd;
        Stereotype newStereotype = (Stereotype)this.newEnd;
        this.replaceStereotype(extension, newStereotype);
        return CommandResult.newOKCommandResult((Object)extension);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        Extension extension = (Extension)this.getElementToEdit();
        ElementImport oldTarget = (ElementImport)this.oldEnd;
        ElementImport newTarget = (ElementImport)this.newEnd;
        Class newMetaclass = (Class)newTarget.getImportedElement();
        this.replaceMetaclass(extension, newMetaclass);
        return CommandResult.newOKCommandResult((Object)extension);
    }

    private void replaceMetaclass(Extension extension, Class newMetaclass) {
        Stereotype stereotype = extension.getStereotype();
        if (stereotype == null) {
            return;
        }
        String newExtensionName = String.valueOf(newMetaclass.getName()) + "_" + stereotype.getName();
        extension.setName(newExtensionName);
        Property metaclassEnd = extension.metaclassEnd();
        String newPropertyName = "base_" + newMetaclass.getName();
        if (metaclassEnd == null) {
            Property newMetaclassEnd = stereotype.createOwnedAttribute(newPropertyName, (Type)newMetaclass);
        } else {
            metaclassEnd.setName(newPropertyName);
            metaclassEnd.setType((Type)newMetaclass);
        }
    }

    private void replaceStereotype(Extension extension, Stereotype newStereotype) {
        Class metaclass = extension.getMetaclass();
        if (metaclass == null) {
            return;
        }
        Property metaclassEnd = extension.metaclassEnd();
        if (metaclassEnd != null) {
            metaclassEnd.destroy();
        }
        Property newMetaclassEnd = newStereotype.createOwnedAttribute("base_" + metaclass.getName(), (Type)metaclass);
        newMetaclassEnd.setAssociation((Association)extension);
        String newExtensionName = String.valueOf(metaclass.getName()) + "_" + newStereotype.getName();
        extension.setName(newExtensionName);
        Property stereotypeEnd = extension.getStereotypeEnd();
        String stereotypeEndName = "extension_" + newStereotype.getName();
        if (stereotypeEnd == null) {
            ExtensionEnd extensionEnd = (ExtensionEnd)extension.createOwnedEnd(stereotypeEndName, (Type)newStereotype, UMLPackage.Literals.EXTENSION_END);
            extensionEnd.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        } else {
            stereotypeEnd.setType((Type)newStereotype);
            stereotypeEnd.setName(stereotypeEndName);
        }
    }

    protected Extension getLink() {
        return (Extension)this.getElementToEdit();
    }

    protected Stereotype getOldSource() {
        return (Stereotype)this.oldEnd;
    }

    protected Stereotype getNewSource() {
        return (Stereotype)this.newEnd;
    }

    protected ElementImport getOldTarget() {
        return (ElementImport)this.oldEnd;
    }

    protected ElementImport getNewTarget() {
        return (ElementImport)this.newEnd;
    }
}

