/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.editpolicies.UpdateDescriptionRequest;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.profile.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.profile.part.UMLLinkDescriptor;
import org.eclipse.uml2.diagram.profile.part.UMLNodeDescriptor;
import org.eclipse.uml2.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.UMLPackage;

public class ProfileCanonicalEditPolicy
extends CanonicalEditPolicy {
    private Set<EStructuralFeature> myFeaturesToSynchronize;

    protected void refreshOnActivate() {
        List c = this.getHost().getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).activate();
            ++i;
        }
        super.refreshOnActivate();
    }

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        List<UMLNodeDescriptor> childDescriptors = UMLDiagramUpdater.getSemanticChildren(viewObject);
        for (UMLNodeDescriptor d : childDescriptors) {
            result.add(d.getModelElement());
        }
        return result;
    }

    protected boolean isOrphaned(Collection<EObject> semanticChildren, View view) {
        if (view.getEAnnotation("Shortcut") != null) {
            return UMLDiagramUpdater.isShortcutOrphaned(view);
        }
        return this.isMyDiagramElement(view) ? !semanticChildren.contains(view.getElement()) : this.isDefinitelyNotMyDiagramElement(view);
    }

    private boolean isDefinitelyNotMyDiagramElement(View view) {
        int visualID = UMLVisualIDRegistry.getVisualID(view);
        switch (visualID) {
            case 3001: 
            case 3003: 
            case 3005: 
            case 3008: 
            case 3009: 
            case 3010: {
                return true;
            }
        }
        return false;
    }

    private boolean isMyDiagramElement(View view) {
        int visualID = UMLVisualIDRegistry.getVisualID(view);
        switch (visualID) {
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: {
                return true;
            }
        }
        return false;
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet<EStructuralFeature>();
            this.myFeaturesToSynchronize.add((EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement());
            this.myFeaturesToSynchronize.add((EStructuralFeature)UMLPackage.eINSTANCE.getNamespace_ElementImport());
            this.myFeaturesToSynchronize.add((EStructuralFeature)UMLPackage.eINSTANCE.getElement_OwnedComment());
        }
        return this.myFeaturesToSynchronize;
    }

    protected void refreshSemantic() {
        if (this.resolveSemanticElement() == null) {
            return;
        }
        LinkedList<IAdaptable> createdViews = new LinkedList<IAdaptable>();
        List<UMLNodeDescriptor> childDescriptors = UMLDiagramUpdater.getSemanticChildren((View)this.getHost().getModel());
        LinkedList<Object> orphaned = new LinkedList<Object>();
        LinkedList<View> knownViewChildren = new LinkedList<View>();
        for (View v : this.getViewChildren()) {
            if (this.isMyDiagramElement(v)) {
                knownViewChildren.add(v);
            }
            if (v.getEAnnotation("Shortcut") != null && UMLDiagramUpdater.isShortcutOrphaned(v)) {
                orphaned.add(v);
                continue;
            }
            knownViewChildren.remove(v);
        }
        HashMap potentialViews = new HashMap();
        Iterator<UMLNodeDescriptor> descriptorsIterator = childDescriptors.iterator();
        while (descriptorsIterator.hasNext()) {
            UMLNodeDescriptor next = descriptorsIterator.next();
            String hint = UMLVisualIDRegistry.getType(next.getVisualID());
            LinkedList perfectMatch = new LinkedList();
            LinkedList<View> potentialMatch = new LinkedList<View>();
            for (View childView : this.getViewChildren()) {
                EObject semanticElement = childView.getElement();
                if (!next.getModelElement().equals(semanticElement)) continue;
                if (UMLVisualIDRegistry.checkNodeVisualID((View)this.getHost().getModel(), semanticElement, next.getVisualID())) {
                    perfectMatch.add(childView);
                    continue;
                }
                potentialMatch.add(childView);
            }
            if (perfectMatch.size() > 0) {
                descriptorsIterator.remove();
                knownViewChildren.remove(perfectMatch.getLast());
                continue;
            }
            if (potentialMatch.size() <= 0) continue;
            potentialViews.put(next, potentialMatch);
        }
        orphaned.addAll(knownViewChildren);
        CompositeTransactionalCommand boundsCommand = new CompositeTransactionalCommand(this.host().getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize);
        ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>(childDescriptors.size());
        for (UMLNodeDescriptor next : childDescriptors) {
            String hint = UMLVisualIDRegistry.getType(next.getVisualID());
            CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(next.getModelElement(), hint);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, hint, -1, false, this.host().getDiagramPreferencesHint());
            viewDescriptors.add(descriptor);
            LinkedList possibleMatches = (LinkedList)potentialViews.get(next);
            if (possibleMatches != null) {
                possibleMatches.retainAll(knownViewChildren);
            }
            if (possibleMatches == null || possibleMatches.isEmpty()) continue;
            View originalView = (View)possibleMatches.getFirst();
            knownViewChildren.remove(originalView);
            if (!(originalView instanceof Node)) continue;
            if (((Node)originalView).getLayoutConstraint() instanceof Bounds) {
                Bounds b = (Bounds)((Node)originalView).getLayoutConstraint();
                boundsCommand.add((IUndoableOperation)new SetBoundsCommand(boundsCommand.getEditingDomain(), boundsCommand.getLabel(), (IAdaptable)descriptor, new Rectangle(b.getX(), b.getY(), b.getWidth(), b.getHeight())));
                continue;
            }
            if (((Node)originalView).getLayoutConstraint() instanceof Location) {
                Location l = (Location)((Node)originalView).getLayoutConstraint();
                boundsCommand.add((IUndoableOperation)new SetBoundsCommand(boundsCommand.getEditingDomain(), boundsCommand.getLabel(), (IAdaptable)descriptor, new Point(l.getX(), l.getY())));
                continue;
            }
            if (!(((Node)originalView).getLayoutConstraint() instanceof Size)) continue;
            Size s = (Size)((Node)originalView).getLayoutConstraint();
            boundsCommand.add((IUndoableOperation)new SetBoundsCommand(boundsCommand.getEditingDomain(), boundsCommand.getLabel(), (IAdaptable)descriptor, new Dimension(s.getWidth(), s.getHeight())));
        }
        boolean changed = this.deleteViews(orphaned.iterator());
        CreateViewRequest request = this.getCreateViewRequest(viewDescriptors);
        Command cmd = this.getCreateViewCommand((CreateRequest)request);
        if (cmd != null && cmd.canExecute()) {
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
            this.executeCommand(cmd);
            if (boundsCommand.canExecute()) {
                this.executeCommand((Command)new ICommandProxy(boundsCommand.reduce()));
            }
            List nl = (List)request.getNewObject();
            createdViews.addAll(nl);
        }
        if (changed || createdViews.size() > 0) {
            this.postProcessRefreshSemantic(createdViews);
        }
        Collection<IAdaptable> createdConnectionViews = this.refreshConnections();
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private Collection<UMLLinkDescriptor> collectLinksOutgoingFromShortcut(View view, Map<EObject, View> domain2NotationMap) {
        EditPart ep = (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        if (!(ep instanceof IGraphicalEditPart)) {
            return Collections.emptyList();
        }
        IGraphicalEditPart editPart = (IGraphicalEditPart)ep;
        UpdateDescriptionRequest request = new UpdateDescriptionRequest();
        editPart.getCommand((Request)request);
        HashSet<UMLLinkDescriptor> linksToFromShortcuts = new HashSet<UMLLinkDescriptor>();
        for (UpdateDescriptionRequest.Descriptor next : request.getDescriptions()) {
            List containedLinks = next.getContainedLinks();
            for (IUpdaterLinkDescriptor ld : containedLinks) {
                if (!(ld instanceof UMLLinkDescriptor)) continue;
                linksToFromShortcuts.add((UMLLinkDescriptor)ld);
            }
            List outgoingLinks = next.getOutgoingLinks();
            for (IUpdaterLinkDescriptor ld : outgoingLinks) {
                if (!(ld instanceof UMLLinkDescriptor)) continue;
                linksToFromShortcuts.add((UMLLinkDescriptor)ld);
            }
            if (next.getSemanticElement() == null) continue;
            domain2NotationMap.put(next.getSemanticElement(), next.getProvider().getNotationView());
        }
        return linksToFromShortcuts;
    }

    private Collection<IAdaptable> refreshConnections() {
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        Collection<UMLLinkDescriptor> linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        block0: while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = UMLVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator<UMLLinkDescriptor> linkDescriptorsIterator = linkDescriptors.iterator();
            while (linkDescriptorsIterator.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = linkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                linkDescriptorsIterator.remove();
                continue block0;
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection<UMLLinkDescriptor> collectAllLinks(View view, Map<EObject, View> domain2NotationMap) {
        if (!"UMLProfile".equals(UMLVisualIDRegistry.getModelID(view))) {
            return Collections.emptyList();
        }
        if (view != null && view.getEAnnotation("Shortcut") != null) {
            return this.collectLinksOutgoingFromShortcut(view, domain2NotationMap);
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProfile_1000ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getStereotype_2001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProfile_2002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getEnumeration_2003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getElementImport_2006ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProfile_2007ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConstraint_2008ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getComment_2009ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConstraint_3008ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3010: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getImage_3010ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getStereotype_3003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getEnumerationLiteral_3005ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getElementImport_3009ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getGeneralization_4001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getExtension_4002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection<IAdaptable> createConnections(Collection<UMLLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (UMLLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPart(nextLinkDescriptor.getSource(), domain2NotationMap);
            EditPart targetEditPart = this.getEditPart(nextLinkDescriptor.getDestination(), domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), UMLVisualIDRegistry.getType(nextLinkDescriptor.getVisualID()), -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Map<EObject, View> domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }
}

