/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.part;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistryExt;
import org.eclipse.uml2.diagram.profile.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.profile.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.profile.part.UMLNodeDescriptor;
import org.eclipse.uml2.diagram.profile.part.VisualIDRegistryExtension;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.uml2.diagram.profile/debug/visualID";
    public static final IVisualIDRegistry TYPED_ADAPTER = new IVisualIDRegistryExt(){
        private VisualIDRegistryExtension myExtension = new VisualIDRegistryExtension();

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }

        public boolean isShortcutDescendant(View view) {
            return UMLVisualIDRegistry.isShortcutDescendant(view);
        }

        public List<String> getAllHintedTypes() {
            return this.myExtension.getAllHintedTypes();
        }

        public List<IVisualIDRegistryExt.MenuTypeHint> getMenuTypeHints(String type) {
            return this.myExtension.getMenuTypeHints(type);
        }

        public String getSemanticHint(View childView, View newParentView) {
            return this.myExtension.getSemanticHint(childView, newParentView);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLProfile".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Profile)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLProfile".equals(containerModelID) && !"UMLProfile".equals(containerModelID)) {
            return -1;
        }
        if ("UMLProfile".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (containerView instanceof Diagram && domainElement != null && domainElement.equals(containerView.getElement())) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isStereotype_2001((Stereotype)domainElement)) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isElementImport_2006((ElementImport)domainElement)) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                return 2009;
            }
            case 7001: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) break;
                return 3001;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7006: {
                if (!UMLPackage.eINSTANCE.getImage().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7004: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7005: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isElementImport_3009((ElementImport)domainElement)) break;
                return 3009;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLProfile".equals(containerModelID) && !"UMLProfile".equals(containerModelID)) {
            return false;
        }
        if ("UMLProfile".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2008 == nodeVisualID) {
                    return true;
                }
                if (2009 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (5013 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (5015 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (5014 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getExtension().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        return -1;
    }

    private static boolean isDiagram(Profile element) {
        return true;
    }

    private static boolean isStereotype_2001(Stereotype domainElement) {
        Object result = UMLOCLFactory.getExpression(0, (EClassifier)UMLPackage.eINSTANCE.getStereotype(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isElementImport_2006(ElementImport domainElement) {
        Object result = UMLOCLFactory.getExpression(11, (EClassifier)UMLPackage.eINSTANCE.getElementImport(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3001(Property domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getProperty(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isElementImport_3009(ElementImport domainElement) {
        Object result = UMLOCLFactory.getExpression(12, (EClassifier)UMLPackage.eINSTANCE.getElementImport(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (containerView == null) {
            return false;
        }
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }

    public static int getChildDescriptorVisualID(UMLNodeDescriptor container, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        switch (container.getVisualID()) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isStereotype_2001((Stereotype)domainElement)) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isElementImport_2006((ElementImport)domainElement)) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                return 2009;
            }
            case 2001: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3001((Property)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (!UMLPackage.eINSTANCE.getImage().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 2002: {
                if (!UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 2003: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 2007: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isElementImport_3009((ElementImport)domainElement)) break;
                return 3009;
            }
        }
        return -1;
    }

    protected static boolean canSubstitute(int visualId, int substituteCandidate) {
        return visualId == substituteCandidate;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate || UMLVisualIDRegistry.canSubstitute(basic, candidate);
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 2006: 
            case 2008: 
            case 2009: 
            case 3001: 
            case 3003: 
            case 3005: 
            case 3008: 
            case 3009: 
            case 3010: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShortcutDescendant(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram && view != null) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return true;
            }
            view = (View)view.eContainer();
        }
        return false;
    }
}

