/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.common.conventions.ConnectorEndConvention;
import org.eclipse.uml2.diagram.csd.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.StructuredClassifier;

public class ConnectorReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ConnectorReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Connector)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ConnectableElement) || !(this.newEnd instanceof ConnectableElement)) {
            return false;
        }
        ConnectableElement target = ConnectorEndConvention.getSourceEnd((Connector)this.getLink()).getRole();
        if (!(this.getLink().eContainer() instanceof StructuredClassifier)) {
            return false;
        }
        StructuredClassifier container = (StructuredClassifier)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistConnector_4005(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ConnectableElement) || !(this.newEnd instanceof ConnectableElement)) {
            return false;
        }
        ConnectableElement source = ConnectorEndConvention.getTargetEnd((Connector)this.getLink()).getRole();
        if (!(this.getLink().eContainer() instanceof StructuredClassifier)) {
            return false;
        }
        StructuredClassifier container = (StructuredClassifier)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistConnector_4005(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        ConnectorEnd ce = ConnectorEndConvention.getSourceEnd((Connector)this.getLink());
        ce.setRole(this.getNewSource());
        if (ce.getPartWithPort() != null) {
            ce.setPartWithPort(null);
        }
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        ConnectorEnd ce = ConnectorEndConvention.getTargetEnd((Connector)this.getLink());
        ce.setRole(this.getNewTarget());
        if (ce.getPartWithPort() != null) {
            ce.setPartWithPort(null);
        }
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Connector getLink() {
        return (Connector)this.getElementToEdit();
    }

    protected ConnectableElement getOldSource() {
        return (ConnectableElement)this.oldEnd;
    }

    protected ConnectableElement getNewSource() {
        return (ConnectableElement)this.newEnd;
    }

    protected ConnectableElement getOldTarget() {
        return (ConnectableElement)this.oldEnd;
    }

    protected ConnectableElement getNewTarget() {
        return (ConnectableElement)this.newEnd;
    }
}

