/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.uml2.diagram.common.links.RefreshComplementaryLinksHelper;
import org.eclipse.uml2.diagram.csd.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;

public class InterfaceRealizationReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public InterfaceRealizationReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof InterfaceRealization)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSourceGen() {
        if (!(this.oldEnd instanceof BehavioredClassifier) || !(this.newEnd instanceof BehavioredClassifier)) {
            return false;
        }
        Interface target = this.getLink().getContract();
        if (!(this.getLink().eContainer() instanceof BehavioredClassifier)) {
            return false;
        }
        BehavioredClassifier container = (BehavioredClassifier)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistInterfaceRealization_4007(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientSource() {
        return this.oldEnd instanceof Classifier && this.newEnd instanceof Classifier;
    }

    protected boolean canReorientTarget() {
        return this.oldEnd instanceof Interface && this.newEnd instanceof Interface;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        InterfaceRealization link = this.getLink();
        EList clients = link.getClients();
        clients.remove((Object)this.getGeneralizedOldSource());
        clients.add((Object)this.getGeneralizedNewSource());
        Package container = InterfaceRealizationReorientCommand.deduceContainer((EObject)this.getGeneralizedNewSource());
        container.getPackagedElements().add((Object)link);
        RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)link, (Object)NotationPackage.eINSTANCE.getEdge_Source(), "Port`s provided interfaces, corresponding to interface realization, after interface realization source changed");
        return CommandResult.newOKCommandResult((Object)link);
    }

    private static Package deduceContainer(EObject source) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Package) {
                return (Package)element;
            }
            element = element.eContainer();
        }
        return null;
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        InterfaceRealization link = this.getLink();
        Interface target = this.getNewTarget();
        link.setContract(target);
        EList suppliers = link.getSuppliers();
        suppliers.clear();
        suppliers.add((Object)target);
        RefreshComplementaryLinksHelper.getInstance().addNotificationDescription((EObject)link, (Object)NotationPackage.eINSTANCE.getEdge_Target(), "Port`s provided interfaces, corresponding to interface realization, after interface realization target changed");
        return CommandResult.newOKCommandResult((Object)link);
    }

    protected InterfaceRealization getLink() {
        return (InterfaceRealization)this.getElementToEdit();
    }

    protected BehavioredClassifier getOldSource() {
        return (BehavioredClassifier)this.oldEnd;
    }

    protected Classifier getGeneralizedOldSource() {
        return (Classifier)this.oldEnd;
    }

    protected BehavioredClassifier getNewSource() {
        return (BehavioredClassifier)this.newEnd;
    }

    protected Classifier getGeneralizedNewSource() {
        return (Classifier)this.newEnd;
    }

    protected Interface getOldTarget() {
        return (Interface)this.oldEnd;
    }

    protected Interface getNewTarget() {
        return (Interface)this.newEnd;
    }
}

