/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.uml2.diagram.csd.navigator.UMLAbstractNavigatorItem;
import org.eclipse.uml2.diagram.csd.navigator.UMLNavigatorGroup;
import org.eclipse.uml2.diagram.csd.navigator.UMLNavigatorItem;
import org.eclipse.uml2.diagram.csd.part.Messages;
import org.eclipse.uml2.diagram.csd.part.UMLVisualIDRegistry;

public class UMLNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public UMLNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                UMLNavigatorContentProvider.this.unloadAllResources();
                UMLNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                UMLNavigatorContentProvider.this.unloadAllResources();
                UMLNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                UMLNavigatorContentProvider.this.unloadAllResources();
                UMLNavigatorContentProvider.this.asyncRefresh();
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        this.myViewer = null;
        this.unloadAllResources();
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        View view;
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList<UMLNavigatorItem> result = new ArrayList<UMLNavigatorItem>();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            result.addAll(this.createNavigatorItems(this.selectViewsByType(topViews, "UMLCompositeStructures"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        if (parentElement instanceof IAdaptable && (view = (View)((IAdaptable)parentElement).getAdapter(View.class)) != null) {
            return this.getViewChildren(view, parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                LinkedList<UMLAbstractNavigatorItem> result = new LinkedList<UMLAbstractNavigatorItem>();
                result.addAll(this.getForeignShortcuts((Diagram)view, parentElement));
                Diagram sv = (Diagram)view;
                UMLNavigatorGroup links = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2013));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4007));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4010));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4014));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4015));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 2003: {
                LinkedList<UMLAbstractNavigatorItem> result = new LinkedList<UMLAbstractNavigatorItem>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_2003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_2003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2005: {
                LinkedList<UMLAbstractNavigatorItem> result = new LinkedList<UMLAbstractNavigatorItem>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Collaboration_2005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Collaboration_2005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4007));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2006: {
                LinkedList<UMLAbstractNavigatorItem> result = new LinkedList<UMLAbstractNavigatorItem>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Class_2006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Class_2006_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7004));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3008));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7006));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3010));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4007));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2007: {
                LinkedList<UMLAbstractNavigatorItem> result = new LinkedList<UMLAbstractNavigatorItem>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Class_2007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Class_2007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7007));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3014));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4007));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2009: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Interface_2009_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Interface_2009_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4007));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4010));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4014));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2011: {
                LinkedList<UMLAbstractNavigatorItem> result = new LinkedList<UMLAbstractNavigatorItem>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InstanceSpecification_2011_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InstanceSpecification_2011_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7009));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3015));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4015));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4015));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2012: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_2012_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_2012_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2013: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_2013_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_2013_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2014: {
                LinkedList<UMLAbstractNavigatorItem> result = new LinkedList<UMLAbstractNavigatorItem>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Interface_2014_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Interface_2014_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7010));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3018));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7011));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3019));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(7012));
                connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3020));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4007));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4010));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4011));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4014));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3002: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CollaborationUse_3002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CollaborationUse_3002_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3007: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Property_3007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Property_3007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3011: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Port_3011_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Port_3011_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4010));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4014));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3014: {
                LinkedList<UMLAbstractNavigatorItem> result = new LinkedList<UMLAbstractNavigatorItem>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Property_3014_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Property_3014_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3016: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Port_3016_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Port_3016_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4010));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4014));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3017: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Node sv = (Node)view;
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Port_3017_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Port_3017_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4005));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4010));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4012));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4014));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4016));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(4017));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4005: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Connector_4005_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Connector_4005_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Connector_4005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Connector_4005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4006: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4006_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4006_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4006_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2003));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4007: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_InterfaceRealization_4007_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_InterfaceRealization_4007_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InterfaceRealization_4007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InterfaceRealization_4007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4008: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Usage_4008_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Usage_4008_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Usage_4008_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Usage_4008_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2003));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4010: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_PortProvided_4010_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_PortProvided_4010_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4011: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Association_4011_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Association_4011_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Association_4011_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Association_4011_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4012: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConstraintConstrainedElement_4012_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConstraintConstrainedElement_4012_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2013));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4014: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_PortRequired_4014_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_PortRequired_4014_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4015: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Slot_4015_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Slot_4015_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Slot_4015_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 4016: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_CommentAnnotatedElement_4016_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_CommentAnnotatedElement_4016_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2013));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2013));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4017: {
                LinkedList<UMLNavigatorGroup> result = new LinkedList<UMLNavigatorGroup>();
                Edge sv = (Edge)view;
                UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4017_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4017_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4017_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4017_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2005));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2006));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2003));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2009));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2012));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(2014));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3014));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3016));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), UMLVisualIDRegistry.getType(3017));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection<View> getLinksSourceByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection<View> getLinksTargetByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection<View> getOutgoingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getSourceEdges(), type));
        }
        return result;
    }

    private Collection<View> getIncomingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getTargetEdges(), type));
        }
        return result;
    }

    private Collection<View> getChildrenByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getChildren(), type));
        }
        return result;
    }

    private Collection<View> getDiagramLinksByType(Collection<Diagram> diagrams, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection<View>)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection<View> selectViewsByType(Collection<View> views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "UMLCompositeStructures".equals(UMLVisualIDRegistry.getModelID(view));
    }

    private Collection<UMLNavigatorItem> createNavigatorItems(Collection<View> views, Object parent, boolean isLeafs) {
        ArrayList<UMLNavigatorItem> result = new ArrayList<UMLNavigatorItem>(views.size());
        for (View nextView : views) {
            result.add(new UMLNavigatorItem(nextView, parent, isLeafs));
        }
        return result;
    }

    private Collection<UMLNavigatorItem> getForeignShortcuts(Diagram diagram, Object parent) {
        LinkedList<View> result = new LinkedList<View>();
        for (View nextView : diagram.getChildren()) {
            if (this.isOwnView(nextView) || nextView.getEAnnotation("Shortcut") == null) continue;
            result.add(nextView);
        }
        return this.createNavigatorItems(result, parent, false);
    }

    public Object getParent(Object element) {
        if (element instanceof UMLAbstractNavigatorItem) {
            UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

