/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.part;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistryExt;
import org.eclipse.uml2.diagram.csd.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.csd.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.csd.part.UMLNodeDescriptor;
import org.eclipse.uml2.diagram.csd.part.VisualIDRegistryExtension;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.uml2.diagram.csd/debug/visualID";
    public static final IVisualIDRegistry TYPED_ADAPTER = new IVisualIDRegistryExt(){
        private VisualIDRegistryExtension myExtension = new VisualIDRegistryExtension();

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }

        public boolean isShortcutDescendant(View view) {
            return UMLVisualIDRegistry.isShortcutDescendant(view);
        }

        public List<String> getAllHintedTypes() {
            return this.myExtension.getAllHintedTypes();
        }

        public List<IVisualIDRegistryExt.MenuTypeHint> getMenuTypeHints(String type) {
            return this.myExtension.getMenuTypeHints(type);
        }

        public String getSemanticHint(View childView, View newParentView) {
            return this.myExtension.getSemanticHint(childView, newParentView);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLCompositeStructures".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLCompositeStructures".equals(containerModelID) && !"uml".equals(containerModelID)) {
            return -1;
        }
        if ("UMLCompositeStructures".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (containerView instanceof Diagram && domainElement != null && domainElement.equals(containerView.getElement())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2006((Class)domainElement)) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2007((Class)domainElement)) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2009;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2012;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2013;
                }
                if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 2014;
            }
            case 2006: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 2007: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3017;
            }
            case 3014: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 7003: {
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3007((Property)domainElement)) break;
                return 3007;
            }
            case 7004: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3008((Property)domainElement)) break;
                return 3008;
            }
            case 7005: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7006: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7007: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3014((Property)domainElement)) break;
                return 3014;
            }
            case 7009: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 7010: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3018((Property)domainElement)) break;
                return 3018;
            }
            case 7011: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3019;
            }
            case 7012: {
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3020;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLCompositeStructures".equals(containerModelID) && !"uml".equals(containerModelID)) {
            return false;
        }
        if ("UMLCompositeStructures".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2009 == nodeVisualID) {
                    return true;
                }
                if (2011 == nodeVisualID) {
                    return true;
                }
                if (2012 == nodeVisualID) {
                    return true;
                }
                if (2013 == nodeVisualID) {
                    return true;
                }
                if (2014 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (5030 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5013 == nodeVisualID) {
                    return true;
                }
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (5033 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (3017 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (5020 != nodeVisualID) break;
                return true;
            }
            case 2011: {
                if (5022 == nodeVisualID) {
                    return true;
                }
                if (5031 == nodeVisualID) {
                    return true;
                }
                if (7009 != nodeVisualID) break;
                return true;
            }
            case 2012: {
                if (5024 == nodeVisualID) {
                    return true;
                }
                if (5034 != nodeVisualID) break;
                return true;
            }
            case 2013: {
                if (5032 != nodeVisualID) break;
                return true;
            }
            case 2014: {
                if (5035 == nodeVisualID) {
                    return true;
                }
                if (5036 == nodeVisualID) {
                    return true;
                }
                if (7010 == nodeVisualID) {
                    return true;
                }
                if (7011 == nodeVisualID) {
                    return true;
                }
                if (7012 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (5029 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5011 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (5026 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (5017 == nodeVisualID) {
                    return true;
                }
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (5025 != nodeVisualID) break;
                return true;
            }
            case 3017: {
                if (5027 == nodeVisualID) {
                    return true;
                }
                if (5028 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3019 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3020 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6009 == nodeVisualID) {
                    return true;
                }
                if (6010 == nodeVisualID) {
                    return true;
                }
                if (6011 == nodeVisualID) {
                    return true;
                }
                if (6012 == nodeVisualID) {
                    return true;
                }
                if (6013 == nodeVisualID) {
                    return true;
                }
                if (6014 == nodeVisualID) {
                    return true;
                }
                if (6015 != nodeVisualID) break;
                return true;
            }
            case 4006: {
                if (6001 != nodeVisualID) break;
                return true;
            }
            case 4011: {
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6004 == nodeVisualID) {
                    return true;
                }
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6008 != nodeVisualID) break;
                return true;
            }
            case 4015: {
                if (6016 == nodeVisualID) {
                    return true;
                }
                if (6017 != nodeVisualID) break;
                return true;
            }
            case 4017: {
                if (6018 == nodeVisualID) {
                    return true;
                }
                if (6019 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConnector_4005((Connector)domainElement)) {
            return 4005;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4006((Dependency)domainElement)) {
            return 4006;
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInterfaceRealization_4007((InterfaceRealization)domainElement)) {
            return 4007;
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isUsage_4008((Usage)domainElement)) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
            return 4011;
        }
        if (UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isSlot_4015((Slot)domainElement)) {
            return 4015;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4017((Dependency)domainElement)) {
            return 4017;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isClass_2006(Class domainElement) {
        Object result = UMLOCLFactory.getExpression(3, (EClassifier)UMLPackage.eINSTANCE.getClass_(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isClass_2007(Class domainElement) {
        Object result = UMLOCLFactory.getExpression(12, (EClassifier)UMLPackage.eINSTANCE.getClass_(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3007(Property domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getProperty(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3008(Property domainElement) {
        Object result = UMLOCLFactory.getExpression(5, (EClassifier)UMLPackage.eINSTANCE.getProperty(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3014(Property domainElement) {
        Object result = UMLOCLFactory.getExpression(14, (EClassifier)UMLPackage.eINSTANCE.getProperty(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isProperty_3018(Property domainElement) {
        Object result = UMLOCLFactory.getExpression(5, (EClassifier)UMLPackage.eINSTANCE.getProperty(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConnector_4005(Connector domainElement) {
        Object result = UMLOCLFactory.getExpression(22, (EClassifier)UMLPackage.eINSTANCE.getConnector(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDependency_4006(Dependency domainElement) {
        if (!UMLVisualIDRegistry.isDependency_4006Gen(domainElement)) {
            return false;
        }
        return domainElement.eContainer() instanceof CollaborationUse;
    }

    private static boolean isDependency_4006Gen(Dependency domainElement) {
        Object result = UMLOCLFactory.getExpression(24, (EClassifier)UMLPackage.eINSTANCE.getDependency(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInterfaceRealization_4007(InterfaceRealization domainElement) {
        Object result = UMLOCLFactory.getExpression(25, (EClassifier)UMLPackage.eINSTANCE.getInterfaceRealization(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isUsage_4008(Usage domainElement) {
        Object result = UMLOCLFactory.getExpression(27, (EClassifier)UMLPackage.eINSTANCE.getUsage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isSlot_4015(Slot domainElement) {
        Object result = UMLOCLFactory.getExpression(32, (EClassifier)UMLPackage.eINSTANCE.getSlot(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDependency_4017(Dependency domainElement) {
        if (!UMLVisualIDRegistry.isDependency_4017Gen(domainElement)) {
            return false;
        }
        return domainElement.eContainer() instanceof Package;
    }

    private static boolean isDependency_4017Gen(Dependency domainElement) {
        Object result = UMLOCLFactory.getExpression(33, (EClassifier)UMLPackage.eINSTANCE.getDependency(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (containerView == null) {
            return false;
        }
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }

    public static int getChildDescriptorVisualID(UMLNodeDescriptor container, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        switch (container.getVisualID()) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2006((Class)domainElement)) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isClass_2007((Class)domainElement)) {
                    return 2007;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2009;
                }
                if (UMLPackage.eINSTANCE.getInstanceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2012;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2013;
                }
                if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 2014;
            }
            case 2005: {
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3007((Property)domainElement)) break;
                return 3007;
            }
            case 2006: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3008((Property)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 2003: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 2007: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isProperty_3014((Property)domainElement)) break;
                return 3014;
            }
            case 2011: {
                if (!UMLPackage.eINSTANCE.getSlot().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 2014: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3018((Property)domainElement)) {
                    return 3018;
                }
                if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                    return 3019;
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return 3020;
            }
            case 3014: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
        }
        return -1;
    }

    protected static boolean canSubstitute(int visualId, int substituteCandidate) {
        if (visualId == substituteCandidate) {
            return true;
        }
        switch (visualId) {
            case 2006: {
                return substituteCandidate == 2007;
            }
            case 2007: {
                return substituteCandidate == 2006;
            }
            case 2009: {
                return substituteCandidate == 2014;
            }
            case 2014: {
                return substituteCandidate == 2009;
            }
        }
        return false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate || UMLVisualIDRegistry.canSubstitute(basic, candidate);
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: 
            case 7009: 
            case 7010: 
            case 7011: 
            case 7012: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 2009: 
            case 2012: 
            case 2013: 
            case 3002: 
            case 3004: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3015: 
            case 3016: 
            case 3017: 
            case 3018: 
            case 3019: 
            case 3020: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShortcutDescendant(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram && view != null) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return true;
            }
            view = (View)view.eContainer();
        }
        return false;
    }
}

