package org.eclipse.uml2.diagram.activity.edit.policies;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.uml2.diagram.activity.edit.commands.ActivityCreateCommand;
import org.eclipse.uml2.diagram.activity.edit.commands.CommentCreateCommand;
import org.eclipse.uml2.diagram.activity.edit.commands.LocalPostconditionCreateCommand;
import org.eclipse.uml2.diagram.activity.edit.commands.LocalPreconditionCreateCommand;
import org.eclipse.uml2.diagram.activity.providers.UMLElementTypes;

/**
 * @generated
 */

public class PackageItemSemanticEditPolicy extends UMLBaseItemSemanticEditPolicy {

	/**
	 * @generated
	 */
	public PackageItemSemanticEditPolicy() {
		super(UMLElementTypes.Package_1000);
	}

	/**
	 * @generated
	 */
	protected Command getCreateCommand(CreateElementRequest req) {
		if (UMLElementTypes.Activity_2026 == req.getElementType()) {
			return getGEFWrapper(new ActivityCreateCommand(req));
		}
		if (UMLElementTypes.Constraint_2027 == req.getElementType()) {
			return getGEFWrapper(new LocalPreconditionCreateCommand(req));
		}
		if (UMLElementTypes.Constraint_2028 == req.getElementType()) {
			return getGEFWrapper(new LocalPostconditionCreateCommand(req));
		}
		if (UMLElementTypes.Comment_2029 == req.getElementType()) {
			return getGEFWrapper(new CommentCreateCommand(req));
		}
		return super.getCreateCommand(req);
	}

	/**
	 * @generated
	 */
	protected Command getDuplicateCommand(DuplicateElementsRequest req) {
		TransactionalEditingDomain editingDomain = ((IGraphicalEditPart) getHost()).getEditingDomain();
		return getGEFWrapper(new DuplicateAnythingCommand(editingDomain, req));
	}

	/**
	 * @generated
	 */

	private static class DuplicateAnythingCommand extends DuplicateEObjectsCommand {

		/**
		 * @generated
		 */
		public DuplicateAnythingCommand(TransactionalEditingDomain editingDomain, DuplicateElementsRequest req) {
			super(editingDomain, req.getLabel(), req.getElementsToBeDuplicated(), req.getAllDuplicatedElementsMap());
		}

	}

}
