/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.statemachine.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;
import org.eclipse.uml2.diagram.statemachine.expressions.UMLAbstractExpression;
import org.eclipse.uml2.diagram.statemachine.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.statemachine.part.UMLNodeDescriptor;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.ConnectionPointReference;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.uml2.diagram.statemachine/debug/visualID";
    private static UMLAbstractExpression State_3001_Constraint;
    private static UMLAbstractExpression State_3012_Constraint;
    private static UMLAbstractExpression State_3016_Constraint;
    private static UMLAbstractExpression ConnectionPointReference_3017_Constraint;
    private static UMLAbstractExpression ConnectionPointReference_3018_Constraint;
    private static UMLAbstractExpression Pseudostate_3004_Constraint;
    private static UMLAbstractExpression Pseudostate_3005_Constraint;
    private static UMLAbstractExpression Pseudostate_3006_Constraint;
    private static UMLAbstractExpression Pseudostate_3007_Constraint;
    private static UMLAbstractExpression Pseudostate_3008_Constraint;
    private static UMLAbstractExpression Pseudostate_3009_Constraint;
    private static UMLAbstractExpression Pseudostate_3010_Constraint;
    private static UMLAbstractExpression Pseudostate_3011_Constraint;
    private static UMLAbstractExpression Pseudostate_3014_Constraint;
    private static UMLAbstractExpression Pseudostate_3015_Constraint;
    public static final IVisualIDRegistry TYPED_ADAPTER;

    static {
        TYPED_ADAPTER = new IVisualIDRegistry(){

            public String getModelID(View view) {
                return UMLVisualIDRegistry.getModelID(view);
            }

            public int getVisualID(View view) {
                return UMLVisualIDRegistry.getVisualID(view);
            }

            public int getNodeVisualID(View containerView, EObject domainElement) {
                return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
            }

            public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
                return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
            }

            public boolean isCompartmentVisualID(int visualID) {
                return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
            }

            public boolean isSemanticLeafVisualID(int visualID) {
                return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
            }

            public boolean isShortcutDescendant(View view) {
                return UMLVisualIDRegistry.isShortcutDescendant(view);
            }
        };
    }

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLStateMachine".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((StateMachine)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLStateMachine".equals(containerModelID)) {
            return -1;
        }
        if ("UMLStateMachine".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 2004: {
                if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3014((Pseudostate)domainElement)) {
                    return 3014;
                }
                if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_3015((Pseudostate)domainElement)) break;
                return 3015;
            }
            case 3012: {
                if (!UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 3016: {
                if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getConnectionPointReference().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConnectionPointReference_3017((ConnectionPointReference)domainElement)) {
                    return 3017;
                }
                if (!UMLPackage.eINSTANCE.getConnectionPointReference().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isConnectionPointReference_3018((ConnectionPointReference)domainElement)) break;
                return 3018;
            }
            case 7004: {
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3001((State)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3012((State)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3016((State)domainElement)) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getFinalState().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3004((Pseudostate)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3005((Pseudostate)domainElement)) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3006((Pseudostate)domainElement)) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3007((Pseudostate)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3008((Pseudostate)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3009((Pseudostate)domainElement)) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3010((Pseudostate)domainElement)) {
                    return 3010;
                }
                if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_3011((Pseudostate)domainElement)) break;
                return 3011;
            }
            case 7005: {
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3019((Behavior)domainElement)) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3020((Behavior)domainElement)) {
                    return 3020;
                }
                if (!UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isBehavior_3021((Behavior)domainElement)) break;
                return 3021;
            }
            case 7006: {
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3019((Behavior)domainElement)) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3020((Behavior)domainElement)) {
                    return 3020;
                }
                if (!UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isBehavior_3021((Behavior)domainElement)) break;
                return 3021;
            }
            case 7003: {
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3001((State)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3012((State)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3016((State)domainElement)) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getFinalState().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3004((Pseudostate)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3005((Pseudostate)domainElement)) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3006((Pseudostate)domainElement)) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3007((Pseudostate)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3008((Pseudostate)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3009((Pseudostate)domainElement)) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3010((Pseudostate)domainElement)) {
                    return 3010;
                }
                if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_3011((Pseudostate)domainElement)) break;
                return 3011;
            }
            case 7007: {
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3019((Behavior)domainElement)) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3020((Behavior)domainElement)) {
                    return 3020;
                }
                if (!UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isBehavior_3021((Behavior)domainElement)) break;
                return 3021;
            }
            case 1000: {
                if (!(containerView instanceof Diagram) || domainElement == null || !domainElement.equals(containerView.getElement())) break;
                return 2004;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLStateMachine".equals(containerModelID)) {
            return false;
        }
        if ("UMLStateMachine".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2004: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 3017: {
                if (5009 != nodeVisualID) break;
                return true;
            }
            case 3018: {
                if (5010 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (5006 != nodeVisualID) break;
                return true;
            }
            case 3015: {
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3019 == nodeVisualID) {
                    return true;
                }
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3019 == nodeVisualID) {
                    return true;
                }
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3019 == nodeVisualID) {
                    return true;
                }
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2004 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getTransition().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        return -1;
    }

    private static boolean isDiagram(StateMachine element) {
        return true;
    }

    private static boolean isState_3001(State domainElement) {
        Object result;
        if (State_3001_Constraint == null) {
            State_3001_Constraint = UMLOCLFactory.getExpression("self.oclIsTypeOf(uml::State) and self.isSimple and (not self.isSubmachineState)", (EClassifier)UMLPackage.eINSTANCE.getState());
        }
        return (result = State_3001_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isBehavior_3019(Behavior domainElement) {
        Element owner = domainElement.getOwner();
        return owner instanceof State && domainElement.equals(((State)owner).getEntry());
    }

    private static boolean isBehavior_3020(Behavior domainElement) {
        Element owner = domainElement.getOwner();
        return owner instanceof State && domainElement.equals(((State)owner).getExit());
    }

    private static boolean isBehavior_3021(Behavior domainElement) {
        Element owner = domainElement.getOwner();
        return owner instanceof State && domainElement.equals(((State)owner).getDoActivity());
    }

    private static boolean isState_3012(State domainElement) {
        Object result;
        if (State_3012_Constraint == null) {
            State_3012_Constraint = UMLOCLFactory.getExpression("self.oclIsTypeOf(uml::State) and self.isComposite and (not self.isSubmachineState)", (EClassifier)UMLPackage.eINSTANCE.getState());
        }
        return (result = State_3012_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isState_3016(State domainElement) {
        Object result;
        if (State_3016_Constraint == null) {
            State_3016_Constraint = UMLOCLFactory.getExpression("self.oclIsTypeOf(uml::State) and self.isSubmachineState", (EClassifier)UMLPackage.eINSTANCE.getState());
        }
        return (result = State_3016_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConnectionPointReference_3017(ConnectionPointReference domainElement) {
        Object result;
        if (ConnectionPointReference_3017_Constraint == null) {
            ConnectionPointReference_3017_Constraint = UMLOCLFactory.getExpression("entry->notEmpty() implies entry->forAll(e | e.kind =  PseudostateKind::entryPoint)", (EClassifier)UMLPackage.eINSTANCE.getConnectionPointReference());
        }
        return (result = ConnectionPointReference_3017_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConnectionPointReference_3018(ConnectionPointReference domainElement) {
        Object result;
        if (ConnectionPointReference_3018_Constraint == null) {
            ConnectionPointReference_3018_Constraint = UMLOCLFactory.getExpression("exit->notEmpty() implies exit->forAll(e | e.kind =  PseudostateKind::exitPoint)", (EClassifier)UMLPackage.eINSTANCE.getConnectionPointReference());
        }
        return (result = ConnectionPointReference_3018_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3004(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3004_Constraint == null) {
            Pseudostate_3004_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::initial", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3004_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3005(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3005_Constraint == null) {
            Pseudostate_3005_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::shallowHistory", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3005_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3006(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3006_Constraint == null) {
            Pseudostate_3006_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::deepHistory", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3006_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3007(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3007_Constraint == null) {
            Pseudostate_3007_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::fork", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3007_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3008(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3008_Constraint == null) {
            Pseudostate_3008_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::join", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3008_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3009(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3009_Constraint == null) {
            Pseudostate_3009_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::junction", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3009_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3010(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3010_Constraint == null) {
            Pseudostate_3010_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::choice", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3010_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3011(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3011_Constraint == null) {
            Pseudostate_3011_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::terminate", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3011_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3014(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3014_Constraint == null) {
            Pseudostate_3014_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::entryPoint", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3014_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isPseudostate_3015(Pseudostate domainElement) {
        Object result;
        if (Pseudostate_3015_Constraint == null) {
            Pseudostate_3015_Constraint = UMLOCLFactory.getExpression("self.kind = PseudostateKind::exitPoint", (EClassifier)UMLPackage.eINSTANCE.getPseudostate());
        }
        return (result = Pseudostate_3015_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (containerView == null) {
            return false;
        }
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }

    public static int getChildDescriptorVisualID(UMLNodeDescriptor container, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        switch (container.getVisualID()) {
            case 2004: {
                if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3014((Pseudostate)domainElement)) {
                    return 3014;
                }
                if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_3015((Pseudostate)domainElement)) break;
                return 3015;
            }
            case 3013: {
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3001((State)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3012((State)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3016((State)domainElement)) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getFinalState().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3004((Pseudostate)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3005((Pseudostate)domainElement)) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3006((Pseudostate)domainElement)) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3007((Pseudostate)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3008((Pseudostate)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3009((Pseudostate)domainElement)) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3010((Pseudostate)domainElement)) {
                    return 3010;
                }
                if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_3011((Pseudostate)domainElement)) break;
                return 3011;
            }
            case 3001: {
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3019((Behavior)domainElement)) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3020((Behavior)domainElement)) {
                    return 3020;
                }
                if (!UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isBehavior_3021((Behavior)domainElement)) break;
                return 3021;
            }
            case 3012: {
                if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3019((Behavior)domainElement)) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3020((Behavior)domainElement)) {
                    return 3020;
                }
                if (!UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isBehavior_3021((Behavior)domainElement)) break;
                return 3021;
            }
            case 3002: {
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3001((State)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3012((State)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3016((State)domainElement)) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getFinalState().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3004((Pseudostate)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3005((Pseudostate)domainElement)) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3006((Pseudostate)domainElement)) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3007((Pseudostate)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3008((Pseudostate)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3009((Pseudostate)domainElement)) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3010((Pseudostate)domainElement)) {
                    return 3010;
                }
                if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_3011((Pseudostate)domainElement)) break;
                return 3011;
            }
            case 3016: {
                if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getConnectionPointReference().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConnectionPointReference_3017((ConnectionPointReference)domainElement)) {
                    return 3017;
                }
                if (UMLPackage.eINSTANCE.getConnectionPointReference().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConnectionPointReference_3018((ConnectionPointReference)domainElement)) {
                    return 3018;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3019((Behavior)domainElement)) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3020((Behavior)domainElement)) {
                    return 3020;
                }
                if (!UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isBehavior_3021((Behavior)domainElement)) break;
                return 3021;
            }
            case 1000: {
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3001((State)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3012((State)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3016((State)domainElement)) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getFinalState().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3004((Pseudostate)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3005((Pseudostate)domainElement)) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3006((Pseudostate)domainElement)) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3007((Pseudostate)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3008((Pseudostate)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3009((Pseudostate)domainElement)) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3010((Pseudostate)domainElement)) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3011((Pseudostate)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3019((Behavior)domainElement)) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3020((Behavior)domainElement)) {
                    return 3020;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3021((Behavior)domainElement)) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3019((Behavior)domainElement)) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3020((Behavior)domainElement)) {
                    return 3020;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3021((Behavior)domainElement)) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3001((State)domainElement)) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3012((State)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isState_3016((State)domainElement)) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getFinalState().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3004((Pseudostate)domainElement)) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3005((Pseudostate)domainElement)) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3006((Pseudostate)domainElement)) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3007((Pseudostate)domainElement)) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3008((Pseudostate)domainElement)) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3009((Pseudostate)domainElement)) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3010((Pseudostate)domainElement)) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_3011((Pseudostate)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3019((Behavior)domainElement)) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_3020((Behavior)domainElement)) {
                    return 3020;
                }
                if (!UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isBehavior_3021((Behavior)domainElement)) break;
                return 3021;
            }
        }
        return -1;
    }

    protected static boolean canSubstitute(int visualId, int substituteCandidate) {
        return visualId == substituteCandidate;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate || UMLVisualIDRegistry.canSubstitute(basic, candidate);
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3013: 
            case 3014: 
            case 3015: 
            case 3017: 
            case 3018: 
            case 3019: 
            case 3020: 
            case 3021: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShortcutDescendant(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram && view != null) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return true;
            }
            view = (View)view.eContainer();
        }
        return false;
    }
}

