/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.uml2.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;

public class DependencyClientReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public DependencyClientReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Dependency)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof NamedElement) || !(this.newEnd instanceof Dependency)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistDependencyClient_4007(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof NamedElement) || !(this.newEnd instanceof NamedElement)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistDependencyClient_4007(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getClients().remove((Object)this.getOldTarget());
        this.getNewSource().getClients().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().getClients().remove((Object)this.getOldTarget());
        this.getOldSource().getClients().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Dependency getOldSource() {
        return (Dependency)this.referenceOwner;
    }

    protected Dependency getNewSource() {
        return (Dependency)this.newEnd;
    }

    protected NamedElement getOldTarget() {
        return (NamedElement)this.oldEnd;
    }

    protected NamedElement getNewTarget() {
        return (NamedElement)this.newEnd;
    }
}

