/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.statemachine.parser;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.uml2.diagram.common.parser.ElementProvider;
import org.eclipse.uml2.diagram.common.parser.events.EventParserUtil;
import org.eclipse.uml2.diagram.common.parser.valuespec.ValueSpecificationParserUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionParser
implements IParser {
    private ElementProvider triggerProvider;
    private ElementProvider guardProvider;
    private ElementProvider effectProvider;

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        ICommand setEffectCommand;
        ICommand setGuardCommand;
        EObject adaptedElement = (EObject)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)adaptedElement);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransitionHandler handler = new TransitionHandler(newString);
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Values");
        ICommand setTriggersCommand = this.getSetTriggersCommand(adaptedElement, handler.getTriggers());
        if (setTriggersCommand != null) {
            command.compose((IUndoableOperation)setTriggersCommand);
        }
        if ((setGuardCommand = this.getSetGuardCommand(adaptedElement, handler.getGuard())) != null) {
            command.compose((IUndoableOperation)setGuardCommand);
        }
        if ((setEffectCommand = this.getSetEffectCommand(adaptedElement, handler.getEffect())) != null) {
            command.compose((IUndoableOperation)setEffectCommand);
        }
        return command;
    }

    public String getPrintString(IAdaptable element, int flags) {
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject instanceof Transition) {
            Behavior effect;
            ValueSpecification specification;
            Transition transition = (Transition)eObject;
            StringBuffer printStringBuffer = new StringBuffer(20);
            EList triggers = transition.getTriggers();
            Iterator triggersIterator = triggers.iterator();
            while (triggersIterator.hasNext()) {
                Trigger trigger = (Trigger)triggersIterator.next();
                printStringBuffer.append(EventParserUtil.getEditString((Event)trigger.getEvent()));
                if (!triggersIterator.hasNext()) continue;
                printStringBuffer.append(',');
            }
            Constraint guard = transition.getGuard();
            if (guard != null && (specification = guard.getSpecification()) != null) {
                printStringBuffer.append('[');
                printStringBuffer.append(ValueSpecificationParserUtil.getEditString((ValueSpecification)specification));
                printStringBuffer.append(']');
            }
            if ((effect = transition.getEffect()) != null) {
                printStringBuffer.append('/');
                printStringBuffer.append(effect.getLabel());
            }
            return printStringBuffer.toString();
        }
        return "";
    }

    public boolean isAffectingEvent(Object event, int flags) {
        if (event instanceof Notification) {
            Object feature = ((Notification)event).getFeature();
            return UMLPackage.eINSTANCE.getTransition_Trigger().equals(feature) || UMLPackage.eINSTANCE.getTransition_Guard().equals(feature) || UMLPackage.eINSTANCE.getTransition_Effect().equals(feature);
        }
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.UNEDITABLE_STATUS;
    }

    private ICommand getSetTriggersCommand(EObject element, List<String> triggerNotations) {
        if (triggerNotations.isEmpty()) {
            return null;
        }
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        for (String triggerNotation : triggerNotations) {
            Trigger trigger = (Trigger)this.getTriggerProvider().findElement(element, triggerNotation);
            if (trigger == null) continue;
            triggers.add(trigger);
        }
        if (triggers.isEmpty()) {
            return null;
        }
        return new SetValueCommand(new SetRequest(element, (EStructuralFeature)UMLPackage.eINSTANCE.getTransition_Trigger(), triggers));
    }

    private ICommand getSetGuardCommand(EObject element, String guardNotation) {
        if (guardNotation == null) {
            return null;
        }
        Constraint guard = (Constraint)this.getGuardProvider().findElement(element, guardNotation);
        if (guard == null) {
            return null;
        }
        return new SetValueCommand(new SetRequest(element, (EStructuralFeature)UMLPackage.eINSTANCE.getTransition_Guard(), (Object)guard));
    }

    private ICommand getSetEffectCommand(EObject element, String effectNotation) {
        if (effectNotation == null) {
            return null;
        }
        Behavior effect = (Behavior)this.getEffectProvider().findElement(element, effectNotation);
        if (effect == null) {
            return null;
        }
        return new SetValueCommand(new SetRequest(element, (EStructuralFeature)UMLPackage.eINSTANCE.getTransition_Effect(), (Object)effect));
    }

    private ElementProvider getTriggerProvider() {
        if (this.triggerProvider == null) {
            this.triggerProvider = new TriggerProvider();
        }
        return this.triggerProvider;
    }

    private ElementProvider getGuardProvider() {
        if (this.guardProvider == null) {
            this.guardProvider = new GuardProvider();
        }
        return this.guardProvider;
    }

    public ElementProvider getEffectProvider() {
        if (this.effectProvider == null) {
            this.effectProvider = new BehaviorProvider();
        }
        return this.effectProvider;
    }

    private static class BehaviorProvider
    extends ElementProvider {
        private BehaviorProvider() {
        }

        protected boolean isSuitable(Object object) {
            return object instanceof Behavior;
        }
    }

    private static class GuardProvider
    extends ElementProvider {
        private GuardProvider() {
        }

        protected String getDisplayProposal(NamedElement element) {
            ValueSpecification specification;
            if (element instanceof Constraint && (specification = ((Constraint)element).getSpecification()) != null) {
                return ValueSpecificationParserUtil.getEditString((ValueSpecification)specification);
            }
            return super.getDisplayProposal(element);
        }

        protected boolean isSuitable(Object object) {
            return object instanceof Constraint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransitionHandler {
        private static final String EFFECT_SEPARATOR = "/";
        private static final String GUARD_LEADING_EDGE = "[";
        private static final String GUARD_TRAILING_EDGE = "]";
        private List<String> triggers = new LinkedList<String>();
        private String guard;
        private String effect;

        public TransitionHandler(String notation) {
            this.handle(notation);
        }

        public List<String> getTriggers() {
            return this.triggers;
        }

        public String getGuard() {
            return this.guard;
        }

        public String getEffect() {
            return this.effect;
        }

        private void handle(String notation) {
            int guardTEPosition;
            int guardLEPosition;
            int effectPosition = notation.indexOf(EFFECT_SEPARATOR);
            if (effectPosition >= 0) {
                this.effect = notation.substring(effectPosition + 1);
                notation = notation.substring(0, effectPosition);
            }
            if ((guardLEPosition = notation.indexOf(GUARD_LEADING_EDGE)) >= 0 && (guardTEPosition = notation.indexOf(GUARD_TRAILING_EDGE)) > 0 && guardTEPosition > guardLEPosition) {
                this.guard = notation.substring(guardLEPosition + 1, guardTEPosition);
                notation = notation.substring(0, guardLEPosition);
            }
            if (notation.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(notation, ",");
                while (tokenizer.hasMoreElements()) {
                    this.triggers.add(tokenizer.nextToken());
                }
            }
        }
    }

    private static class TriggerProvider
    extends ElementProvider {
        private TriggerProvider() {
        }

        protected String getDisplayProposal(NamedElement element) {
            Event event;
            if (element instanceof Trigger && (event = ((Trigger)element).getEvent()) != null) {
                return EventParserUtil.getEditString((Event)event);
            }
            return super.getDisplayProposal(element);
        }

        protected boolean isSuitable(Object object) {
            return object instanceof Trigger;
        }
    }
}

