/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.model.edit;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.uml2.diagram.sequence.model.builder.SDBuilderTrace;
import org.eclipse.uml2.diagram.sequence.model.edit.InsertAfter;
import org.eclipse.uml2.diagram.sequence.model.edit.InsertFragmentAfter;
import org.eclipse.uml2.diagram.sequence.model.edit.SDAnchor;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBracket;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBracketContainer;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDCombinedFragment;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDFrame;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDFrameContainer;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDInteractionOperand;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDModel;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDMountingRegion;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateCombinedFragment {
    private final SDModel myModel;

    public CreateCombinedFragment(SDModel model) {
        this.myModel = model;
    }

    public SDCombinedFragment tieCombinedFragment(SDCombinedFragment sdCombined, SDBracketContainer container, SDAnchor anchor) {
        SDLifeLine sdLifeLine = container.getCoveredLifeLine();
        if (sdLifeLine.getModel() != this.myModel) {
            throw new IllegalArgumentException("Alien lifeline: " + sdLifeLine + ", for sdModel: " + this.myModel);
        }
        if (anchor != null && !anchor.isFirstElement() && anchor.getAnchor().getBracketContainer() != container) {
            throw new IllegalArgumentException("Anchor: " + anchor.getAnchor() + ", is not applicable to container: " + container + ", actual container is: " + anchor.getAnchor().getBracketContainer());
        }
        CreateContainer createContainer = this.findCreateContainer(container, anchor);
        CombinedFragment umlCombined = sdCombined.getUmlCombinedFragment();
        umlCombined.getCovereds().add((Object)sdLifeLine.getUmlLifeline());
        sdCombined.getCoveredLifeLines().add((Object)sdLifeLine);
        SDMountingRegion sdCombinedMounter = this.getTraceImpl().bindNewMountingRegion(sdCombined);
        int i = 0;
        while (i < umlCombined.getOperands().size()) {
            InteractionOperand nextUMLOperand = (InteractionOperand)umlCombined.getOperands().get(i);
            nextUMLOperand.getCovereds().add((Object)sdLifeLine.getUmlLifeline());
            SDInteractionOperand nextSDOperand = this.getTraceImpl().findInteractionOperand(nextUMLOperand);
            nextSDOperand.getCoveredLifeLines().add((Object)sdLifeLine);
            SDMountingRegion nextOperandMounter = this.getTraceImpl().bindNewMountingRegion(nextSDOperand);
            sdCombinedMounter.getBrackets().add((Object)nextOperandMounter);
            ++i;
        }
        createContainer.getSDBracketInsertPosition().add(sdCombinedMounter);
        return sdCombined;
    }

    public SDCombinedFragment createCombinedFragment(SDBracketContainer container, SDAnchor anchor, InteractionOperatorKind kind, int operandsCount) {
        SDLifeLine sdLifeLine = container.getCoveredLifeLine();
        if (sdLifeLine.getModel() != this.myModel) {
            throw new IllegalArgumentException("Alien lifeline: " + sdLifeLine + ", for sdModel: " + this.myModel);
        }
        if (anchor != null && !anchor.isFirstElement() && anchor.getAnchor().getBracketContainer() != container) {
            throw new IllegalArgumentException("Anchor: " + anchor.getAnchor() + ", is not applicable to container: " + container + ", actual container is: " + anchor.getAnchor().getBracketContainer());
        }
        CreateContainer createContainer = this.findCreateContainer(container, anchor);
        if (createContainer == null) {
            return null;
        }
        CombinedFragment umlCombined = UMLFactory.eINSTANCE.createCombinedFragment();
        umlCombined.getCovereds().add((Object)sdLifeLine.getUmlLifeline());
        umlCombined.setInteractionOperator(kind);
        SDCombinedFragment sdCombined = this.getTraceImpl().bindNewCombinedFragment(umlCombined);
        sdCombined.getCoveredLifeLines().add((Object)sdLifeLine);
        SDMountingRegion sdCombinedMounter = this.getTraceImpl().bindNewMountingRegion(sdCombined);
        int i = 0;
        while (i < operandsCount) {
            InteractionOperand nextUMLOperand = umlCombined.createOperand(null);
            nextUMLOperand.getCovereds().add((Object)sdLifeLine.getUmlLifeline());
            SDInteractionOperand nextSDOperand = this.getTraceImpl().bindNewInteractionOperand(nextUMLOperand);
            sdCombined.getFrames().add((Object)nextSDOperand);
            nextSDOperand.getCoveredLifeLines().add((Object)sdLifeLine);
            SDMountingRegion nextOperandMounter = this.getTraceImpl().bindNewMountingRegion(nextSDOperand);
            sdCombinedMounter.getBrackets().add((Object)nextOperandMounter);
            ++i;
        }
        createContainer.getUMLInsertPosition().add((InteractionFragment)umlCombined);
        createContainer.getSDBracketInsertPosition().add(sdCombinedMounter);
        createContainer.getSDFrameInsertPosition().add(sdCombined);
        return sdCombined;
    }

    private CreateContainer findCreateContainer(SDBracketContainer sdContainer, SDAnchor anchor) {
        SDMountingRegion mountingRegion;
        if (sdContainer instanceof SDLifeLine) {
            return new OnLifelineCreateContainer((SDLifeLine)sdContainer, anchor);
        }
        if (sdContainer instanceof SDMountingRegion && (mountingRegion = (SDMountingRegion)sdContainer).getFrame() instanceof SDInteractionOperand) {
            return new OnInteractionOperandMounterCreateContainer(mountingRegion, anchor);
        }
        return null;
    }

    private SDBuilderTrace getTraceImpl() {
        return (SDBuilderTrace)this.myModel.getUMLTracing();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractCreateContainer
    implements CreateContainer {
        private final SDBracketContainer myBracketContainer;
        private final SDAnchor myAnchor;

        public AbstractCreateContainer(SDBracketContainer bracketContainer, SDAnchor anchor) {
            assert (anchor.isFirstElement() || bracketContainer == anchor.getAnchor().getBracketContainer());
            this.myBracketContainer = bracketContainer;
            this.myAnchor = anchor;
        }

        protected boolean isAfterAnchor() {
            return this.myAnchor != null && !this.myAnchor.isFirstElement() && !this.myAnchor.isBeforeNotAfterAnchor();
        }

        @Override
        public ListIterator<SDFrame> getSDFrameInsertPosition() {
            SDFrameContainer frameContainer = this.getFrameContainer();
            InsertAfter<SDFrame> theFramesPast = new InsertAfter<SDFrame>();
            if (this.isAfterAnchor()) {
                for (SDBracket nextBracketBefore : this.myBracketContainer.getBrackets()) {
                    if (nextBracketBefore == this.myAnchor.getAnchor()) break;
                    if (!(nextBracketBefore instanceof SDMountingRegion)) continue;
                    theFramesPast.considerAsPast(((SDMountingRegion)nextBracketBefore).getFrame());
                }
            }
            return theFramesPast.getAfterThePastPosition((List<SDFrame>)frameContainer.getFrames());
        }

        @Override
        public ListIterator<SDBracket> getSDBracketInsertPosition() {
            InsertAfter<SDBracket> theBracketsPast = new InsertAfter<SDBracket>();
            if (this.isAfterAnchor()) {
                theBracketsPast.considerAsPast(this.myAnchor.getAnchor());
            }
            return theBracketsPast.getAfterThePastPosition((List<SDBracket>)this.myBracketContainer.getBrackets());
        }

        @Override
        public ListIterator<InteractionFragment> getUMLInsertPosition() {
            InsertFragmentAfter umlPast = new InsertFragmentAfter();
            if (this.isAfterAnchor()) {
                umlPast.bracketFinished(this.myAnchor.getAnchor());
            }
            return umlPast.getAfterThePastPosition(this.getFrameContainer().getFragmentsList());
        }

        protected final SDBracketContainer getBracketContainer() {
            return this.myBracketContainer;
        }

        protected final SDAnchor getAnchor() {
            return this.myAnchor;
        }

        protected abstract SDFrameContainer getFrameContainer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CreateContainer {
        public ListIterator<InteractionFragment> getUMLInsertPosition();

        public ListIterator<SDFrame> getSDFrameInsertPosition();

        public ListIterator<SDBracket> getSDBracketInsertPosition();
    }

    private static class OnInteractionOperandMounterCreateContainer
    extends AbstractCreateContainer {
        public OnInteractionOperandMounterCreateContainer(SDMountingRegion region, SDAnchor anchor) {
            super(region, anchor);
            if (!(region.getFrame() instanceof SDInteractionOperand)) {
                throw new IllegalArgumentException("Only SDInteractionOperand is valid frame with some allowed contents of its mounting regions, " + region);
            }
        }

        protected SDFrameContainer getFrameContainer() {
            return this.getSDInteractionOperand();
        }

        protected final SDMountingRegion getMountingRegion() {
            return (SDMountingRegion)this.getBracketContainer();
        }

        protected final SDInteractionOperand getSDInteractionOperand() {
            return (SDInteractionOperand)this.getMountingRegion().getFrame();
        }
    }

    private static class OnLifelineCreateContainer
    extends AbstractCreateContainer {
        public OnLifelineCreateContainer(SDLifeLine lifeLine, SDAnchor anchor) {
            super(lifeLine, anchor);
        }

        protected SDFrameContainer getFrameContainer() {
            return this.getLifeline().getModel();
        }

        protected final SDLifeLine getLifeline() {
            return (SDLifeLine)this.getBracketContainer();
        }
    }
}

