/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.deploy.async;

import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.diagram.common.async.ApplySynchronizationCommand;
import org.eclipse.uml2.diagram.common.async.NewDiagramSyncHelper;
import org.eclipse.uml2.diagram.common.async.SyncModelContext;
import org.eclipse.uml2.diagram.common.async.SyncModelNode;
import org.eclipse.uml2.diagram.common.genapi.IDiagramUpdater;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;
import org.eclipse.uml2.diagram.deploy.async.UMLDeploymentDiagramHeaderFilter;
import org.eclipse.uml2.diagram.deploy.part.UMLCreateShortcutAction;
import org.eclipse.uml2.diagram.deploy.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.deploy.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.deploy.part.UMLNewDiagramFileWizard;
import org.eclipse.uml2.diagram.deploy.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Element;

public class UMLDeploymentFixedElementsWizard
extends UMLNewDiagramFileWizard {
    private final Element[] myToSelect;
    private NewDiagramSyncHelperWithFixedElements mySyncHelper;

    public UMLDeploymentFixedElementsWizard(URI domainModelURI, EObject diagramRoot, Element[] toSelect, TransactionalEditingDomain editingDomain) {
        super(domainModelURI, diagramRoot, editingDomain);
        this.myToSelect = toSelect;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.getDiagramRootElementSelectionPage());
        this.addPage((IWizardPage)this.getFileCreationPage());
    }

    protected boolean needsLayoutAll() throws ExecutionException {
        return true;
    }

    protected void layoutAll() throws ExecutionException {
        this.createShortcutsIfNeeded();
        super.layoutAll();
    }

    private void createShortcutsIfNeeded() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        DiagramEditPart diagramEditPart = ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart();
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        Element[] elementArray = this.myToSelect;
        int n = this.myToSelect.length;
        int n2 = 0;
        while (n2 < n) {
            Element next = elementArray[n2];
            if (!this.canCreateView((EObject)next)) {
                UMLCreateShortcutAction.createShortcut(diagramEditPart.getEditingDomain(), history, (EObject)next, (EditPart)diagramEditPart, editorPart);
            }
            ++n2;
        }
    }

    private boolean canCreateView(EObject element) {
        for (Object next : this.getDiagram().getChildren()) {
            View view = (View)next;
            if (!element.equals(view.getElement())) continue;
            return true;
        }
        return false;
    }

    protected AbstractTransactionalCommand getApplySynchronizationCommand() {
        EObject semanticRoot = this.getDiagramRootElementSelectionPage().getModelElement();
        this.getEditingDomain().getResourceSet().getResource(semanticRoot.eResource().getURI(), true);
        this.mySyncHelper = new NewDiagramSyncHelperWithFixedElements(this.createSyncContext(semanticRoot), "UMLDeployment");
        this.mySyncHelper.setSemanticRoot(semanticRoot);
        return new ApplySynchronizationCommand(this.mySyncHelper.getSyncRoot());
    }

    protected SyncModelContextWithFixedElements createSyncContext(EObject semanticRoot) {
        return new SyncModelContextWithFixedElements(UMLDiagramUpdater.TYPED_ADAPTER, UMLVisualIDRegistry.TYPED_ADAPTER, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT, this.getEditingDomain(), this.myToSelect, true);
    }

    protected Diagram getDiagram() {
        return this.mySyncHelper.getNewDiagram();
    }

    private static class NewDiagramSyncHelperWithFixedElements
    extends NewDiagramSyncHelper {
        public NewDiagramSyncHelperWithFixedElements(SyncModelContextWithFixedElements contextImpl, String diagramModelId) {
            super((SyncModelContext)contextImpl, diagramModelId);
        }

        protected SyncModelNode createRootNode(SyncModelContext context, Diagram syncDiagram, Diagram tempDiagram) {
            SyncModelNodeForInitializedDiagram result = new SyncModelNodeForInitializedDiagram((View)syncDiagram, (View)tempDiagram, context);
            return result;
        }
    }

    protected static class SyncModelContextWithFixedElements
    extends SyncModelContext {
        private Element[] myElementsToDisplay;

        public SyncModelContextWithFixedElements(IDiagramUpdater updater, IVisualIDRegistry registry, PreferencesHint preferencesHint, TransactionalEditingDomain domain, Element[] toSelect, boolean isDiagramInit) {
            super(updater, registry, preferencesHint, domain, isDiagramInit);
            this.myElementsToDisplay = toSelect;
        }

        public Element[] getElementsToDisplay() {
            return this.myElementsToDisplay;
        }
    }

    private static class SyncModelNodeForInitializedDiagram
    extends SyncModelNode {
        public SyncModelNodeForInitializedDiagram(View syncModelRoot, View diagramRoot, SyncModelContext context) {
            super(syncModelRoot, diagramRoot, context);
        }

        public boolean isAutoSynchronized() {
            return false;
        }

        private SyncModelNodeForInitializedDiagram(View syncModelView, SyncModelNode parent) {
            super(syncModelView, parent);
        }

        public void initWithDiagramView(View diagramView) {
            super.initWithDiagramView(diagramView);
            this.setChecked(this.isInToCreateList() || UMLDeploymentDiagramHeaderFilter.SHARED_INSTANCE.isFilteredVisualId(this));
        }

        private boolean isInToCreateList() {
            Element[] toSelect = ((SyncModelContextWithFixedElements)this.getContext()).getElementsToDisplay();
            if (toSelect == null || toSelect.length == 0) {
                return true;
            }
            return Arrays.asList(toSelect).contains(this.getSyncModelView().getElement());
        }

        protected SyncModelNode doCreateNodeView(View syncModelView, SyncModelNode parent) {
            return new SyncModelNodeForInitializedDiagram(syncModelView, parent);
        }
    }
}

