/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.TypeExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.internal.parser.CompatibilityParser;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.PersistentEnvironment;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.parser.TypeResolver;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.PrimitiveBoolean;
import org.eclipse.emf.ocl.types.PrimitiveInteger;
import org.eclipse.emf.ocl.types.PrimitiveReal;
import org.eclipse.emf.ocl.types.PrimitiveString;
import org.eclipse.emf.ocl.types.PrimitiveType;
import org.eclipse.emf.ocl.types.TupleType;
import org.eclipse.emf.ocl.types.TypeType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.TupleTypeImpl;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.uml.TypedElement;
import org.eclipse.emf.ocl.utilities.PredefinedType;
import org.eclipse.ocl.internal.l10n.OCLMessages;

public class TypeUtil {
    private TypeUtil() {
    }

    public static EOperation findOperationMatching(EClassifier owner, String name, EList args) {
        if (args == null) {
            args = ECollections.EMPTY_ELIST;
        }
        EList operations = TypeUtil.getOperations(owner);
        for (EOperation oper : operations) {
            if (!oper.getName().equals(name) || !TypeUtil.matchArgs(owner, oper.getEParameters(), args)) continue;
            return oper;
        }
        return null;
    }

    public static EClass findSignalMatching(EClassifier receiver, EList signals, String name, EList args) {
        if (args == null) {
            args = ECollections.EMPTY_ELIST;
        }
        for (EClass signal : signals) {
            if (!signal.getName().equals(name) || !TypeUtil.matchArgs(receiver, signal.getEAllStructuralFeatures(), args)) continue;
            return signal;
        }
        return null;
    }

    public static EList getOperations(EClassifier owner) {
        EList additionalOperations;
        EList result;
        if (owner instanceof PredefinedType) {
            PredefinedType source = (PredefinedType)owner;
            result = ECollections.unmodifiableEList((EList)source.getOperations());
        } else if (owner instanceof EClass) {
            result = new BasicEList();
            result.addAll((Collection)((EClass)owner).getEAllOperations());
            result.addAll((Collection)Types.OCL_ANY_TYPE.getOperations());
            result = ECollections.unmodifiableEList((EList)result);
        } else {
            result = owner instanceof EEnum ? ECollections.unmodifiableEList((EList)Types.OCL_ANY_TYPE.getOperations()) : (owner instanceof EDataType ? ((owner = TypeUtil.getOCLTypeFor((EDataType)owner)) instanceof PrimitiveType ? ECollections.unmodifiableEList((EList)((PrimitiveType)owner).getOperations()) : ECollections.unmodifiableEList((EList)Types.OCL_ANY_TYPE.getOperations())) : ECollections.EMPTY_ELIST);
        }
        if (owner != null && (additionalOperations = TypeUtil.getAdditionalOperations(owner)) != null && !additionalOperations.isEmpty()) {
            result = new BasicEList((Collection)result);
            result.addAll((Collection)additionalOperations);
        }
        return result;
    }

    public static EList getProperties(EClassifier owner) {
        EList additionalproperties;
        EList result;
        if (owner instanceof EClass) {
            result = ((EClass)owner).getEAllStructuralFeatures();
        } else {
            owner = TypeUtil.getOCLType(owner);
            result = ECollections.EMPTY_ELIST;
        }
        if (owner != null && (additionalproperties = TypeUtil.getAdditionalProperties(owner)) != null && !additionalproperties.isEmpty()) {
            result = new BasicEList((Collection)result);
            result.addAll((Collection)additionalproperties);
        }
        return result;
    }

    private static boolean matchArgs(EClassifier owner, EList params, EList args) {
        int argsize = args == null ? 0 : args.size();
        if (params.size() != argsize) {
            return false;
        }
        Iterator iter = params.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ETypedElement param = (ETypedElement)iter.next();
            Object arg = args.get(i);
            EClassifier argType = null;
            if (param.getEType() instanceof TypeType) {
                if (!(arg instanceof TypeExp)) {
                    return false;
                }
            } else {
                if (arg instanceof OCLExpression) {
                    argType = ((OCLExpression)arg).getType();
                } else if (arg instanceof Variable) {
                    argType = ((Variable)arg).getType();
                }
                EClassifier paramType = TypeUtil.getOCLType(param);
                paramType = TypeUtil.resolveGenericType(owner, paramType, argType);
                if (paramType != AnyTypeImpl.OCL_T && (TypeUtil.getRelationship(argType, paramType) & 3) == 0) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static EClassifier resolveGenericType(EClassifier owner, EClassifier paramType, EClassifier argType) {
        Object result = paramType;
        if (result == AnyTypeImpl.OCL_T) {
            result = owner;
            if (result instanceof CollectionType && (result = ((CollectionType)result).getElementType()) == Types.OCL_VOID) {
                result = AnyTypeImpl.OCL_T;
            }
        } else if (result instanceof CollectionType) {
            CollectionType collType = (CollectionType)result;
            EClassifier elemType = collType.getElementType();
            if (elemType == AnyTypeImpl.OCL_T) {
                result = TypesFactory.eINSTANCE.createCollectionType(collType.getKind(), owner instanceof CollectionType ? ((CollectionType)owner).getElementType() : owner);
            } else if (elemType == AnyTypeImpl.OCL_T2) {
                result = TypesFactory.eINSTANCE.createCollectionType(collType.getKind(), argType instanceof CollectionType ? ((CollectionType)argType).getElementType() : argType);
            }
        }
        return result;
    }

    public static EOperation resolveGenericSignature(EClassifier owner, EOperation oper) {
        EOperation result = EcoreFactory.eINSTANCE.createEOperation();
        result.setName(oper.getName());
        for (EParameter param : oper.getEParameters()) {
            EParameter resolved = EcoreFactory.eINSTANCE.createEParameter();
            resolved.setName(param.getName());
            resolved.setEType(TypeUtil.resolveGenericType(owner, param.getEType(), AnyTypeImpl.OCL_T));
            result.getEParameters().add((Object)resolved);
        }
        result.setEType(TypeUtil.getResultType(owner, oper));
        return result;
    }

    public static EClassifier getResultType(EClassifier owner, EOperation oper) {
        if (owner instanceof PredefinedType) {
            PredefinedType pt = (PredefinedType)owner;
            int opcode = pt.getOperationCodeFor(oper.getName());
            EList parameters = oper.getEParameters();
            int paramCount = parameters.size();
            BasicEList args = new BasicEList(paramCount);
            int i = 0;
            while (i < paramCount) {
                OCLExpression exp;
                EParameter param = (EParameter)parameters.get(i);
                Object paramType = param.getEType();
                if (paramType == Types.OCL_TYPE) {
                    exp = ExpressionsFactory.eINSTANCE.createTypeExp();
                    exp.setReferredType(AnyTypeImpl.OCL_T);
                    exp.setType(Types.OCL_TYPE);
                    args.add((Object)exp);
                } else {
                    CollectionType ct;
                    if (paramType instanceof CollectionType && (ct = (CollectionType)paramType).getElementType() == AnyTypeImpl.OCL_T2) {
                        paramType = TypesFactory.eINSTANCE.createCollectionType(ct.getKind(), AnyTypeImpl.OCL_T);
                    }
                    exp = ExpressionsFactory.eINSTANCE.createUnspecifiedValueExp();
                    exp.setType((EClassifier)paramType);
                    args.add((Object)exp);
                }
                ++i;
            }
            try {
                return ((PredefinedType)owner).getResultTypeFor(owner, opcode, (EList)args);
            }
            catch (Exception exception) {}
        }
        return TypeUtil.getOCLType(oper.getEType());
    }

    public static boolean type1AsType2(EClassifier type1, EClassifier type2) throws SemanticException {
        if (TypeUtil.typeCompare(type1, type2) != -1) {
            return true;
        }
        String message = OCLMessages.bind((String)OCLMessages.CastTypeMismatch_ERROR_, (Object)TypeUtil.getName((ENamedElement)type1), (Object)TypeUtil.getName((ENamedElement)type2));
        CompatibilityParser.ERR(message);
        return false;
    }

    public static int typeCompare(EClassifier type1, EClassifier type2) {
        switch (TypeUtil.getRelationship(type1, type2)) {
            case 1: {
                return 0;
            }
            case 2: {
                return -1;
            }
            case 4: {
                return 1;
            }
        }
        String message = OCLMessages.bind((String)OCLMessages.TypeMismatch_ERROR_, (Object)TypeUtil.getName((ENamedElement)type1), (Object)TypeUtil.getName((ENamedElement)type2));
        IllegalArgumentException error = new IllegalArgumentException(message);
        OCLPlugin.throwing(AnyTypeImpl.class, "typeCompare", error);
        throw error;
    }

    static String getName(ENamedElement element) {
        return element == null ? null : element.getName();
    }

    public static EClassifier commonSuperType(EClassifier type1, EClassifier type2) throws SemanticException {
        if (TypeUtil.eq(type1, type2)) {
            return type2;
        }
        if (type1 == AnyTypeImpl.OCL_T) {
            return type2;
        }
        if (type2 == AnyTypeImpl.OCL_T) {
            return type1;
        }
        if (type1 == Types.OCL_VOID || type1 == Types.INVALID) {
            return type2;
        }
        if (type2 == Types.OCL_VOID || type2 == Types.INVALID) {
            return type1;
        }
        if (type1 == Types.OCL_ANY_TYPE && !(type2 instanceof CollectionType)) {
            return Types.OCL_ANY_TYPE;
        }
        if (type2 == Types.OCL_ANY_TYPE && !(type1 instanceof CollectionType)) {
            return Types.OCL_ANY_TYPE;
        }
        if (type1 == Types.OCL_INTEGER && type2 == Types.OCL_REAL) {
            return Types.OCL_REAL;
        }
        if (type2 == Types.OCL_INTEGER && type1 == Types.OCL_REAL) {
            return Types.OCL_REAL;
        }
        if (type1 instanceof CollectionType) {
            return ((CollectionTypeImpl)type1).getCommonSupertype(type2);
        }
        if (type1 instanceof TupleType) {
            return ((TupleTypeImpl)type1).getCommonSupertype(type2);
        }
        if (type1 instanceof EClass && type2 instanceof EClass) {
            EClass eClass1 = (EClass)type1;
            EClass eClass2 = (EClass)type2;
            if (eClass1.isSuperTypeOf(eClass2)) {
                return eClass1;
            }
            if (eClass2.isSuperTypeOf(eClass1)) {
                return eClass2;
            }
            ArrayList<EClass> allSuperAndSelf1 = new ArrayList<EClass>((Collection<EClass>)eClass1.getEAllSuperTypes());
            allSuperAndSelf1.add(eClass1);
            ArrayList<EClass> allSuperAndSelf2 = new ArrayList<EClass>((Collection<EClass>)eClass2.getEAllSuperTypes());
            allSuperAndSelf2.add(eClass2);
            allSuperAndSelf1.retainAll(allSuperAndSelf2);
            if (!allSuperAndSelf1.isEmpty()) {
                return (EClassifier)allSuperAndSelf1.get(allSuperAndSelf1.size() - 1);
            }
        }
        String message = OCLMessages.bind((String)OCLMessages.TypeMismatch_ERROR_, (Object)TypeUtil.getName((ENamedElement)type1), (Object)TypeUtil.getName((ENamedElement)type2));
        CompatibilityParser.ERR(message);
        return null;
    }

    private static boolean eq(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static int getRelationship(EClassifier type1, EClassifier type2) {
        if (TypeUtil.eq(type1, type2)) {
            return 1;
        }
        if (type1 == Types.OCL_ANY_TYPE && !(type2 instanceof CollectionType)) {
            return 4;
        }
        if (type2 == Types.OCL_ANY_TYPE && !(type1 instanceof CollectionType)) {
            return 2;
        }
        if (type1 instanceof PredefinedType) {
            return ((PredefinedType)type1).getRelationshipTo(type2);
        }
        if (type2 instanceof PredefinedType) {
            return TypeUtil.inverseRelationship(((PredefinedType)type2).getRelationshipTo(type1));
        }
        if (type1 instanceof EClass && type2 instanceof EClass) {
            if (TypeUtil.eq(type1, type2)) {
                return 1;
            }
            if (((EClass)type1).isSuperTypeOf((EClass)type2)) {
                return 4;
            }
            if (((EClass)type2).isSuperTypeOf((EClass)type1)) {
                return 2;
            }
        }
        return 8;
    }

    static int inverseRelationship(int rel) {
        switch (rel) {
            case 2: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 5;
            }
            case 5: {
                return 3;
            }
        }
        return rel;
    }

    static boolean isPrimitive(Object o) {
        return o instanceof Integer || o instanceof String || o instanceof Boolean || o instanceof Double;
    }

    static boolean isComparable(EClassifier type) {
        return type instanceof EDataType && Comparable.class.isAssignableFrom(((EDataType)type).getInstanceClass());
    }

    static EOperation createUnaryOperation(EClassifier resultType, String name) {
        EOperation result = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        result.setEType(resultType);
        result.setName(name);
        return result;
    }

    static EOperation createBinaryOperation(EClassifier resultType, String name, EClassifier param, String paramName) {
        EOperation result = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        result.setEType(resultType);
        result.setName(name);
        EParameter parameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        parameter.setEType(param);
        parameter.setName(paramName);
        result.getEParameters().add((Object)parameter);
        return result;
    }

    static EOperation createTernaryOperation(EClassifier resultType, String name, EClassifier param1, String param1Name, EClassifier param2, String param2Name) {
        EOperation result = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        result.setEType(resultType);
        result.setName(name);
        EParameter parameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        parameter.setEType(param1);
        parameter.setName(param1Name);
        result.getEParameters().add((Object)parameter);
        parameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        parameter.setEType(param2);
        parameter.setName(param2Name);
        result.getEParameters().add((Object)parameter);
        return result;
    }

    static EStructuralFeature createProperty(ETypedElement element) {
        return TypeUtil.createProperty(element.getName(), TypeUtil.getOCLType(element));
    }

    static EStructuralFeature createProperty(TypedElement element) {
        return TypeUtil.createProperty(element.getName(), element.getType());
    }

    private static EStructuralFeature createProperty(String name, EClassifier type) {
        EReference result;
        if (type instanceof EClass) {
            result = EcoreFactory.eINSTANCE.createEReference();
        } else {
            result = EcoreFactory.eINSTANCE.createEAttribute();
            if (type == Types.OCL_BOOLEAN) {
                type = EcorePackage.eINSTANCE.getEBoolean();
            } else if (type == Types.OCL_INTEGER) {
                type = EcorePackage.eINSTANCE.getEIntegerObject();
            } else if (type == Types.OCL_STRING) {
                type = EcorePackage.eINSTANCE.getEString();
            } else if (type == Types.OCL_REAL) {
                type = EcorePackage.eINSTANCE.getEDoubleObject();
            }
        }
        result.setName(name);
        result.setEType(type);
        return result;
    }

    private static EClassifier getOCLTypeFor(EDataType dataType) {
        if (dataType instanceof EEnum) {
            return dataType;
        }
        if (dataType instanceof CollectionType) {
            return dataType;
        }
        if (dataType instanceof PrimitiveType) {
            return dataType;
        }
        Class instanceClass = dataType.getInstanceClass();
        if (instanceClass == Boolean.class || instanceClass == Boolean.TYPE) {
            return Types.OCL_BOOLEAN;
        }
        if (instanceClass == Double.class || instanceClass == Double.TYPE || instanceClass == Float.class || instanceClass == Float.TYPE) {
            return Types.OCL_REAL;
        }
        if (instanceClass == String.class) {
            return Types.OCL_STRING;
        }
        if (instanceClass == Integer.class || instanceClass == Integer.TYPE || instanceClass == Long.class || instanceClass == Long.TYPE || instanceClass == Short.class || instanceClass == Short.TYPE) {
            return Types.OCL_INTEGER;
        }
        if (List.class.isAssignableFrom(instanceClass)) {
            return CollectionTypeImpl.OCL_SEQUENCE;
        }
        if (Set.class.isAssignableFrom(instanceClass)) {
            return CollectionTypeImpl.OCL_SET;
        }
        if (Collection.class.isAssignableFrom(instanceClass)) {
            return CollectionTypeImpl.OCL_COLLECTION;
        }
        if (instanceClass == Object.class) {
            return Types.OCL_ANY_TYPE;
        }
        return dataType;
    }

    public static EClassifier getOCLType(ETypedElement typedElement) {
        EClassifier resultType = typedElement.getEType();
        resultType = TypeUtil.isMany(typedElement) ? TypeUtil.getOCLCollectionType(resultType, typedElement.isOrdered(), typedElement.isUnique()) : TypeUtil.getOCLType(resultType);
        return resultType;
    }

    public static EClassifier getOCLType(EClassifier type) {
        EClassifier resultType = type;
        if (resultType instanceof EDataType) {
            resultType = TypeUtil.getOCLTypeFor((EDataType)resultType);
        }
        return resultType;
    }

    public static EClassifier getOCLCollectionType(EClassifier type, boolean isOrdered, boolean isUnique) {
        Object resultType = type;
        if (resultType instanceof EDataType) {
            resultType = TypeUtil.getOCLTypeFor((EDataType)resultType);
        }
        resultType = isOrdered ? (isUnique ? TypesFactory.eINSTANCE.createOrderedSetType((EClassifier)resultType) : TypesFactory.eINSTANCE.createSequenceType((EClassifier)resultType)) : (isUnique ? TypesFactory.eINSTANCE.createSetType((EClassifier)resultType) : TypesFactory.eINSTANCE.createBagType((EClassifier)resultType));
        return resultType;
    }

    public static boolean isMany(ETypedElement typedElement) {
        if (typedElement instanceof EStructuralFeature) {
            int upperBound = typedElement.getUpperBound();
            return upperBound > 1 || upperBound < 0;
        }
        return typedElement.isMany();
    }

    public static EClassifier resolveType(Environment env, EClassifier type) {
        return env instanceof PersistentEnvironment ? ((PersistentEnvironment)env).getTypeResolver().resolve(type) : type;
    }

    public static EStructuralFeature defineProperty(EClassifier owner, Variable variable) {
        String name = variable.getName();
        EClassifier type = variable.getType();
        Object result = type instanceof EClass ? EcoreFactory.eINSTANCE.createEReference() : EcoreFactory.eINSTANCE.createEAttribute();
        result.setName(name);
        TypeUtil.setType((ETypedElement)result, type);
        AdditionalFeaturesAdapter adapter = TypeUtil.getAdditionalFeatures(owner);
        if (adapter == null) {
            adapter = new AdditionalFeaturesAdapter();
            owner.eAdapters().add((Object)adapter);
        }
        adapter.define((EStructuralFeature)result);
        return result;
    }

    public static EOperation defineOperation(EClassifier owner, String name, EList params, EClassifier type) {
        EOperation result = EcoreFactory.eINSTANCE.createEOperation();
        result.setName(name);
        TypeUtil.setType((ETypedElement)result, type);
        for (Variable next : params) {
            EParameter param = EcoreFactory.eINSTANCE.createEParameter();
            param.setName(next.getName());
            TypeUtil.setType((ETypedElement)param, next.getType());
            result.getEParameters().add((Object)param);
        }
        AdditionalFeaturesAdapter adapter = TypeUtil.getAdditionalFeatures(owner);
        if (adapter == null) {
            adapter = new AdditionalFeaturesAdapter();
            owner.eAdapters().add((Object)adapter);
        }
        adapter.define(result);
        return result;
    }

    private static void setType(ETypedElement element, EClassifier type) {
        if (type == Types.OCL_VOID) {
            type = null;
        }
        if (!(type instanceof CollectionType)) {
            element.setEType(TypeUtil.unOCLType(type));
        } else {
            CollectionType collType = (CollectionType)type;
            EClassifier elementType = collType.getElementType();
            if (elementType == Types.OCL_VOID) {
                elementType = null;
            }
            element.setEType(TypeUtil.unOCLType(elementType));
            element.setUpperBound(-1);
            switch (collType.getKind().getValue()) {
                case 3: {
                    element.setOrdered(false);
                    element.setUnique(false);
                    break;
                }
                case 2: {
                    element.setOrdered(false);
                    element.setUnique(true);
                    break;
                }
                case 4: {
                    element.setOrdered(true);
                    element.setUnique(false);
                    break;
                }
                case 5: {
                    element.setOrdered(true);
                    element.setUnique(true);
                }
            }
        }
    }

    static EClassifier unOCLType(EClassifier oclType) {
        EClassifier result = oclType;
        if (oclType instanceof PrimitiveType) {
            if (oclType instanceof PrimitiveBoolean) {
                result = EcorePackage.Literals.EBOOLEAN_OBJECT;
            } else if (oclType instanceof PrimitiveString) {
                result = EcorePackage.Literals.ESTRING;
            } else if (oclType instanceof PrimitiveInteger) {
                result = EcorePackage.Literals.EINTEGER_OBJECT;
            } else if (oclType instanceof PrimitiveReal) {
                result = EcorePackage.Literals.EDOUBLE_OBJECT;
            }
        }
        return result;
    }

    public static EList getAdditionalProperties(EClassifier owner) {
        BasicEList result = null;
        AdditionalFeaturesAdapter adapter = TypeUtil.getAdditionalFeatures(owner);
        if (adapter != null && adapter.getAdditionalProperties() != null && result == null) {
            result = new BasicEList((Collection)adapter.getAdditionalProperties());
        }
        if (owner instanceof EClass) {
            for (EClass next : ((EClass)owner).getEAllSuperTypes()) {
                adapter = TypeUtil.getAdditionalFeatures((EClassifier)next);
                if (adapter == null || adapter.getAdditionalProperties() == null) continue;
                if (result == null) {
                    result = new BasicEList((Collection)adapter.getAdditionalProperties());
                    continue;
                }
                result.addAll((Collection)adapter.getAdditionalProperties());
            }
        }
        return result;
    }

    public static EList getAdditionalOperations(EClassifier owner) {
        BasicEList result = null;
        AdditionalFeaturesAdapter adapter = TypeUtil.getAdditionalFeatures(owner);
        if (adapter != null && adapter.getAdditionalOperations() != null && result == null) {
            result = new BasicEList((Collection)adapter.getAdditionalOperations());
        }
        if (owner instanceof EClass) {
            for (EClass next : ((EClass)owner).getEAllSuperTypes()) {
                adapter = TypeUtil.getAdditionalFeatures((EClassifier)next);
                if (adapter == null || adapter.getAdditionalOperations() == null) continue;
                if (result == null) {
                    result = new BasicEList((Collection)adapter.getAdditionalOperations());
                    continue;
                }
                result.addAll((Collection)adapter.getAdditionalOperations());
            }
        }
        return result;
    }

    static AdditionalFeaturesAdapter getAdditionalFeatures(EClassifier owner) {
        return (AdditionalFeaturesAdapter)EcoreUtil.getExistingAdapter((Notifier)owner, AdditionalFeaturesAdapter.class);
    }

    public static void undefineAdditionalFeatures(EClassifier owner) {
        AdditionalFeaturesAdapter adapter = TypeUtil.getAdditionalFeatures(owner);
        if (adapter != null) {
            owner.eAdapters().remove((Object)adapter);
        }
    }

    public static void resolveAdditionalFeatures(EClassifier owner, Environment env) {
        AdditionalFeaturesAdapter adapter = TypeUtil.getAdditionalFeatures(owner);
        if (adapter != null) {
            adapter.resolve(owner, env);
        }
    }

    private static class AdditionalFeaturesAdapter
    extends AdapterImpl {
        private EList additionalProperties;
        private EList additionalOperations;

        private AdditionalFeaturesAdapter() {
        }

        protected EClassifier getOwner() {
            return (EClassifier)this.getTarget();
        }

        public boolean isAdapterForType(Object type) {
            return type == AdditionalFeaturesAdapter.class;
        }

        public EList getAdditionalOperations() {
            return this.additionalOperations;
        }

        public EList getAdditionalProperties() {
            return this.additionalProperties;
        }

        public void define(EOperation operation) {
            if (this.additionalOperations == null) {
                this.additionalOperations = new BasicEList();
            }
            this.additionalOperations.add((Object)operation);
        }

        public void define(EStructuralFeature property) {
            if (this.additionalProperties == null) {
                this.additionalProperties = new BasicEList();
            }
            this.additionalProperties.add((Object)property);
        }

        public void resolve(EClassifier owner, Environment env) {
            if (env instanceof PersistentEnvironment) {
                EStructuralFeature resolved;
                EStructuralFeature next;
                ListIterator iter;
                TypeResolver resolver = ((PersistentEnvironment)env).getTypeResolver();
                Resource resource = resolver.getResource();
                if (this.additionalProperties != null) {
                    iter = this.additionalProperties.listIterator();
                    while (iter.hasNext()) {
                        next = (EStructuralFeature)iter.next();
                        resolved = next.eIsProxy() ? (EStructuralFeature)EcoreUtil.resolve((EObject)next, (Resource)resource) : resolver.resolveAdditionalProperty(owner, next);
                        if (resolved == next) continue;
                        iter.set(resolved);
                    }
                }
                if (this.additionalOperations != null) {
                    iter = this.additionalOperations.listIterator();
                    while (iter.hasNext()) {
                        next = (EOperation)iter.next();
                        resolved = next.eIsProxy() ? (EOperation)EcoreUtil.resolve((EObject)next, (Resource)resource) : resolver.resolveAdditionalOperation(owner, (EOperation)next);
                        if (resolved == next) continue;
                        iter.set(resolved);
                    }
                }
            }
        }
    }
}

