/**
* <copyright>
*
* Copyright (c) 2005, 2009 IBM Corporation, Zeligsoft Inc., and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Lexer and Parser refactoring to support extensibility and flexible error handling
*      - Bug 259818
*
* </copyright>
*
* $Id: OCLBacktrackingLexerprs.java,v 1.1 2009/01/13 20:31:30 cdamus Exp $
*/

package org.eclipse.ocl.parser.backtracking;

/**
 * The backtracking variant of the OCL lexer parse table.
 * 
 * @noextend This class is not intended to be subclassed by clients.
 * 
 * @since 1.3
 */
public class OCLBacktrackingLexerprs implements lpg.lpgjavaruntime.ParseTable, OCLBacktrackingLexersym {

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static byte baseCheck[] = {0,
            1,1,3,3,3,1,1,1,1,1,
            5,1,1,1,1,1,1,1,1,1,
            1,2,2,2,1,1,1,1,2,1,
            1,1,2,1,1,2,4,1,2,1,
            1,1,2,2,3,2,2,0,1,2,
            2,2,1,2,1,2,3,2,3,3,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,2,3,1,1,1,1,
            1,2,1,2,2,2,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,2,2,1,
            2,1,2,0,1,3,3,3,3,3,
            3,3,4,4,3,3
        };
    };
    public final static byte baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static byte rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            21,21,21,21,21,21,21,21,21,21,
            21,21,21,21,21,21,21,21,21,21,
            21,21,21,21,21,21,21,21,21,21,
            21,21,21,21,21,21,21,21,21,21,
            21,22,23,23,23,27,27,27,27,28,
            28,26,26,6,6,35,35,30,13,13,
            13,9,9,9,9,9,2,2,2,2,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,4,4,4,4,
            4,4,4,4,4,4,4,4,4,4,
            4,4,4,4,4,4,4,4,4,4,
            4,4,1,1,1,1,1,1,1,1,
            1,1,37,37,37,37,37,37,37,37,
            38,38,38,38,38,38,38,38,38,38,
            38,38,36,36,39,39,39,15,15,40,
            40,29,29,11,11,11,11,11,32,32,
            32,32,32,32,32,32,32,32,32,32,
            32,32,32,32,32,32,32,32,32,32,
            32,32,32,32,32,32,32,32,17,17,
            17,17,17,17,17,17,17,17,17,17,
            17,17,17,17,17,17,17,17,17,17,
            17,17,17,17,17,17,17,18,18,18,
            18,18,18,18,18,18,18,18,18,18,
            18,18,18,18,18,18,18,18,18,18,
            18,18,18,18,18,18,7,7,7,7,
            7,7,7,7,7,7,7,7,7,7,
            7,7,7,7,7,7,7,7,7,7,
            7,7,7,7,7,7,14,14,14,14,
            31,31,31,31,31,31,31,31,19,19,
            19,19,19,8,8,8,8,8,5,20,
            33,33,10,10,12,12,16,24,24,24,
            24,24,24,24,24,24,25,891,478,472,
            472,472,2,354,1236,344,479,1280,491,1283,
            344,1247,408,480,1269,54,162,408,339,6,
            7,8,9,421,1223,54,337,488,309,481,
            481,481,481,481,985,481,481,44,431,334,
            427,309,481,481,481,481,481,1330,481,481,
            304,431,1217,437,406,457,457,457,457,457,
            990,457,457,1287,457,794,466,466,466,466,
            1291,54,1,47,47,47,47,402,1307,54,
            1288,47,1068,466,466,466,47,1318,54,47,
            1146,205,52,52,52,52,1331,100,466,1216,
            473,503,313,313,313,313,313,986,313,313,
            994,400,496,496,496,1219,400,1069,1258,417,
            1333,496,52,52,417,1289,496,600,313,313,
            313,313,313,1332,313,313,697,311,311,311,
            311,1220,1334,103,45,45,45,45,1335,1336,
            1337,1281,45,506,311,311,311,45,1329,506,
            45,1073,165,164,164,164,1148,165,164,164,
            164,43,506,334,506,506
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,0,
            100,101,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,97,
            98,102,100,101,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,88,89,90,91,92,93,94,95,
            96,97,98,0,0,0,0,103,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,88,89,90,91,
            92,93,94,95,96,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,91,92,93,94,
            95,96,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,0,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,89,90,91,92,93,94,95,96,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,0,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,0,0,0,0,0,0,97,98,0,
            100,101,102,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,0,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,75,
            67,68,69,70,71,76,73,0,0,0,
            77,78,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,102,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,71,0,
            0,73,0,0,0,0,74,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,0,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,68,69,0,0,0,0,0,
            0,74,0,1,2,3,4,5,6,7,
            8,9,10,11,12,0,1,2,3,4,
            5,6,7,8,9,10,0,1,2,3,
            4,5,6,7,8,9,10,0,1,2,
            3,4,5,6,7,8,9,10,0,1,
            2,3,4,5,6,7,8,9,10,0,
            0,66,0,67,66,66,0,0,0,67,
            0,1,2,3,4,5,6,7,8,9,
            10,15,15,15,69,70,0,1,2,3,
            4,5,6,7,8,9,10,0,1,2,
            3,4,5,6,7,8,9,10,0,0,
            0,0,0,0,0,0,0,0,0,11,
            12,0,13,11,14,0,15,0,0,0,
            0,72,0,0,68,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,97,98,0,100,
            101,99,102,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,99,99,99,99,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            506,553,553,553,553,553,553,553,553,553,
            553,553,553,553,553,553,553,553,553,553,
            553,553,553,553,553,553,553,553,553,553,
            553,553,553,553,553,553,553,553,553,553,
            553,553,553,553,553,553,553,553,553,553,
            553,553,553,553,553,553,553,553,553,553,
            553,553,553,553,553,553,553,553,553,553,
            553,473,553,553,553,553,553,553,552,553,
            553,553,553,553,553,553,553,553,553,553,
            553,553,553,553,553,553,553,553,553,506,
            553,553,506,551,551,551,551,551,551,551,
            551,551,551,551,551,551,551,551,551,551,
            551,551,551,551,551,551,551,551,551,551,
            551,551,551,551,551,551,551,551,551,551,
            551,551,551,551,551,551,551,551,551,551,
            551,551,551,551,551,551,551,551,551,551,
            551,551,551,551,551,551,551,551,551,551,
            551,551,551,556,551,551,551,551,551,551,
            517,551,551,551,551,551,551,551,551,551,
            551,551,551,551,551,551,551,551,551,551,
            551,511,551,551,10,558,558,558,558,558,
            558,558,558,558,558,558,558,558,558,558,
            558,558,558,558,558,558,558,558,558,558,
            558,558,558,558,558,558,558,558,558,558,
            558,558,558,558,558,558,558,558,558,558,
            558,558,558,558,558,558,558,558,558,558,
            558,558,558,558,558,558,558,558,558,558,
            558,558,558,558,558,558,558,558,558,558,
            558,558,558,558,558,558,558,558,558,558,
            558,558,558,558,558,558,558,558,558,558,
            558,558,558,48,506,506,506,558,314,481,
            481,481,481,481,481,481,481,481,481,481,
            481,481,481,481,481,481,481,481,481,481,
            481,481,481,481,481,481,481,481,481,481,
            481,481,481,481,481,481,481,481,481,481,
            481,481,481,481,481,481,481,481,481,481,
            481,481,481,481,481,481,481,481,481,481,
            481,481,481,481,429,481,481,481,481,481,
            481,481,481,481,481,481,481,481,481,481,
            481,481,481,481,481,481,481,481,481,481,
            481,481,481,481,481,506,457,457,457,457,
            457,457,457,457,457,457,457,457,457,457,
            457,457,457,457,457,457,457,457,457,457,
            457,457,457,457,457,457,457,457,457,457,
            457,457,457,457,457,457,457,457,457,457,
            457,457,457,457,457,457,457,457,457,457,
            457,457,457,457,457,457,457,457,457,457,
            457,445,457,457,457,457,457,457,457,457,
            457,457,457,457,457,457,457,457,457,457,
            457,457,457,457,457,457,457,457,457,457,
            457,457,315,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,429,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,506,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,471,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,819,819,819,819,
            819,819,819,819,819,819,506,817,817,817,
            817,817,817,817,817,817,817,817,817,817,
            817,817,817,817,817,817,817,817,817,817,
            817,817,817,817,817,817,817,817,817,817,
            817,817,817,817,817,817,817,817,817,817,
            817,817,817,817,817,817,817,817,817,817,
            817,817,817,817,817,817,817,817,817,817,
            817,817,817,817,817,817,817,817,817,822,
            817,817,817,817,817,817,817,817,817,817,
            817,817,817,817,817,817,817,817,817,817,
            817,817,447,506,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,506,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,447,
            506,478,478,478,478,478,478,478,478,478,
            478,472,472,472,472,527,472,472,472,472,
            472,472,472,472,472,472,472,472,472,472,
            472,472,472,472,472,472,472,472,472,472,
            472,472,472,472,472,472,472,472,472,472,
            472,472,472,472,472,472,472,472,472,472,
            472,472,472,472,472,472,384,382,410,420,
            519,521,479,395,506,364,390,393,412,536,
            377,358,540,533,534,531,532,546,537,523,
            524,506,506,506,38,506,506,479,479,32,
            479,479,371,506,400,400,400,400,400,400,
            400,400,400,400,496,496,496,496,506,496,
            496,496,496,496,496,496,496,496,496,496,
            496,496,496,496,496,496,496,496,496,496,
            496,496,496,496,496,496,496,496,496,496,
            496,496,496,496,496,496,496,496,496,496,
            496,496,496,496,496,496,496,496,496,545,
            832,455,825,824,826,539,395,16,506,506,
            463,827,1,671,671,671,671,671,671,671,
            671,671,671,670,670,670,670,510,670,670,
            670,670,670,670,670,670,670,670,670,670,
            670,670,670,670,670,670,670,670,670,670,
            670,670,670,670,670,670,670,670,670,670,
            670,670,670,670,670,670,670,670,670,670,
            670,670,670,670,670,670,670,670,380,506,
            506,815,506,506,506,14,672,317,671,671,
            671,671,671,671,671,671,671,671,670,670,
            670,670,506,670,670,670,670,670,670,670,
            670,670,670,670,670,670,670,670,670,670,
            670,670,670,670,670,670,670,670,670,670,
            670,670,670,670,670,670,670,670,670,670,
            670,670,670,670,670,670,670,670,670,670,
            670,670,670,535,557,506,35,506,308,3,
            506,672,6,560,560,560,560,560,560,560,
            560,560,560,334,334,506,344,344,344,344,
            344,344,344,344,344,344,506,408,408,408,
            408,408,408,408,408,408,408,506,417,417,
            417,417,417,417,417,417,417,417,58,560,
            560,560,560,560,560,560,560,560,560,12,
            312,814,506,542,814,814,20,19,325,440,
            57,560,560,560,560,560,560,560,560,560,
            560,529,528,830,448,341,60,560,560,560,
            560,560,560,560,560,560,560,59,560,560,
            560,560,560,560,560,560,560,560,7,506,
            506,322,506,163,53,161,167,506,506,334,
            334,506,426,543,450,506,829,506,506,506,
            506,668,506,506,530,506,506,506,506,506,
            506,506,506,506,506,506,506,506,506,506,
            506,506,506,506,506,506,668,668,506,668,
            668,505,315,506,506,506,506,506,506,506,
            506,506,506,506,506,506,506,506,506,506,
            506,506,506,506,506,506,506,506,506,506,
            506,506,506,506,506,506,506,506,506,506,
            506,506,506,506,506,506,506,506,506,506,
            506,506,1,6,12,1
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }
    public final int asb(int index) { return 0; }
    public final int asr(int index) { return 0; }
    public final int nasb(int index) { return 0; }
    public final int nasr(int index) { return 0; }
    public final int terminalIndex(int index) { return 0; }
    public final int nonterminalIndex(int index) { return 0; }
    public final int scopePrefix(int index) { return 0;}
    public final int scopeSuffix(int index) { return 0;}
    public final int scopeLhs(int index) { return 0;}
    public final int scopeLa(int index) { return 0;}
    public final int scopeStateSet(int index) { return 0;}
    public final int scopeRhs(int index) { return 0;}
    public final int scopeState(int index) { return 0;}
    public final int inSymb(int index) { return 0;}
    public final String name(int index) { return null; }
    public final int getErrorSymbol() { return 0; }
    public final int getScopeUbound() { return 0; }
    public final int getScopeSize() { return 0; }
    public final int getMaxNameLength() { return 0; }

    public final static int
           NUM_STATES        = 49,
           NT_OFFSET         = 103,
           LA_STATE_OFFSET   = 832,
           MAX_LA            = 1,
           NUM_RULES         = 326,
           NUM_NONTERMINALS  = 40,
           NUM_SYMBOLS       = 143,
           SEGMENT_SIZE      = 8192,
           START_STATE       = 327,
           IDENTIFIER_SYMBOL = 0,
           EOFT_SYMBOL       = 99,
           EOLT_SYMBOL       = 104,
           ACCEPT_ACTION     = 505,
           ERROR_ACTION      = 506;

    public final static boolean BACKTRACK = false;

    public final int getNumStates() { return NUM_STATES; }
    public final int getNtOffset() { return NT_OFFSET; }
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }
    public final int getMaxLa() { return MAX_LA; }
    public final int getNumRules() { return NUM_RULES; }
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }
    public final int getNumSymbols() { return NUM_SYMBOLS; }
    public final int getSegmentSize() { return SEGMENT_SIZE; }
    public final int getStartState() { return START_STATE; }
    public final int getStartSymbol() { return lhs[0]; }
    public final int getIdentifierSymbol() { return IDENTIFIER_SYMBOL; }
    public final int getEoftSymbol() { return EOFT_SYMBOL; }
    public final int getEoltSymbol() { return EOLT_SYMBOL; }
    public final int getAcceptAction() { return ACCEPT_ACTION; }
    public final int getErrorAction() { return ERROR_ACTION; }
    public final boolean isValidForParser() { return isValidForParser; }
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int originalState(int state) { return 0; }
    public final int asi(int state) { return 0; }
    public final int nasi(int state) { return 0; }
    public final int inSymbol(int state) { return 0; }

    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
