/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.links;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InterfaceLinkFilter<T> {
    protected final boolean ourHideReferencedGenuine;
    protected final boolean ourHideDerived;
    private final Collection<T> myInterfaceLinks = new LinkedList<T>();
    private final List<Classifier> myClassifiersTypingPort = new ArrayList<Classifier>(1);

    public InterfaceLinkFilter(boolean hideDerived, boolean hideReferencedGenuine) {
        this.ourHideDerived = hideDerived;
        this.ourHideReferencedGenuine = hideReferencedGenuine;
    }

    public void visit(T link) {
        this.visitReqiredOrProvidedInterfaceLink(link);
    }

    public Collection<T> getFilteredLinks() {
        return this.getFilteredLinks(this.myInterfaceLinks);
    }

    protected Collection<T> getFilteredLinks(Collection<T> links) {
        ArrayList<T> result = new ArrayList<T>();
        for (T next : links) {
            if (this.ourHideDerived && this.isDerivedLink(next) || this.ourHideReferencedGenuine && this.isGenuineLink(next)) continue;
            result.add(next);
        }
        return result;
    }

    protected void visitReqiredOrProvidedInterfaceLink(T link) {
        Port port;
        Type type;
        if (!this.isInterfaceLink(link)) {
            return;
        }
        this.myInterfaceLinks.add(link);
        EObject source = this.getSource(link);
        if (source instanceof Port && (type = (Type)(port = (Port)source).eGet((EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE, false)) instanceof Classifier && !(type instanceof Interface)) {
            Classifier classifier = (Classifier)port.getType();
            this.myClassifiersTypingPort.add(classifier);
            this.myClassifiersTypingPort.addAll((Collection<Classifier>)classifier.allParents());
        }
    }

    protected boolean isDerivedLink(T link) {
        return this.getSource(link) != null && this.getSource(link) instanceof Port;
    }

    protected boolean isGenuineLink(T link) {
        EObject source = this.getSource(link);
        return this.myClassifiersTypingPort.contains(source);
    }

    protected boolean isInterfaceLink(T link) {
        return false;
    }

    protected abstract EObject getSource(T var1);
}

