/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.AbstractEvaluationVisitor;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationHaltedException;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.evaluation.IterationTemplate;
import org.eclipse.ocl.internal.evaluation.IterationTemplateAny;
import org.eclipse.ocl.internal.evaluation.IterationTemplateClosure;
import org.eclipse.ocl.internal.evaluation.IterationTemplateCollect;
import org.eclipse.ocl.internal.evaluation.IterationTemplateCollectNested;
import org.eclipse.ocl.internal.evaluation.IterationTemplateExists;
import org.eclipse.ocl.internal.evaluation.IterationTemplateForAll;
import org.eclipse.ocl.internal.evaluation.IterationTemplateIsUnique;
import org.eclipse.ocl.internal.evaluation.IterationTemplateOne;
import org.eclipse.ocl.internal.evaluation.IterationTemplateReject;
import org.eclipse.ocl.internal.evaluation.IterationTemplateSelect;
import org.eclipse.ocl.internal.evaluation.IterationTemplateSortedBy;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.util.UnicodeSupport;
import org.eclipse.ocl.utilities.PredefinedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationVisitorImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends AbstractEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static int tempCounter = 0;
    private EvaluationEnvironment.Enumerations<EL> enumerations;

    public EvaluationVisitorImpl(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, EvaluationEnvironment<C, O, P, CLS, E> evalEnv, Map<? extends CLS, ? extends Set<? extends E>> extentMap) {
        super(env, evalEnv, extentMap);
        this.enumerations = OCLUtil.getAdapter(evalEnv, EvaluationEnvironment.Enumerations.class);
    }

    @Override
    public Object visitOperationCallExp(OperationCallExp<C, O> oc) {
        OCLExpression arg;
        OCLExpression source = oc.getSource();
        Object sourceType = source.getType();
        O oper = oc.getReferredOperation();
        int opCode = oc.getOperationCode();
        EList<OCLExpression<C>> args = oc.getArgument();
        int numArgs = args.size();
        Object sourceVal = source.accept(this.getVisitor());
        OCLExpression body = this.getOperationBody(oper);
        if (body != null || opCode <= 0 || this.getEvaluationEnvironment().overrides(oper, opCode)) {
            Object[] evalArgs = new Object[numArgs];
            int i = 0;
            for (OCLExpression arg2 : args) {
                evalArgs[i] = arg2.accept(this.getVisitor());
                ++i;
            }
            try {
                Object result;
                if (body != null) {
                    if (this.isUndefined(sourceVal)) {
                        return this.getOclInvalid();
                    }
                    result = this.call(oper, body, sourceVal, evalArgs);
                } else {
                    if (opCode <= 0) {
                        opCode = this.inferOperationCode(oper, opCode);
                    }
                    result = this.getEvaluationEnvironment().callOperation(oper, opCode, sourceVal, evalArgs);
                }
                return result;
            }
            catch (EvaluationHaltedException e) {
                throw e;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception e) {
                OCLPlugin.catching(this.getClass(), "visitOperationCallExp", e);
                OCLPlugin.log(4, 10, OCLMessages.bind(OCLMessages.ErrorMessage_ERROR_, "visitOperationCallExp", e.getLocalizedMessage()), e);
                return this.getOclInvalid();
            }
        }
        if (opCode == 60) {
            arg = (OCLExpression)args.get(0);
            Object argVal = arg.accept(this.getVisitor());
            if (sourceVal instanceof Number) {
                sourceVal = this.higherPrecisionNumber((Number)sourceVal);
            }
            if (argVal instanceof Number) {
                argVal = this.higherPrecisionNumber((Number)argVal);
            }
            return ObjectUtil.equal(sourceVal, argVal);
        }
        if (opCode == 61) {
            arg = (OCLExpression)args.get(0);
            Object argVal = arg.accept(this.getVisitor());
            if (sourceVal instanceof Number) {
                sourceVal = this.higherPrecisionNumber((Number)sourceVal);
            }
            if (argVal instanceof Number) {
                argVal = this.higherPrecisionNumber((Number)argVal);
            }
            return !ObjectUtil.equal(sourceVal, argVal);
        }
        if (sourceType instanceof PrimitiveType || sourceType instanceof CollectionType || this.getUMLReflection().isEnumeration(sourceType) || this.getUMLReflection().isDataType(sourceType) || sourceType instanceof VoidType || sourceType instanceof InvalidType) {
            if (numArgs == 0) {
                if (this.isUndefined(sourceVal) && opCode != 65 && opCode != 66) {
                    return this.getOclInvalid();
                }
                switch (opCode) {
                    case 2: {
                        if (sourceVal instanceof Integer) {
                            return -((Integer)sourceVal).intValue();
                        }
                        if (sourceVal instanceof Long) {
                            return -((Long)sourceVal).longValue();
                        }
                        return -((Double)sourceVal).doubleValue();
                    }
                    case 15: {
                        if (sourceVal instanceof Integer) {
                            int sourceInt = (Integer)sourceVal;
                            if (sourceType == this.getUnlimitedNatural() && sourceInt == -1) {
                                return this.getOclInvalid();
                            }
                            return Math.abs(sourceInt);
                        }
                        if (sourceVal instanceof Long) {
                            long sourceInt = (Long)sourceVal;
                            if (sourceType == this.getUnlimitedNatural() && sourceInt == -1L) {
                                return this.getOclInvalid();
                            }
                            return Math.abs(sourceInt);
                        }
                        return Math.abs((Double)sourceVal);
                    }
                    case 26: {
                        long sourceInt;
                        if (sourceVal instanceof Double) {
                            return (int)Math.floor((Double)sourceVal);
                        }
                        if (sourceType == this.getUnlimitedNatural() && (sourceInt = ((Long)this.higherPrecisionNumber((Number)sourceVal)).longValue()) == -1L) {
                            return this.getOclInvalid();
                        }
                        return sourceVal;
                    }
                    case 27: {
                        long sourceInt;
                        if (sourceVal instanceof Double) {
                            return (int)Math.round((Double)sourceVal);
                        }
                        if (sourceType == this.getUnlimitedNatural() && (sourceInt = ((Long)this.higherPrecisionNumber((Number)sourceVal)).longValue()) == -1L) {
                            return this.getOclInvalid();
                        }
                        return sourceVal;
                    }
                    case 11: {
                        return (Boolean)sourceVal != false ? Boolean.FALSE : Boolean.TRUE;
                    }
                    case 65: {
                        return this.isUndefined(sourceVal) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 66: {
                        return sourceVal == this.getOclInvalid() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 20: {
                        if (sourceType == this.getString()) {
                            return new Integer(((String)sourceVal).length());
                        }
                        if (sourceType instanceof CollectionType) {
                            return new Integer(((Collection)sourceVal).size());
                        }
                    }
                    case 23: {
                        return Integer.valueOf((String)sourceVal);
                    }
                    case 24: {
                        return Double.valueOf((String)sourceVal);
                    }
                    case 28: {
                        return UnicodeSupport.toLowerCase((String)sourceVal);
                    }
                    case 29: {
                        return UnicodeSupport.toUpperCase((String)sourceVal);
                    }
                    case 145: {
                        return ((Collection)sourceVal).isEmpty();
                    }
                    case 146: {
                        return !((Collection)sourceVal).isEmpty();
                    }
                    case 148: {
                        Number num = (Number)CollectionUtil.sum((Collection)sourceVal);
                        if (num == null) {
                            CollectionType numCollType = (CollectionType)sourceType;
                            Object numType = numCollType.getElementType();
                            if (numType == this.getReal()) {
                                num = new Double(0.0);
                            } else if (numType == this.getInteger()) {
                                num = new Integer(0);
                            }
                        }
                        return num;
                    }
                    case 154: {
                        return CollectionUtil.flatten((Collection)sourceVal);
                    }
                    case 152: {
                        return CollectionUtil.asSet((Collection)sourceVal);
                    }
                    case 149: {
                        return CollectionUtil.asBag((Collection)sourceVal);
                    }
                    case 150: {
                        return CollectionUtil.asOrderedSet((Collection)sourceVal);
                    }
                    case 151: {
                        return CollectionUtil.asSequence((Collection)sourceVal);
                    }
                    case 159: {
                        return CollectionUtil.first((Collection)sourceVal);
                    }
                    case 162: {
                        return CollectionUtil.last((Collection)sourceVal);
                    }
                }
            } else if (numArgs == 1) {
                String message;
                arg = (OCLExpression)args.get(0);
                Object argType = arg.getType();
                if (this.isUndefined(sourceVal)) {
                    switch (opCode) {
                        case 62: 
                        case 63: 
                        case 64: {
                            if (this.isLaxNullHandling()) break;
                            return this.getOclInvalid();
                        }
                        default: {
                            return this.getOclInvalid();
                        }
                    }
                }
                if (opCode == 64) {
                    return this.oclIsTypeOf(sourceVal, arg.accept(this.getVisitor()));
                }
                if (opCode == 63) {
                    return this.oclIsKindOf(sourceVal, arg.accept(this.getVisitor()));
                }
                if (opCode == 62) {
                    if (sourceVal == null || argType instanceof VoidType) {
                        return null;
                    }
                    if (sourceVal == this.getOclInvalid() || argType instanceof InvalidType) {
                        return this.getOclInvalid();
                    }
                    if (sourceVal instanceof Double && argType == this.getInteger()) {
                        return new Integer(((Double)sourceVal).intValue());
                    }
                    if (sourceVal instanceof Integer && argType == this.getReal()) {
                        int sourceInt;
                        if (sourceType == this.getUnlimitedNatural() && (sourceInt = ((Integer)sourceVal).intValue()) == -1) {
                            return Double.POSITIVE_INFINITY;
                        }
                        return new Double(((Integer)sourceVal).doubleValue());
                    }
                    return sourceVal;
                }
                Object argVal = null;
                if (!(sourceVal instanceof Boolean)) {
                    argVal = arg.accept(this.getVisitor());
                }
                if (sourceVal instanceof Number) {
                    sourceVal = this.higherPrecisionNumber((Number)sourceVal);
                    if (argVal instanceof Number) {
                        argVal = this.higherPrecisionNumber((Number)argVal);
                    }
                }
                if (sourceVal instanceof Long && argVal instanceof Long) {
                    boolean argUnlimited;
                    long sourceInt = (Long)sourceVal;
                    long argInt = (Long)argVal;
                    boolean sourceUnlimited = sourceType == this.getUnlimitedNatural() && sourceInt == -1L;
                    boolean bl = argUnlimited = argType == this.getUnlimitedNatural() && argInt == -1L;
                    if (sourceUnlimited && argUnlimited) {
                        switch (opCode) {
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                return Boolean.FALSE;
                            }
                        }
                        return this.getOclInvalid();
                    }
                    if (sourceUnlimited || argUnlimited) {
                        switch (opCode) {
                            case 67: 
                            case 69: {
                                return argUnlimited;
                            }
                            case 68: 
                            case 70: {
                                return sourceUnlimited;
                            }
                        }
                        return this.getOclInvalid();
                    }
                    switch (opCode) {
                        case 1: {
                            return this.coerceNumber(sourceInt + argInt);
                        }
                        case 2: {
                            return this.coerceNumber(sourceInt - argInt);
                        }
                        case 3: {
                            return this.coerceNumber(sourceInt * argInt);
                        }
                        case 4: {
                            double num = sourceInt;
                            double denom = argInt;
                            return denom == 0.0 ? this.getOclInvalid() : Double.valueOf(num / denom);
                        }
                        case 16: {
                            return argInt == 0L ? this.getOclInvalid() : this.coerceNumber(sourceInt / argInt);
                        }
                        case 17: {
                            return this.coerceNumber(sourceInt % argInt);
                        }
                        case 18: {
                            return this.coerceNumber(Math.max(sourceInt, argInt));
                        }
                        case 19: {
                            return this.coerceNumber(Math.min(sourceInt, argInt));
                        }
                        case 67: {
                            if (sourceInt < argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 68: {
                            if (sourceInt > argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 69: {
                            if (sourceInt <= argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 70: {
                            if (sourceInt >= argInt) {
                                return true;
                            }
                            return false;
                        }
                    }
                    String message2 = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message2);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Long && argVal instanceof Double) {
                    long sourceInt = (Long)sourceVal;
                    double argReal = (Double)argVal;
                    if (sourceType == this.getUnlimitedNatural() && sourceInt == -1L) {
                        switch (opCode) {
                            case 67: {
                                return Boolean.FALSE;
                            }
                            case 68: 
                            case 70: {
                                return Boolean.TRUE;
                            }
                        }
                        return this.getOclInvalid();
                    }
                    switch (opCode) {
                        case 1: {
                            return this.coerceNumber((double)sourceInt + argReal);
                        }
                        case 2: {
                            return this.coerceNumber((double)sourceInt - argReal);
                        }
                        case 3: {
                            return this.coerceNumber((double)sourceInt * argReal);
                        }
                        case 4: {
                            return argReal == 0.0 ? this.getOclInvalid() : Double.valueOf((double)sourceInt / argReal);
                        }
                        case 18: {
                            return this.coerceNumber(Math.max((double)sourceInt, argReal));
                        }
                        case 19: {
                            return this.coerceNumber(Math.min((double)sourceInt, argReal));
                        }
                        case 67: {
                            if ((double)sourceInt < argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 68: {
                            if ((double)sourceInt > argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 69: {
                            if ((double)sourceInt <= argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 70: {
                            if ((double)sourceInt >= argReal) {
                                return true;
                            }
                            return false;
                        }
                    }
                    String message3 = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message3);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Double && argVal instanceof Long) {
                    double sourceReal = (Double)sourceVal;
                    long argInt = (Long)argVal;
                    if (argType == this.getUnlimitedNatural() && argInt == -1L) {
                        switch (opCode) {
                            case 67: {
                                return Boolean.TRUE;
                            }
                            case 68: 
                            case 70: {
                                return Boolean.FALSE;
                            }
                        }
                        return this.getOclInvalid();
                    }
                    switch (opCode) {
                        case 1: {
                            return sourceReal + (double)argInt;
                        }
                        case 2: {
                            return sourceReal - (double)argInt;
                        }
                        case 3: {
                            return sourceReal * (double)argInt;
                        }
                        case 4: {
                            return argInt == 0L ? this.getOclInvalid() : Double.valueOf(sourceReal / (double)argInt);
                        }
                        case 18: {
                            return Math.max(sourceReal, (double)argInt);
                        }
                        case 19: {
                            return Math.min(sourceReal, (double)argInt);
                        }
                        case 67: {
                            if (sourceReal < (double)argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 68: {
                            if (sourceReal > (double)argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 69: {
                            if (sourceReal <= (double)argInt) {
                                return true;
                            }
                            return false;
                        }
                        case 70: {
                            if (sourceReal >= (double)argInt) {
                                return true;
                            }
                            return false;
                        }
                    }
                    String message4 = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message4);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Double && argVal instanceof Double) {
                    double sourceReal = (Double)sourceVal;
                    double argReal = (Double)argVal;
                    switch (opCode) {
                        case 1: {
                            return sourceReal + argReal;
                        }
                        case 2: {
                            return sourceReal - argReal;
                        }
                        case 3: {
                            return sourceReal * argReal;
                        }
                        case 4: {
                            return argReal == 0.0 ? this.getOclInvalid() : Double.valueOf(sourceReal / argReal);
                        }
                        case 18: {
                            return Math.max(sourceReal, argReal);
                        }
                        case 19: {
                            return Math.min(sourceReal, argReal);
                        }
                        case 67: {
                            if (sourceReal < argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 68: {
                            if (sourceReal > argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 69: {
                            if (sourceReal <= argReal) {
                                return true;
                            }
                            return false;
                        }
                        case 70: {
                            if (sourceReal >= argReal) {
                                return true;
                            }
                            return false;
                        }
                    }
                    String message5 = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message5);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Boolean) {
                    switch (opCode) {
                        case 12: {
                            if (Boolean.TRUE.equals(sourceVal)) {
                                return Boolean.TRUE;
                            }
                            argVal = arg.accept(this.getVisitor());
                            return argVal;
                        }
                        case 25: {
                            argVal = arg.accept(this.getVisitor());
                            if (sourceVal == null) {
                                return argVal;
                            }
                            return argVal == null ? sourceVal : ((Boolean)sourceVal ^ (Boolean)argVal ? Boolean.TRUE : Boolean.FALSE);
                        }
                        case 10: {
                            if (!Boolean.TRUE.equals(sourceVal)) {
                                return Boolean.FALSE;
                            }
                            argVal = arg.accept(this.getVisitor());
                            return argVal;
                        }
                        case 13: {
                            if (Boolean.FALSE.equals(sourceVal)) {
                                return Boolean.TRUE;
                            }
                            argVal = arg.accept(this.getVisitor());
                            return argVal;
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof String && argVal instanceof String) {
                    switch (opCode) {
                        case 21: {
                            return ((String)sourceVal).concat((String)argVal);
                        }
                        case 67: {
                            return ((String)sourceVal).compareTo((String)argVal) < 0;
                        }
                        case 69: {
                            return ((String)sourceVal).compareTo((String)argVal) <= 0;
                        }
                        case 68: {
                            return ((String)sourceVal).compareTo((String)argVal) > 0;
                        }
                        case 70: {
                            return ((String)sourceVal).compareTo((String)argVal) >= 0;
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, this.getName(oper));
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal instanceof Collection) {
                    Collection sourceColl = (Collection)sourceVal;
                    if (argVal == this.getOclInvalid()) {
                        return argVal;
                    }
                    switch (opCode) {
                        case 143: {
                            return CollectionUtil.includes(sourceColl, argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 141: {
                            return CollectionUtil.excludes(sourceColl, argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 140: {
                            return new Integer(CollectionUtil.count(sourceColl, argVal));
                        }
                        case 144: {
                            return CollectionUtil.includesAll(sourceColl, (Collection)argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 142: {
                            return CollectionUtil.excludesAll(sourceColl, (Collection)argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 147: {
                            CollectionType collType = (CollectionType)oc.getType();
                            return CollectionUtil.product(this.getEvaluationEnvironment(), this.getEnvironment(), sourceColl, (Collection)argVal, collType.getElementType());
                        }
                        case 157: {
                            Collection argColl = (Collection)argVal;
                            return CollectionUtil.union(sourceColl, argColl);
                        }
                        case 156: {
                            Collection argColl = (Collection)argVal;
                            return CollectionUtil.intersection(sourceColl, argColl);
                        }
                        case 2: {
                            return CollectionUtil.minus((Set)sourceColl, (Set)argVal);
                        }
                        case 155: {
                            return CollectionUtil.including(sourceColl, argVal);
                        }
                        case 153: {
                            return CollectionUtil.excluding(sourceColl, argVal);
                        }
                        case 167: {
                            return CollectionUtil.symmetricDifference((Set)sourceColl, (Set)argVal);
                        }
                        case 165: {
                            return CollectionUtil.append(sourceColl, argVal);
                        }
                        case 163: {
                            return CollectionUtil.prepend(sourceColl, argVal);
                        }
                        case 158: {
                            int indexVal = (Integer)argVal;
                            return CollectionUtil.at(sourceColl, indexVal);
                        }
                        case 160: {
                            return CollectionUtil.indexOf(sourceColl, argVal);
                        }
                    }
                } else if (sourceVal instanceof Comparable) {
                    Comparable comp;
                    if (opCode == 67) {
                        comp = (Comparable)sourceVal;
                        return comp.compareTo(argVal) < 0;
                    }
                    if (opCode == 69) {
                        comp = (Comparable)sourceVal;
                        return comp.compareTo(argVal) <= 0;
                    }
                    if (opCode == 68) {
                        comp = (Comparable)sourceVal;
                        return comp.compareTo(argVal) > 0;
                    }
                    if (opCode == 70) {
                        comp = (Comparable)sourceVal;
                        return comp.compareTo(argVal) >= 0;
                    }
                }
            } else {
                if (this.isUndefined(sourceVal)) {
                    return this.getOclInvalid();
                }
                Object arg1 = ((OCLExpression)args.get(0)).accept(this.getVisitor());
                if (this.isUndefined(arg1)) {
                    return this.getOclInvalid();
                }
                Object arg2 = ((OCLExpression)args.get(1)).accept(this.getVisitor());
                if (this.isUndefined(arg2)) {
                    return this.getOclInvalid();
                }
                if (sourceVal instanceof String) {
                    int lower = (Integer)arg1 - 1;
                    int upper = (Integer)arg2;
                    return ((String)sourceVal).substring(lower, upper);
                }
                if (sourceVal instanceof Collection) {
                    Collection sourceColl = (Collection)sourceVal;
                    if (opCode == 161) {
                        int index = (Integer)arg1;
                        return CollectionUtil.insertAt(sourceColl, index, arg2);
                    }
                    if (opCode == 166) {
                        int lower = (Integer)arg1;
                        int upper = (Integer)arg2;
                        return CollectionUtil.subOrderedSet(sourceColl, lower, upper);
                    }
                    if (opCode == 164) {
                        int lower = (Integer)arg1;
                        int upper = (Integer)arg2;
                        return CollectionUtil.subSequence(sourceColl, lower, upper);
                    }
                }
            }
        } else {
            Comparable evalArg;
            Comparable compContext;
            if (opCode == 40) {
                Object classifier = sourceVal;
                if (this.getUMLReflection().isEnumeration(classifier)) {
                    return new HashSet(this.getUMLReflection().getEnumerationLiterals(classifier));
                }
                if (sourceVal instanceof VoidType) {
                    HashSet<Object> result = new HashSet<Object>();
                    result.add(null);
                    return result;
                }
                if (this.getUMLReflection().isClass(classifier)) {
                    return this.getExtentMap().get(sourceVal);
                }
                return Collections.EMPTY_SET;
            }
            if (opCode == 65) {
                return this.isUndefined(sourceVal) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (opCode == 66) {
                return sourceVal == this.getOclInvalid() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.isUndefined(sourceVal)) {
                switch (opCode) {
                    case 62: 
                    case 63: 
                    case 64: {
                        if (this.isLaxNullHandling()) break;
                        return this.getOclInvalid();
                    }
                    default: {
                        return this.getOclInvalid();
                    }
                }
            }
            if (opCode == 64) {
                arg = (OCLExpression)args.get(0);
                return this.oclIsTypeOf(sourceVal, arg.accept(this.getVisitor()));
            }
            if (opCode == 63) {
                arg = (OCLExpression)args.get(0);
                return this.oclIsKindOf(sourceVal, arg.accept(this.getVisitor()));
            }
            if (opCode == 62) {
                arg = (OCLExpression)args.get(0);
                Object type = arg.accept(this.getVisitor());
                if (Boolean.TRUE.equals(this.oclIsKindOf(sourceVal, type))) {
                    return sourceVal;
                }
                return this.getOclInvalid();
            }
            if (opCode == 67 && sourceVal instanceof Comparable) {
                compContext = (Comparable)sourceVal;
                OCLExpression arg3 = (OCLExpression)args.get(0);
                evalArg = (Comparable)arg3.accept(this.getVisitor());
                return compContext.compareTo(evalArg) < 0;
            }
            if (opCode == 69 && sourceVal instanceof Comparable) {
                compContext = (Comparable)sourceVal;
                OCLExpression arg4 = (OCLExpression)args.get(0);
                evalArg = (Comparable)arg4.accept(this.getVisitor());
                return compContext.compareTo(evalArg) <= 0;
            }
            if (opCode == 68 && sourceVal instanceof Comparable) {
                compContext = (Comparable)sourceVal;
                OCLExpression arg5 = (OCLExpression)args.get(0);
                evalArg = (Comparable)arg5.accept(this.getVisitor());
                return compContext.compareTo(evalArg) > 0;
            }
            if (opCode == 70 && sourceVal instanceof Comparable) {
                compContext = (Comparable)sourceVal;
                OCLExpression arg6 = (OCLExpression)args.get(0);
                evalArg = (Comparable)arg6.accept(this.getVisitor());
                return compContext.compareTo(evalArg) >= 0;
            }
            return this.getOclInvalid();
        }
        return null;
    }

    private int inferOperationCode(O operation, int opcode) {
        int result = opcode;
        String opName = this.getName(operation);
        if ("<".equals(opName)) {
            result = 67;
        } else if (">".equals(opName)) {
            result = 68;
        } else if ("<=".equals(opName)) {
            result = 69;
        } else if (">=".equals(opName)) {
            result = 70;
        }
        return result;
    }

    @Override
    public Object visitIterateExp(IterateExp<C, PM> ie) {
        Variable<C, PM> vd = ie.getResult();
        String resultName = (String)vd.accept(this.getVisitor());
        try {
            EList iterators = ie.getIterator();
            Object sourceValue = ie.getSource().accept(this.getVisitor());
            if (this.isUndefined(sourceValue)) {
                Object object = this.getOclInvalid();
                return object;
            }
            Collection coll = (Collection)sourceValue;
            OCLExpression body = ie.getBody();
            IterationTemplate is = IterationTemplate.getInstance(this.getVisitor());
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    @Override
    public Object visitIteratorExp(IteratorExp<C, PM> ie) {
        Object sourceType = ie.getSource().getType();
        if (sourceType instanceof PredefinedType) {
            Object sourceValue = ie.getSource().accept(this.getVisitor());
            if (this.isUndefined(sourceValue)) {
                return this.getOclInvalid();
            }
            Collection sourceCollection = (Collection)sourceValue;
            switch (OCLStandardLibraryUtil.getOperationCode(ie.getName())) {
                case 201: {
                    return this.evaluateExistsIterator(ie, sourceCollection);
                }
                case 202: {
                    return this.evaluateForAllIterator(ie, sourceCollection);
                }
                case 209: {
                    return this.evaluateSelectIterator(ie, sourceCollection);
                }
                case 210: {
                    return this.evaluateRejectIterator(ie, sourceCollection);
                }
                case 206: {
                    return this.evaluateCollectIterator(ie, sourceCollection);
                }
                case 207: {
                    return this.evaluateCollectNestedIterator(ie, sourceCollection);
                }
                case 204: {
                    return this.evaluateOneIterator(ie, sourceCollection);
                }
                case 205: {
                    return this.evaluateAnyIterator(ie, sourceCollection);
                }
                case 211: {
                    return this.evaluateSortedByIterator(ie, sourceCollection);
                }
                case 203: {
                    return this.evaluateIsUnique(ie, sourceCollection);
                }
                case 208: {
                    return this.evaluateClosure(ie, sourceCollection);
                }
            }
        }
        String message = OCLMessages.bind(OCLMessages.IteratorNotImpl_ERROR_, ie.getName());
        UnsupportedOperationException ex = new UnsupportedOperationException(message);
        OCLPlugin.throwing(this.getClass(), "visitIteratorExp", ex);
        throw ex;
    }

    private static synchronized String generateName() {
        return "__result__" + tempCounter++;
    }

    private Object evaluateExistsIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateExists.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, Boolean.FALSE);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateForAllIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateForAll.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, Boolean.TRUE);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateCollectNestedIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType || collType instanceof BagType ? CollectionUtil.createNewBag() : CollectionUtil.createNewSequence();
        IterationTemplate is = IterationTemplateCollectNested.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateCollectIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType || collType instanceof BagType ? CollectionUtil.createNewBag() : CollectionUtil.createNewSequence();
        IterationTemplate is = IterationTemplateCollect.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateSelectIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType ? CollectionUtil.createNewSet() : (collType instanceof BagType ? CollectionUtil.createNewBag() : (collType instanceof SequenceType ? CollectionUtil.createNewSequence() : CollectionUtil.createNewOrderedSet()));
        IterationTemplate is = IterationTemplateSelect.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateRejectIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType ? CollectionUtil.createNewSet() : (collType instanceof BagType ? CollectionUtil.createNewBag() : (collType instanceof SequenceType ? CollectionUtil.createNewSequence() : CollectionUtil.createNewOrderedSet()));
        IterationTemplate is = IterationTemplateReject.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateOneIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateOne.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, Boolean.FALSE);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateAnyIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateAny.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, null);
        try {
            Object object = is.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    private Object evaluateSortedByIterator(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateSortedBy.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        final HashMap map = new HashMap();
        this.getEvaluationEnvironment().add(resultName, map);
        try {
            Object evaluationResult = is.evaluate(coll, iterators, body, resultName);
            if (evaluationResult == this.getOclInvalid()) {
                Object object = evaluationResult;
                return object;
            }
            is.evaluate(coll, iterators, body, resultName);
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
        ArrayList result = new ArrayList(coll);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Comparable b1 = (Comparable)map.get(o1);
                Comparable b2 = (Comparable)map.get(o2);
                return b1.compareTo(b2);
            }
        });
        Object collType = ie.getSource().getType();
        if (collType instanceof SetType || collType instanceof OrderedSetType) {
            return CollectionUtil.createNewOrderedSet(result);
        }
        return CollectionUtil.createNewSequence(result);
    }

    private Object evaluateIsUnique(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateIsUnique.getInstance(this.getVisitor());
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, new HashSet());
        try {
            is.evaluate(coll, iterators, body, resultName);
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
        return is.isDone() ? Boolean.FALSE : Boolean.TRUE;
    }

    private Object evaluateClosure(IteratorExp<C, PM> ie, Collection<?> coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        Set initResultVal = CollectionUtil.createNewSet();
        IterationTemplate template = IterationTemplateClosure.getInstance(this.getVisitor(), body);
        String resultName = EvaluationVisitorImpl.generateName();
        this.getEvaluationEnvironment().add(resultName, initResultVal);
        try {
            Object object = template.evaluate(coll, iterators, body, resultName);
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(resultName);
        }
    }

    @Override
    public Object visitEnumLiteralExp(EnumLiteralExp<C, EL> el) {
        return this.enumerations == null ? el.getReferredEnumLiteral() : this.enumerations.getValue(el.getReferredEnumLiteral());
    }

    @Override
    public Object visitVariableExp(VariableExp<C, PM> v) {
        Variable<C, PM> vd = v.getReferredVariable();
        String varName = vd.getName();
        return this.getEvaluationEnvironment().getValueOf(varName);
    }

    @Override
    public Object visitPropertyCallExp(PropertyCallExp<C, P> pc) {
        List qualifiers;
        P property = pc.getReferredProperty();
        OCLExpression source = pc.getSource();
        Object context = source.accept(this.getVisitor());
        if (this.isUndefined(context)) {
            return this.getOclInvalid();
        }
        OCLExpression derivation = this.getPropertyBody(property);
        if (derivation != null) {
            return this.navigate(property, derivation, context);
        }
        if (pc.getQualifier().isEmpty()) {
            qualifiers = Collections.emptyList();
        } else {
            qualifiers = new ArrayList();
            for (OCLExpression q : pc.getQualifier()) {
                qualifiers.add(q.accept(this.getVisitor()));
            }
        }
        Collection result = this.getEvaluationEnvironment().navigateProperty(property, qualifiers, context);
        if (pc.getType() instanceof CollectionType && !(result instanceof Collection)) {
            CollectionKind kind = ((CollectionType)pc.getType()).getKind();
            Collection collection = CollectionUtil.createNewCollection(kind);
            collection.add(result);
            result = collection;
        }
        return result;
    }

    @Override
    public Object visitAssociationClassCallExp(AssociationClassCallExp<C, P> ae) {
        Object context = ae.getSource().accept(this.getVisitor());
        if (this.isUndefined(context)) {
            return this.getOclInvalid();
        }
        return this.getEvaluationEnvironment().navigateAssociationClass(ae.getReferredAssociationClass(), ae.getNavigationSource(), context);
    }

    @Override
    public Object visitVariable(Variable<C, PM> vd) {
        String varName = vd.getName();
        OCLExpression<C> initExp = vd.getInitExpression();
        Object initVal = null;
        if (initExp != null) {
            initVal = initExp.accept(this.getVisitor());
        }
        this.getEvaluationEnvironment().add(varName, initVal);
        return varName;
    }

    @Override
    public Object visitIfExp(IfExp<C> ie) {
        OCLExpression<C> condition = ie.getCondition();
        Boolean condVal = (Boolean)condition.accept(this.getVisitor());
        if (condVal == null) {
            return null;
        }
        if (condVal.booleanValue()) {
            return ie.getThenExpression().accept(this.getVisitor());
        }
        return ie.getElseExpression().accept(this.getVisitor());
    }

    @Override
    public Object visitTypeExp(TypeExp<C> t) {
        return t.getReferredType();
    }

    @Override
    public Object visitStateExp(StateExp<C, S> s) {
        return s.getReferredState();
    }

    @Override
    public Object visitMessageExp(MessageExp<C, COA, SSA> m) {
        throw new UnsupportedOperationException("evaluation of MessageExp");
    }

    @Override
    public Object visitUnspecifiedValueExp(UnspecifiedValueExp<C> uv) {
        throw new UnsupportedOperationException("evaluation of UnspecifiedValueExp");
    }

    @Override
    public Object visitIntegerLiteralExp(IntegerLiteralExp<C> il) {
        return il.getIntegerSymbol();
    }

    @Override
    public Object visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<C> literalExp) {
        return literalExp.getIntegerSymbol();
    }

    @Override
    public Object visitRealLiteralExp(RealLiteralExp<C> rl) {
        return rl.getRealSymbol();
    }

    @Override
    public Object visitStringLiteralExp(StringLiteralExp<C> sl) {
        return sl.getStringSymbol();
    }

    @Override
    public Object visitBooleanLiteralExp(BooleanLiteralExp<C> bl) {
        return bl.getBooleanSymbol();
    }

    @Override
    public Object visitInvalidLiteralExp(InvalidLiteralExp<C> il) {
        return this.getOclInvalid();
    }

    @Override
    public Object visitNullLiteralExp(NullLiteralExp<C> il) {
        return null;
    }

    @Override
    public Object visitLetExp(LetExp<C, PM> l) {
        Variable<C, PM> vd = l.getVariable();
        String name = (String)vd.accept(this.getVisitor());
        try {
            OCLExpression<C> inExp = l.getIn();
            Object object = inExp.accept(this.getVisitor());
            return object;
        }
        finally {
            this.getEvaluationEnvironment().remove(name);
        }
    }

    @Override
    public Object visitCollectionLiteralExp(CollectionLiteralExp<C> cl) {
        CollectionKind kind = cl.getKind();
        EList<CollectionLiteralPart<C>> parts = cl.getPart();
        Collection<Object> result = CollectionUtil.createNewCollection(kind);
        if (kind == CollectionKind.SEQUENCE_LITERAL && cl.isSimpleRange()) {
            int lastInt;
            CollectionRange collRange = (CollectionRange)parts.get(0);
            OCLExpression first = collRange.getFirst();
            OCLExpression last = collRange.getLast();
            Integer firstVal = (Integer)first.accept(this.getVisitor());
            if (firstVal == null) {
                result.add(null);
                return result;
            }
            Integer lastVal = (Integer)last.accept(this.getVisitor());
            if (lastVal == null) {
                result.add(null);
                return result;
            }
            int firstInt = firstVal;
            if (firstInt > (lastInt = lastVal.intValue())) {
                return result;
            }
            return new IntegerRangeList(firstInt, lastInt);
        }
        for (CollectionLiteralPart part : parts) {
            if (part instanceof CollectionItem) {
                CollectionItem item = (CollectionItem)part;
                OCLExpression itemExp = item.getItem();
                Object itemVal = itemExp.accept(this.getVisitor());
                if (itemVal == null) continue;
                result.add(itemVal);
                continue;
            }
            CollectionRange range = (CollectionRange)part;
            OCLExpression first = range.getFirst();
            OCLExpression last = range.getLast();
            Integer firstVal = (Integer)first.accept(this.getVisitor());
            Integer lastVal = (Integer)last.accept(this.getVisitor());
            if (firstVal == null || lastVal == null) continue;
            int firstInt = firstVal;
            int lastInt = lastVal;
            int i = firstInt;
            while (i <= lastInt) {
                result.add(new Integer(i));
                ++i;
            }
        }
        return result;
    }

    @Override
    public Object visitTupleLiteralExp(TupleLiteralExp<C, P> tl) {
        Object type = tl.getType();
        EList<TupleLiteralPart<C, P>> tp = tl.getPart();
        HashMap propertyValues = new HashMap();
        for (TupleLiteralPart part : tp) {
            propertyValues.put(part.getAttribute(), part.accept(this.getVisitor()));
        }
        return this.getEvaluationEnvironment().createTuple(type, propertyValues);
    }

    @Override
    public Object visitTupleLiteralPart(TupleLiteralPart<C, P> tp) {
        return tp.getValue().accept(this.getVisitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntegerRangeList
    extends AbstractList<Integer> {
        private int first;
        private int last;

        public IntegerRangeList(int first, int last) {
            this.first = first;
            this.last = last;
        }

        @Override
        public int size() {
            return this.last - this.first + 1;
        }

        @Override
        public Integer get(int index) {
            if (index < 0 || index >= this.size()) {
                String message = OCLMessages.bind(OCLMessages.IndexOutOfRange_ERROR_, new Object[]{Integer.toString(index), Integer.toString(this.first), Integer.toString(this.last)});
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "get", error);
                throw error;
            }
            return new Integer(this.first + index);
        }

        @Override
        public Iterator<Integer> iterator() {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class IntegerRangeIterator
            implements Iterator<Integer> {
                private int curr;
                private boolean initialized;

                public IntegerRangeIterator() {
                    this.curr = IntegerRangeList.this.first;
                    this.initialized = false;
                }

                @Override
                public Integer next() {
                    if (!this.initialized) {
                        this.curr = IntegerRangeList.this.first - 1;
                        this.initialized = true;
                    }
                    if (this.hasNext()) {
                        return new Integer(++this.curr);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasNext() {
                    return this.curr < IntegerRangeList.this.last;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new IntegerRangeIterator();
        }
    }
}

