/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: CTNode.java,v 1.1 2007/03/18 09:07:00 lzhang Exp $
 */

package org.eclipse.eodm.owl.reasoner.structural;

import java.util.HashSet;
import java.util.Set;


/**
 * 
 * Node 
 *   Data structure for classification tree.  
 *   
 */

public class CTNode {

	public CTNode(TBox tbox) {
		this.tbox = tbox;
		tbox.addNode(this);
	}
	
	public CTNode(TBox tbox, int cID) {
		this(tbox);
		addConceptID(cID);
	}
	
	
	public boolean addConceptID(int cID){
        Integer id = new Integer(cID);
        if (!cIDSet.contains(id)) {
            cIDSet.add(id);
            if (tbox.cid2NodeMap.put(id, this) != null) {
                System.err
                        .println("Warning: Same class exporession in multiple nodes.");
            }
            return true;
        }
        
        return false;

	}
	
    public CTNode getAlternativeNode() {
        if (alternativeNode != null) {
            alternativeNode = alternativeNode.getAlternativeNode();
            return alternativeNode;
        } else {
            return this;
        }
    }
    
    public Set getCIDSet() {
        return cIDSet;
    }
    
    CTNode alternativeNode = null;
    
    HashSet cIDSet = new HashSet(8);

    HashSet containmentLinks = new HashSet(8);

    HashSet containmentByLinks = new HashSet(8);

    HashSet conjunctionLinks = new HashSet(8);

    HashSet disjunctionLinks = new HashSet(8);

    HashSet allValuesFromByLinks = new HashSet(8);

    HashSet someValuesFromByLinks = new HashSet(8);

    int topologicalPosition;
	
	TBox tbox;
}
