/**
 * 
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 * 
 * $Id: InvalidLexicalFormException.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */

package org.eclipse.eodm.exceptions;

/**
 * InvalidLexicalFormException occurs if a lexical form does not conforms
 * to the data type of a typed literal.
 * 
 * @see org.eclipse.eodm.RDF.RDFS.RDFBase.TypedLiteral
 * 
 */
public class InvalidLexicalFormException extends Exception {
    
    static final long serialVersionUID = -3176405882013118838L;
    
    /**
     * @inheritDoc
     */
    public InvalidLexicalFormException() {
        super();
    }

    /**
     * @inheritDoc
     */
    public InvalidLexicalFormException(String message) {
        super(message);
    }

    /**
     * @inheritDoc
     */
    public InvalidLexicalFormException(Throwable cause) {
        super(cause);
    }

    /**
     * @inheritDoc 
     */
    public InvalidLexicalFormException(String message, Throwable cause) {
        super(message, cause);
    }

}
