/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFWebPackageImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfweb.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;


import org.eclipse.eodm.impl.EODMImplPackage;
import org.eclipse.eodm.impl.EODMImplPackageImpl;
import org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.rdfweb.LocalName;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebFactory;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;








/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class RDFWebPackageImpl extends EPackageImpl implements RDFWebPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass documentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass localNameEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass namespaceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass namespaceDefinitionEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private RDFWebPackageImpl() {
		super(eNS_URI, RDFWebFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static RDFWebPackage init() {
		if (isInited) return (RDFWebPackage)EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI);

		// Obtain or create and register package
		RDFWebPackageImpl therdfwebPackage = (RDFWebPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof RDFWebPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new RDFWebPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		EODMImplPackageImpl theeodm2Package = (EODMImplPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(EODMImplPackage.eNS_URI) instanceof EODMImplPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(EODMImplPackage.eNS_URI) : EODMImplPackage.eINSTANCE);
		RDFBasePackageImpl therdfbasePackage = (RDFBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI) instanceof RDFBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI) : RDFBasePackage.eINSTANCE);
		RDFSPackageImpl therdfsPackage = (RDFSPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI) instanceof RDFSPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI) : RDFSPackage.eINSTANCE);
		OWLBasePackageImpl theowlbasePackage = (OWLBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI) instanceof OWLBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI) : OWLBasePackage.eINSTANCE);

		// Create package meta-data objects
		therdfwebPackage.createPackageContents();
		theeodm2Package.createPackageContents();
		therdfbasePackage.createPackageContents();
		therdfsPackage.createPackageContents();
		theowlbasePackage.createPackageContents();

		// Initialize created meta-data
		therdfwebPackage.initializePackageContents();
		theeodm2Package.initializePackageContents();
		therdfbasePackage.initializePackageContents();
		therdfsPackage.initializePackageContents();
		theowlbasePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		therdfwebPackage.freeze();

		return therdfwebPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDocument() {
		return documentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocument_Statement() {
		return (EReference)documentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocument_LocalName() {
		return (EReference)documentEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocument_XmlBase() {
		return (EReference)documentEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocument_NamespaceDefinition() {
		return (EReference)documentEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLocalName() {
		return localNameEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLocalName_Name() {
		return (EAttribute)localNameEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLocalName_UriRef() {
		return (EReference)localNameEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNamespace() {
		return namespaceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNamespace_NamespaceURIRef() {
		return (EReference)namespaceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNamespaceDefinition() {
		return namespaceDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNamespaceDefinition_NamespacePrefix() {
		return (EAttribute)namespaceDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNamespaceDefinition_Namespace() {
		return (EReference)namespaceDefinitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFWebFactory getrdfwebFactory() {
		return (RDFWebFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		documentEClass = createEClass(DOCUMENT);
		createEReference(documentEClass, DOCUMENT__STATEMENT);
		createEReference(documentEClass, DOCUMENT__LOCAL_NAME);
		createEReference(documentEClass, DOCUMENT__XML_BASE);
		createEReference(documentEClass, DOCUMENT__NAMESPACE_DEFINITION);

		localNameEClass = createEClass(LOCAL_NAME);
		createEAttribute(localNameEClass, LOCAL_NAME__NAME);
		createEReference(localNameEClass, LOCAL_NAME__URI_REF);

		namespaceEClass = createEClass(NAMESPACE);
		createEReference(namespaceEClass, NAMESPACE__NAMESPACE_URI_REF);

		namespaceDefinitionEClass = createEClass(NAMESPACE_DEFINITION);
		createEAttribute(namespaceDefinitionEClass, NAMESPACE_DEFINITION__NAMESPACE_PREFIX);
		createEReference(namespaceDefinitionEClass, NAMESPACE_DEFINITION__NAMESPACE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		RDFBasePackageImpl therdfbasePackage = (RDFBasePackageImpl)EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI);

		// Add supertypes to classes
		documentEClass.getESuperTypes().add(therdfbasePackage.getRDFSResource());

		// Initialize classes and features; add operations and parameters
		initEClass(documentEClass, Document.class, "Document", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDocument_Statement(), therdfbasePackage.getRDFStatement(), therdfbasePackage.getRDFStatement_Document(), "statement", null, 0, -1, Document.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocument_LocalName(), this.getLocalName(), null, "localName", null, 0, -1, Document.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocument_XmlBase(), this.getNamespace(), null, "xmlBase", null, 0, -1, Document.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocument_NamespaceDefinition(), this.getNamespaceDefinition(), null, "namespaceDefinition", null, 0, -1, Document.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(localNameEClass, LocalName.class, "LocalName", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLocalName_Name(), ecorePackage.getEString(), "name", "", 1, 1, LocalName.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getLocalName_UriRef(), therdfbasePackage.getURIReference(), therdfbasePackage.getURIReference_FragmentIdentifier(), "uriRef", null, 0, -1, LocalName.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(namespaceEClass, Namespace.class, "Namespace", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getNamespace_NamespaceURIRef(), therdfbasePackage.getURIReference(), null, "namespaceURIRef", null, 1, 1, Namespace.class, !IS_TRANSIENT, !IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(namespaceDefinitionEClass, NamespaceDefinition.class, "NamespaceDefinition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getNamespaceDefinition_NamespacePrefix(), ecorePackage.getEString(), "namespacePrefix", "", 1, 1, NamespaceDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNamespaceDefinition_Namespace(), this.getNamespace(), null, "namespace", null, 1, 1, NamespaceDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create annotations
		// keywords
		createKeywordsAnnotations();
	}

	/**
	 * Initializes the annotations for <b>keywords</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createKeywordsAnnotations() {
		String source = "keywords";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "metamodel", null
		   });
	}

} //RDFWebPackageImpl
