/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCLFactoryWithHistory
implements OCLFactory {
    private final OCLFactory delegate;
    private List<Object> history = new ArrayList<Object>();
    private Set<TypedElement<?>> errorNodes = new HashSet();
    private boolean disposable;

    OCLFactoryWithHistory(OCLFactory delegate) {
        this.delegate = delegate;
    }

    public void clear() {
        if (this.isDisposable()) {
            for (Object next : this.history) {
                ObjectUtil.dispose(next);
            }
        }
        this.history.clear();
        this.errorNodes.clear();
    }

    boolean isDisposable() {
        return this.disposable;
    }

    void setDisposable() {
        this.disposable = true;
    }

    <T> T record(T object) {
        this.history.add(object);
        return object;
    }

    void markAsErrorNode(TypedElement<?> expr) {
        this.errorNodes.add(expr);
    }

    boolean isErrorNode(TypedElement<?> expr) {
        return this.errorNodes.contains(expr);
    }

    @Override
    public <C, P> AssociationClassCallExp<C, P> createAssociationClassCallExp() {
        return this.record(this.delegate.createAssociationClassCallExp());
    }

    @Override
    public <C, O> BagType<C, O> createBagType(C elementType) {
        return this.record(this.delegate.createBagType(elementType));
    }

    @Override
    public <C> BooleanLiteralExp<C> createBooleanLiteralExp() {
        return this.record(this.delegate.createBooleanLiteralExp());
    }

    @Override
    public <C> CollectionItem<C> createCollectionItem() {
        return this.record(this.delegate.createCollectionItem());
    }

    @Override
    public <C> CollectionLiteralExp<C> createCollectionLiteralExp() {
        return this.record(this.delegate.createCollectionLiteralExp());
    }

    @Override
    public <C> CollectionRange<C> createCollectionRange() {
        return this.record(this.delegate.createCollectionRange());
    }

    @Override
    public <C, O> CollectionType<C, O> createCollectionType(C elementType) {
        return this.record(this.delegate.createCollectionType(elementType));
    }

    @Override
    public <C, O> CollectionType<C, O> createCollectionType(CollectionKind kind, C elementType) {
        return this.record(this.delegate.createCollectionType(kind, elementType));
    }

    @Override
    public <C, EL> EnumLiteralExp<C, EL> createEnumLiteralExp() {
        return this.record(this.delegate.createEnumLiteralExp());
    }

    @Override
    public <C> IfExp<C> createIfExp() {
        return this.record(this.delegate.createIfExp());
    }

    @Override
    public <C> IntegerLiteralExp<C> createIntegerLiteralExp() {
        return this.record(this.delegate.createIntegerLiteralExp());
    }

    @Override
    public <C> InvalidLiteralExp<C> createInvalidLiteralExp() {
        return this.record(this.delegate.createInvalidLiteralExp());
    }

    @Override
    public <C, PM> IterateExp<C, PM> createIterateExp() {
        return this.record(this.delegate.createIterateExp());
    }

    @Override
    public <C, PM> IteratorExp<C, PM> createIteratorExp() {
        return this.record(this.delegate.createIteratorExp());
    }

    @Override
    public <C, PM> LetExp<C, PM> createLetExp() {
        return this.record(this.delegate.createLetExp());
    }

    @Override
    public <C, COA, SSA> MessageExp<C, COA, SSA> createMessageExp() {
        return this.record(this.delegate.createMessageExp());
    }

    @Override
    public <C> NullLiteralExp<C> createNullLiteralExp() {
        return this.record(this.delegate.createNullLiteralExp());
    }

    @Override
    public <C, O> OperationCallExp<C, O> createOperationCallExp() {
        return this.record(this.delegate.createOperationCallExp());
    }

    @Override
    public <C, O, P> MessageType<C, O, P> createOperationMessageType(O operation) {
        return this.record(this.delegate.createOperationMessageType(operation));
    }

    @Override
    public <C, O> OrderedSetType<C, O> createOrderedSetType(C elementType) {
        return this.record(this.delegate.createOrderedSetType(elementType));
    }

    @Override
    public <C, P> PropertyCallExp<C, P> createPropertyCallExp() {
        return this.record(this.delegate.createPropertyCallExp());
    }

    @Override
    public <C> RealLiteralExp<C> createRealLiteralExp() {
        return this.record(this.delegate.createRealLiteralExp());
    }

    @Override
    public <C, O> SequenceType<C, O> createSequenceType(C elementType) {
        return this.record(this.delegate.createSequenceType(elementType));
    }

    @Override
    public <C, O> SetType<C, O> createSetType(C elementType) {
        return this.record(this.delegate.createSetType(elementType));
    }

    @Override
    public <C, O, P> MessageType<C, O, P> createSignalMessageType(C signal) {
        return this.record(this.delegate.createSignalMessageType(signal));
    }

    @Override
    public <C, S> StateExp<C, S> createStateExp() {
        return this.record(this.delegate.createStateExp());
    }

    @Override
    public <C> StringLiteralExp<C> createStringLiteralExp() {
        return this.record(this.delegate.createStringLiteralExp());
    }

    @Override
    public <C, P> TupleLiteralExp<C, P> createTupleLiteralExp() {
        return this.record(this.delegate.createTupleLiteralExp());
    }

    @Override
    public <C, P> TupleLiteralPart<C, P> createTupleLiteralPart() {
        return this.record(this.delegate.createTupleLiteralPart());
    }

    @Override
    public <C, O, P> TupleType<O, P> createTupleType(List<? extends TypedElement<C>> parts) {
        return this.record(this.delegate.createTupleType(parts));
    }

    @Override
    public <C> TypeExp<C> createTypeExp() {
        return this.record(this.delegate.createTypeExp());
    }

    @Override
    public <C, O> TypeType<C, O> createTypeType(C type) {
        return this.record(this.delegate.createTypeType(type));
    }

    @Override
    public <C> UnlimitedNaturalLiteralExp<C> createUnlimitedNaturalLiteralExp() {
        return this.record(this.delegate.createUnlimitedNaturalLiteralExp());
    }

    @Override
    public <C> UnspecifiedValueExp<C> createUnspecifiedValueExp() {
        return this.record(this.delegate.createUnspecifiedValueExp());
    }

    @Override
    public <C, PM> Variable<C, PM> createVariable() {
        return this.record(this.delegate.createVariable());
    }

    @Override
    public <C, PM> VariableExp<C, PM> createVariableExp() {
        return this.record(this.delegate.createVariableExp());
    }
}

