/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource.parser.element;

import java.util.Random;
import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;

public class RDFBlankNode
implements RDFResourceElement {
    private String id;
    private static String prefix;
    private static int index;

    static {
        long randomResult = new Random().nextLong();
        prefix = "_" + Long.toHexString(randomResult) + "-";
        index = 0;
    }

    public RDFBlankNode() {
        this.id = this.nextID();
    }

    public RDFBlankNode(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id must NOT be null");
        }
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    private String nextID() {
        return String.valueOf(prefix) + ++index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RDFBlankNode)) {
            return false;
        }
        RDFBlankNode blankNode = (RDFBlankNode)o;
        return this.id.equals(blankNode.getID());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "BlankNode{id='" + this.id + "'" + "}";
    }

    public String getNamespace() {
        return "http://bnode.ibm.com#";
    }

    public String getLocalName() {
        return this.id;
    }

    public String getFullURI() {
        return String.valueOf(this.getNamespace()) + this.id;
    }
}

