/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: AllValueFromLink.java,v 1.1 2007/03/18 09:07:00 lzhang Exp $
 */

package org.eclipse.eodm.owl.reasoner.structural;

public class AllValueFromLink extends NodeLink {

    public AllValueFromLink(TBox tbox) {
        super(tbox);
    }

    public AllValueFromLink(TBox tbox, CTNode source, CTNode target, int propertyID) {
        super(tbox, source, target);
        this.propertyID = propertyID;
    }

    public void setSource(CTNode source) {
        this.source = source;
    }

    public void setTarget(CTNode target) {
        if (this.target != target) {
            if (this.target != null) {
                this.target.allValuesFromByLinks.remove(this);
            }
            this.target = target;
            if (target != null) {
                target.allValuesFromByLinks.add(this);
            }
        }
    }

    public int getPropertyID() {
        return propertyID;
    }

    public void setPropertyID(int propertyID) {
        this.propertyID = propertyID;
    }

    int propertyID;

}
