/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: TermFactory.java,v 1.1 2007/03/18 09:07:03 lzhang Exp $
 */

package org.eclipse.eodm.owl.reasoner.structural;

import java.util.List;


public class TermFactory {
    
    /**
     * 
     * @return instance of TermFactory
     */
    public static TermFactory instance() {
        return instance;
    }
    
    private static TermFactory instance = new TermFactory();
    
    public Role createRole(String id){
    	return new Role(id);
    }
    
    public ObjectProp createObjectProp(String id) {
        return new ObjectProp(id);
    }
   
    public Individual createIndividual(String id) {
        return new Individual(id);
    }
    
    public Literal createLiteral(String lexicalForm) {
    	return new Literal(lexicalForm);
    }
    
    
    public PrimitiveConcept createPrim(String id) {
        return new PrimitiveConcept(id);
    }
    
    public Negation createNegation(Concept c) {
        Negation term = new Negation(c);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }
        return term;
    }
    
    public Intersection createIntersect() {
        Intersection term = new Intersection(null);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }        
        return term;
    }
    
    public Intersection createIntersect(List clist) {
        Intersection term = new Intersection(clist);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }        
        return term;
    }
    
    public Intersection createIntersect(Concept c1, Concept c2) {
        Intersection term = new Intersection(c1,c2);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }        
        return term;
    }
    
    public Union createUnion() {
        Union term = new Union(null);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }        
        return term;
    }
    
    public Union createUnion(List clist) {
        Union term = new Union(clist);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }        
        return term; 
    }
    
    public Union createUnion(Concept c1, Concept c2) {
        Union term =  new Union(c1,c2);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }       
        return term;
    }
    
    public SomeValueFrom createSome(Role p, Concept c) {
        SomeValueFrom term = new SomeValueFrom(p, c);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }
        return term;
    }
    
    public AllValueFrom createAll(Role p, Concept c) {
        AllValueFrom term = new AllValueFrom(p,c);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }
        return term;
    }
    
    public HasValue createHasValue(Role p, Resource r) {
        HasValue term = new HasValue(p,r);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }
        return term;
    }
    
    public Cardinality createCardinality(Role p, int val, Concept c) {
        Cardinality term = new Cardinality(p,val,c);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }
        return term;
    }
    
    public MaxCardinality createMaxCardinality(Role p, int val, Concept c) {
        MaxCardinality term = new MaxCardinality(p, val, c);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }
        return term;
    }
    
    public MinCardinality createMinCardinality(Role p, int val, Concept c) {
        MinCardinality term = new MinCardinality(p,val,c);
        if(ReasonerUtil.DEBUG) {
            term.setName(ReasonerUtil.toString(term));
        }
        return term;
    }  


}
