/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: URIReference.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.eodm.rdf.rdfweb.LocalName;
import org.eclipse.eodm.rdf.rdfweb.Namespace;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>URI Reference</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getFragmentIdentifier <em>fragmentIdentifier</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getNamespace <em>namespace</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getResource <em>resource</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getReifiedStatement <em>reifiedStatement</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getUri <em>uri</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getURIReference()
 * @model
 * @generated
 */
public interface URIReference extends EObject {
	/**
	 * Returns the value of the '<em><b>fragmentIdentifier</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfweb.LocalName#getUriRef <em>uriRef</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Fragment Identifier</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>fragmentIdentifier</em>' reference.
	 * @see #setFragmentIdentifier(LocalName)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getURIReference_FragmentIdentifier()
	 * @see org.eclipse.eodm.rdf.rdfweb.LocalName#getUriRef
	 * @model opposite="uriRef"
	 * @generated
	 */
	LocalName getFragmentIdentifier();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getFragmentIdentifier <em>fragmentIdentifier</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>fragmentIdentifier</em>' reference.
	 * @see #getFragmentIdentifier()
	 * @generated
	 */
	void setFragmentIdentifier(LocalName value);

	/**
	 * Returns the value of the '<em><b>namespace</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfweb.Namespace#getNamespaceURIRef <em>namespaceURIRef</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Namespace</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>namespace</em>' reference.
	 * @see #setNamespace(Namespace)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getURIReference_Namespace()
	 * @see org.eclipse.eodm.rdf.rdfweb.Namespace#getNamespaceURIRef
	 * @model opposite="namespaceURIRef"
	 * @generated
	 */
	Namespace getNamespace();

	/**
	 * Returns the value of the '<em><b>resource</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getUriRef <em>uriRef</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Resource</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>resource</em>' container reference.
	 * @see #setResource(RDFSResource)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getURIReference_Resource()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getUriRef
	 * @model opposite="uriRef"
	 * @generated
	 */
	RDFSResource getResource();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getResource <em>resource</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>resource</em>' container reference.
	 * @see #getResource()
	 * @generated
	 */
	void setResource(RDFSResource value);

	/**
	 * Returns the value of the '<em><b>reifiedStatement</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFStatement}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getNameForReification <em>nameForReification</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reified Statement</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>reifiedStatement</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getURIReference_ReifiedStatement()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#getNameForReification
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFStatement" opposite="nameForReification"
	 * @generated
	 */
	EList getReifiedStatement();

	/**
	 * Returns the value of the '<em><b>uri</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Uri</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>uri</em>' reference.
	 * @see #setUri(UniformResourceIdentifier)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getURIReference_Uri()
	 * @model
	 * @generated
	 */
	UniformResourceIdentifier getUri();
	
	/**
	 * This is a convenient method to get the fully qualified URL string representation of this URIReference.
	 * @return the fully qualified URL string representation of this URIReference
	 */
	String getURIString();

} // URIReference
