/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.codegen;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.codegen.gmfgen.Attributes;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenCustomPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.util.CodegenEmitters;
import org.eclipse.gmf.codegen.util.Generator;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.common.codegen.TextMerger;
import org.eclipse.uml2.diagram.codegen.CodegenEmittersExt;
import org.eclipse.uml2.diagram.codegen.u2tgen.SubstitutableByAttributes;
import org.eclipse.uml2.uml.UMLPackage;

public class GeneratorExt
extends Generator {
    private final GenDiagram myDiagram;
    private final CodegenEmittersExt myEmitters;

    public GeneratorExt(GenEditorGenerator genModel, CodegenEmittersExt emitters) {
        super(genModel, (CodegenEmitters)emitters);
        this.myDiagram = genModel.getDiagram();
        this.myEmitters = emitters;
    }

    protected TextMerger createMergeService() {
        final TextMerger defaultMerger = super.createMergeService();
        return new TextMerger(){

            public String process(String fileNameExt, String oldText, String newText) {
                if ("properties".equals(fileNameExt) && newText != null && newText.contains("#seeBugzilla=181484")) {
                    return newText;
                }
                return defaultMerger.process(fileNameExt, oldText, newText);
            }

            public String mergeJava(String oldText, String newText) {
                return defaultMerger.mergeJava(oldText, newText);
            }

            public String mergeProperties(String oldText, String newText) {
                return defaultMerger.mergeProperties(oldText, newText);
            }

            public String mergeXML(String oldText, String newText) {
                return defaultMerger.mergeXML(oldText, newText);
            }
        };
    }

    protected void customRun() throws InterruptedException, UnexpectedBehaviourException {
        super.customRun();
        for (GenTopLevelNode node : this.myDiagram.getTopLevelNodes()) {
            this.generateChangeNotationAction(node);
        }
        this.generateIconStylePreferencesPage(this.myDiagram);
        this.generateIconStylePreferencesHelper(this.myDiagram);
        this.generateViewFiltersPreferencesPage(this.myDiagram);
        this.generateSwitchBetweenCommentAndNodeActions();
        this.generatePaletteProvider(this.myDiagram);
    }

    private void generateSwitchBetweenCommentAndNodeActions() throws InterruptedException, UnexpectedBehaviourException {
        GenTopLevelNode commentNode = null;
        for (GenTopLevelNode nextNode : this.myDiagram.getTopLevelNodes()) {
            EClass metaclass;
            TypeModelFacet modelFacet = nextNode.getModelFacet();
            if (modelFacet == null || modelFacet.getMetaClass() == null || !GeneratorExt.isTheSameEClass(metaclass = modelFacet.getMetaClass().getEcoreClass(), UMLPackage.eINSTANCE.getComment())) continue;
            commentNode = nextNode;
            break;
        }
        if (commentNode == null) {
            return;
        }
        GenLink commentLink = null;
        for (GenLink nextLink : commentNode.getGenOutgoingLinks()) {
            FeatureLinkModelFacet facet;
            if (!(nextLink.getModelFacet() instanceof FeatureLinkModelFacet) || (facet = (FeatureLinkModelFacet)nextLink.getModelFacet()).getMetaFeature() == null || !GeneratorExt.isTheSameEFeature(facet.getMetaFeature().getEcoreFeature(), (EStructuralFeature)UMLPackage.eINSTANCE.getComment_AnnotatedElement())) continue;
            commentLink = nextLink;
            break;
        }
        if (commentLink == null) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getTurnCommentIntoNoteEmitter(), this.myEmitters.getTurnCommentIntoNoteActionFQN(this.myDiagram), new Object[]{this.myDiagram, commentNode, commentLink});
        this.doGenerateJavaClass(this.myEmitters.getTurnNoteIntoCommentEmitter(), this.myEmitters.getTurnNoteIntoCommentActionFQN(this.myDiagram), new Object[]{this.myDiagram, commentNode, commentLink});
    }

    private void generateChangeNotationAction(GenTopLevelNode node) throws InterruptedException, UnexpectedBehaviourException {
        for (Attributes attr : node.getViewmap().getAttributes()) {
            if (!(attr instanceof SubstitutableByAttributes)) continue;
            SubstitutableByAttributes sba = (SubstitutableByAttributes)attr;
            if (sba.isRequiresAll()) {
                return;
            }
            this.doGenerateJavaClass(this.myEmitters.getChangeNotationContributionItemProviderEmitter(), this.myEmitters.getChangeNotationContributionItemProviderName(node), new Object[]{node});
            for (Object substitutableByNode : sba.getSubstitutableByNodes()) {
                this.doGenerateJavaClass(this.myEmitters.getChangeNotationActionEmitter(), this.myEmitters.getChangeNotationActionName(node, substitutableByNode), new Object[]{node, substitutableByNode});
            }
            return;
        }
    }

    private void generateIconStylePreferencesPage(GenDiagram diagram) throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateJavaClass(this.myEmitters.getIconStylePreferencePageEmitter(), this.myEmitters.getIconStylePreferencePageFQN(diagram), new Object[]{diagram});
    }

    private void generateIconStylePreferencesHelper(GenDiagram diagram) throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateJavaClass(this.myEmitters.getIconStylePreferenceHelperEmitter(), this.myEmitters.getIconStylePreferenceHelperFQN(diagram), new Object[]{diagram});
    }

    private void generateViewFiltersPreferencesPage(GenDiagram diagram) throws InterruptedException, UnexpectedBehaviourException {
        for (GenPreferencePage page : diagram.getPreferencePages()) {
            this.generateViewFiltersPreferencesPage(page);
        }
    }

    private void generateViewFiltersPreferencesPage(GenPreferencePage page) throws InterruptedException, UnexpectedBehaviourException {
        if (page instanceof GenCustomPreferencePage && this.myEmitters.isViewFiltersPreferencePage(page)) {
            this.doGenerateJavaClass(this.myEmitters.getViewFiltersPreferencePageEmitter(), this.myEmitters.getViewFiltersPreferencePageFQN(page), new Object[]{page});
        }
        for (GenPreferencePage child : page.getChildren()) {
            this.generateViewFiltersPreferencesPage(child);
        }
    }

    private static boolean isTheSameEClass(EClass candidate, EClass pattern) {
        if (pattern.equals(candidate)) {
            return true;
        }
        if (candidate == null) {
            return false;
        }
        return pattern.getEPackage().getNsURI().equals(candidate.getEPackage().getNsURI()) && pattern.getName().equals(candidate.getName());
    }

    private static boolean isTheSameEFeature(EStructuralFeature candidate, EStructuralFeature pattern) {
        if (candidate.equals(pattern)) {
            return true;
        }
        if (candidate == null) {
            return false;
        }
        return GeneratorExt.isTheSameEClass(candidate.getEContainingClass(), pattern.getEContainingClass()) && pattern.getName().equals(candidate.getName());
    }

    private void generatePaletteProvider(GenDiagram diagram) throws InterruptedException, UnexpectedBehaviourException {
        if (this.myEmitters.isPaletteProviderNeeded(diagram)) {
            this.doGenerateJavaClass(this.myEmitters.getPaletteProviderEmitter(), this.myEmitters.getPaletteProviderFQN(diagram), new Object[]{diagram});
        }
    }
}

