/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ArrayStoreInstruction
extends Instruction {
    private static final ArrayStoreInstruction[] preallocated = ArrayStoreInstruction.preallocate();

    protected ArrayStoreInstruction(short opcode) {
        super(opcode);
    }

    private static ArrayStoreInstruction[] preallocate() {
        ArrayStoreInstruction[] r = new ArrayStoreInstruction[9];
        short i = 79;
        while (i <= 86) {
            r[i - 79] = new ArrayStoreInstruction(i);
            i = (short)(i + 1);
        }
        r[8] = r[5];
        return r;
    }

    public static ArrayStoreInstruction make(String type) throws IllegalArgumentException {
        int i = Util.getTypeIndex(type);
        if (i < 0 || i > 8) {
            throw new IllegalArgumentException("Invalid type " + type + " for ArrayStoreInstruction");
        }
        return preallocated[i];
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayStoreInstruction) {
            ArrayStoreInstruction i = (ArrayStoreInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + 148791;
    }

    public int getPoppedCount() {
        return 3;
    }

    public String getType() {
        return Decoder.indexedTypes[this.opcode - 79];
    }

    public String toString() {
        return "ArrayStore(" + this.getType() + ")";
    }

    public void visit(Instruction.Visitor v) throws NullPointerException {
        v.visitArrayStore(this);
    }

    public boolean isPEI() {
        return true;
    }
}

