/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.ConstantValueReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableReader;
import com.ibm.wala.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrikeCT.RuntimeInvisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.shrikeCT.SourceFileReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;

public class ClassPrinter {
    private final PrintWriter w;
    private boolean printLineNumberInfo = true;
    private boolean printConstantPool = true;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public ClassPrinter(PrintWriter w) {
        this.w = w;
    }

    public void setPrintLineNumberInfo(boolean b) {
        this.printLineNumberInfo = b;
    }

    public void setPrintConstantPool(boolean b) {
        this.printConstantPool = b;
    }

    public static void main(String[] args) throws Exception {
        ClassInstrumenter ci;
        OfflineInstrumenter oi = new OfflineInstrumenter();
        args = oi.parseStandardArgs(args);
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        ClassPrinter p = new ClassPrinter(w);
        oi.beginTraversal();
        while ((ci = oi.nextClass()) != null) {
            try {
                p.doClass(ci.getReader());
            }
            finally {
                w.flush();
            }
        }
        oi.close();
    }

    private static String makeHex(byte[] bytes, int pos, int len, int padTo) {
        StringBuffer b = new StringBuffer();
        int i = pos;
        while (i < pos + len) {
            byte v = bytes[i];
            b.append(hexChars[v >> 4 & 0xF]);
            b.append(hexChars[v & 0xF]);
            ++i;
        }
        while (b.length() < padTo) {
            b.append(' ');
        }
        return b.toString();
    }

    private static String makeChars(byte[] bytes, int pos, int len) {
        StringBuffer b = new StringBuffer();
        int i = pos;
        while (i < pos + len) {
            char ch = (char)bytes[i];
            if (ch < ' ' || ch > '\u007f') {
                b.append('.');
            } else {
                b.append(ch);
            }
            ++i;
        }
        return b.toString();
    }

    private static String getClassName(ClassReader cr, int index) throws InvalidClassFileException {
        if (index == 0) {
            return "any";
        }
        return cr.getCP().getCPClass(index);
    }

    private static String dumpFlags(int flags) {
        StringBuffer buf = new StringBuffer();
        Class<Constants> c = Constants.class;
        Field[] fs = c.getDeclaredFields();
        int i = 0;
        while (i < fs.length) {
            String name = fs[i].getName();
            if (name.startsWith("ACC_")) {
                int val;
                try {
                    val = fs[i].getInt(null);
                }
                catch (IllegalArgumentException e) {
                    throw new Error(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new Error(e.getMessage());
                }
                if ((flags & val) != 0) {
                    if (buf.length() > 0) {
                        buf.append(" ");
                    }
                    buf.append(name.substring(4).toLowerCase());
                }
            }
            ++i;
        }
        return "0x" + Integer.toString(16, flags) + "(" + buf.toString() + ")";
    }

    /*
     * Unable to fully structure code
     */
    private void dumpAttributes(ClassReader cr, int i, ClassReader.AttrIterator attrs) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException {
        while (attrs.isValid()) {
            block34: {
                block35: {
                    block36: {
                        name = attrs.getName();
                        this.w.write("  " + name + ": @" + Integer.toString(attrs.getRawOffset(), 16) + "\n");
                        if (!name.equals("Code")) break block35;
                        code = new CodeReader(attrs);
                        this.w.write("    maxstack: " + code.getMaxStack() + "\n");
                        this.w.write("    maxlocals: " + code.getMaxLocals() + "\n");
                        this.w.write("    bytecode:\n");
                        rawHandlers = code.getRawHandlers();
                        decoder = new CTDecoder(code);
                        decoder.decode();
                        disasm = new Disassembler(decoder.getInstructions(), decoder.getHandlers(), decoder.getInstructionsToBytecodes());
                        disasm.disassembleTo("      ", this.w);
                        this.w.write("    exception handlers:\n");
                        e = 0;
                        while (e < rawHandlers.length) {
                            this.w.write("      " + rawHandlers[e] + " to " + rawHandlers[e + 1] + " catch " + ClassPrinter.getClassName(cr, rawHandlers[e + 3]) + " at " + rawHandlers[e + 2] + "\n");
                            e += 4;
                        }
                        codeAttrs = new ClassReader.AttrIterator();
                        code.initAttributeIterator(codeAttrs);
                        while (codeAttrs.isValid()) {
                            cName = codeAttrs.getName();
                            this.w.write("    " + cName + ": " + Integer.toString(codeAttrs.getRawOffset(), 16) + "\n");
                            codeAttrs.advance();
                        }
                        if (this.printLineNumberInfo && (map = LineNumberTableReader.makeBytecodeToSourceMap(code)) != null) {
                            this.w.write("    line number map:\n");
                            line = null;
                            count = 0;
                            j = 0;
                            while (j < map.length) {
                                line2 = "      " + j + ": " + map[j];
                                if (line == null || line2 == null || !line2.substring(line2.indexOf(58)).equals(line.substring(line.indexOf(58)))) {
                                    if (count > 1) {
                                        this.w.write(" (" + count + " times)\n");
                                    } else if (count > 0) {
                                        this.w.write("\n");
                                    }
                                    count = 0;
                                    line = line2;
                                    this.w.write(line);
                                }
                                ++count;
                                ++j;
                            }
                            if (count > 1) {
                                this.w.write(" (" + count + " times)\n");
                            } else if (count > 0) {
                                this.w.write("\n");
                            }
                        }
                        if ((locals = LocalVariableTableReader.makeVarMap(code)) == null) break block34;
                        this.w.write("    local variable map:\n");
                        line = null;
                        count = 0;
                        j = 0;
                        while (j < locals.length) {
                            vars = locals[j];
                            line2 = null;
                            if (vars != null) {
                                buf = new StringBuffer();
                                buf.append("      " + j + ":");
                                k = 0;
                                while (k < vars.length) {
                                    if (vars[k] != 0) {
                                        n = String.valueOf(cr.getCP().getCPUtf8(vars[k])) + "(" + cr.getCP().getCPUtf8(vars[k + 1]) + ")";
                                        buf.append(" " + k / 2 + ":" + n);
                                    }
                                    k += 2;
                                }
                                line2 = buf.toString();
                            }
                            if (line == null || line2 == null || !line2.substring(line2.indexOf(58)).equals(line.substring(line.indexOf(58)))) {
                                if (count > 1) {
                                    this.w.write(" (" + count + " times)\n");
                                } else if (count > 0) {
                                    this.w.write("\n");
                                }
                                count = 0;
                                line = line2;
                                if (line != null) {
                                    this.w.write(line);
                                }
                            }
                            if (line != null) {
                                ++count;
                            }
                            ++j;
                        }
                        if (count <= true) break block36;
                        this.w.write(" (" + count + " times)\n");
                        break block34;
                    }
                    if (count <= 0) break block34;
                    this.w.write("\n");
                    break block34;
                }
                if (name.equals("ConstantValue")) {
                    cv = new ConstantValueReader(attrs);
                    this.w.write("    value: " + ClassPrinter.getCPItemString(cr.getCP(), cv.getValueCPIndex()) + "\n");
                } else if (name.equals("SourceFile")) {
                    sr = new SourceFileReader(attrs);
                    this.w.write("    file: " + cr.getCP().getCPUtf8(sr.getSourceFileCPIndex()) + "\n");
                } else if (name.equals("Signature")) {
                    sr = new SignatureReader(attrs);
                    this.w.write("    signature: " + cr.getCP().getCPUtf8(sr.getSignatureCPIndex()) + "\n");
                } else {
                    if (name.equals("RuntimeInvisibleAnnotations")) {
                        r = new RuntimeInvisibleAnnotationsReader(attrs);
                        try {
                            var10_25 = annotations = r.getAnnotationOffsets();
                            var9_24 = annotations.length;
                            disasm = 0;
                            while (disasm < var9_24) {
                                j = var10_25[disasm];
                                this.w.write("    Annotation type: " + r.getAnnotationType(j) + "\n");
                                ++disasm;
                            }
                            break block34;
                        }
                        catch (RuntimeInvisibleAnnotationsReader.UnimplementedException v0) {
                            len = attrs.getDataSize();
                            pos = attrs.getDataOffset();
                            ** while (len > 0)
                        }
lbl-1000:
                        // 1 sources

                        {
                            amount = Math.min(16, len);
                            this.w.write("    " + ClassPrinter.makeHex(cr.getBytes(), pos, amount, 32) + " " + ClassPrinter.makeChars(cr.getBytes(), pos, amount) + "\n");
                            len -= amount;
                            pos += amount;
                            continue;
lbl127:
                            // 1 sources

                            break block34;
                        }
                    }
                    len = attrs.getDataSize();
                    pos = attrs.getDataOffset();
                    while (len > 0) {
                        amount = Math.min(16, len);
                        this.w.write("    " + ClassPrinter.makeHex(cr.getBytes(), pos, amount, 32) + " " + ClassPrinter.makeChars(cr.getBytes(), pos, amount) + "\n");
                        len -= amount;
                        pos += amount;
                    }
                }
            }
            attrs.advance();
        }
    }

    private static String getCPItemString(ConstantPoolParser cp, int i) throws InvalidClassFileException {
        byte t = cp.getItemType(i);
        switch (t) {
            case 1: {
                return "Utf8 " + ClassPrinter.quoteString(cp.getCPUtf8(i));
            }
            case 7: {
                return "Class " + cp.getCPClass(i);
            }
            case 8: {
                return "String " + ClassPrinter.quoteString(cp.getCPString(i));
            }
            case 3: {
                return "Integer " + cp.getCPInt(i);
            }
            case 4: {
                return "Float " + cp.getCPFloat(i);
            }
            case 6: {
                return "Double " + cp.getCPDouble(i);
            }
            case 5: {
                return "Long " + cp.getCPLong(i);
            }
            case 10: {
                return "Method " + cp.getCPRefClass(i) + " " + cp.getCPRefName(i) + " " + cp.getCPRefType(i);
            }
            case 9: {
                return "Field " + cp.getCPRefClass(i) + " " + cp.getCPRefName(i) + " " + cp.getCPRefType(i);
            }
            case 11: {
                return "InterfaceMethod " + cp.getCPRefClass(i) + " " + cp.getCPRefName(i) + " " + cp.getCPRefType(i);
            }
            case 12: {
                return "NameAndType " + cp.getCPNATType(i) + " " + cp.getCPNATName(i);
            }
        }
        return "Unknown type " + t;
    }

    private static String quoteString(String string) {
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                default: {
                    if (ch >= ' ' && ch <= '\u007f') {
                        buf.append(ch);
                        break;
                    }
                    buf.append("\\u");
                    String h = ClassPrinter.makeHex(new byte[]{(byte)(ch >> 8), (byte)ch}, 0, 2, 0);
                    int j = 4 - h.length();
                    while (j > 0) {
                        buf.append('0');
                        --j;
                    }
                    buf.append(h);
                }
            }
            ++i;
        }
        buf.append('\"');
        return buf.toString();
    }

    public void doClass(ClassReader cr) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException {
        if (cr == null) {
            throw new IllegalArgumentException("cr is null");
        }
        this.w.write("Class: " + cr.getName() + "\n");
        if (this.printConstantPool) {
            ConstantPoolParser cp = cr.getCP();
            int i = 1;
            while (i < cp.getItemCount()) {
                byte t = cp.getItemType(i);
                if (t > 0) {
                    this.w.write("  Constant pool item " + i + ": ");
                    this.w.write(ClassPrinter.getCPItemString(cp, i));
                    this.w.write("\n");
                }
                ++i;
            }
        }
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        cr.initClassAttributeIterator(attrs);
        this.dumpAttributes(cr, 0, attrs);
        this.w.write("\n");
        int fieldCount = cr.getFieldCount();
        this.w.write(String.valueOf(fieldCount) + " fields:\n");
        int i = 0;
        while (i < fieldCount) {
            this.w.write(String.valueOf(cr.getFieldName(i)) + " " + cr.getFieldType(i) + " " + ClassPrinter.dumpFlags(cr.getFieldAccessFlags(i)) + "\n");
            cr.initFieldAttributeIterator(i, attrs);
            this.dumpAttributes(cr, i, attrs);
            ++i;
        }
        this.w.write("\n");
        int methodCount = cr.getMethodCount();
        this.w.write(String.valueOf(methodCount) + " methods:\n");
        int i2 = 0;
        while (i2 < methodCount) {
            this.w.write(String.valueOf(cr.getMethodName(i2)) + " " + cr.getMethodType(i2) + " " + ClassPrinter.dumpFlags(cr.getMethodAccessFlags(i2)) + "\n");
            cr.initMethodAttributeIterator(i2, attrs);
            this.dumpAttributes(cr, i2, attrs);
            ++i2;
        }
        this.w.write("\n");
    }
}

