/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CommonProposal
implements ICommonProposal {
    private final String proposal;
    private final String newText;
    private final String oldText;
    private final int textStart;
    private final int cursorOffset;
    private final String additionalInfo;
    private final Image image;

    public CommonProposal(String proposal, int textStart, String newText, String oldText, int cursorOffset, Image image) {
        this.additionalInfo = null;
        this.proposal = proposal;
        this.textStart = textStart;
        this.newText = newText;
        this.oldText = oldText;
        this.cursorOffset = cursorOffset;
        this.image = image;
    }

    public void apply(IDocument document) {
        int i = 0;
        int iMax = Math.min(this.newText.length(), this.oldText.length());
        while (i < iMax) {
            if (this.newText.charAt(i) != this.oldText.charAt(i)) break;
            ++i;
        }
        int oldLength = this.oldText.length() - i;
        int newLength = this.newText.length() - i;
        if (oldLength > 0 || newLength > 0) {
            try {
                document.replace(this.textStart + i, oldLength, this.newText.substring(i));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public int compareTo(ICommonProposal o) {
        return this.getDisplayString().compareTo(o.getDisplayString());
    }

    public String getAdditionalProposalInfo() {
        return this.additionalInfo;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.proposal;
    }

    public Image getImage() {
        return this.image;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.cursorOffset, 0);
    }

    public String toString() {
        return this.proposal;
    }
}

