/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import java.io.File;
import java.util.Stack;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.fields.StringButtonFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Text;

public class DirectoryListFieldEditor
extends StringButtonFieldEditor {
    protected PreferencePage prefPage = null;
    protected PreferencesTab prefTab = null;

    public DirectoryListFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, int strategy, Composite parent) {
        super(page, tab, service, level, name, labelText, width, strategy, parent);
        this.prefPage = page;
        this.prefTab = tab;
        this.getChangeControl(parent).setText("Browse");
    }

    public DirectoryListFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, Composite parent) {
        super(page, tab, service, level, name, labelText, width, 0, parent);
        this.prefPage = page;
        this.prefTab = tab;
        this.getChangeControl(parent).setText("Browse");
    }

    public DirectoryListFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        super(page, tab, service, level, name, labelText, parent);
        this.prefPage = page;
        this.prefTab = tab;
        this.getChangeControl(parent).setText("Browse");
    }

    protected String changePressed() {
        String leadingPart;
        File d;
        Text text = this.getTextControl(this.parent);
        String curText = text.getText();
        Point sel = text.getSelection();
        boolean replace = text.getSelectionCount() > 0;
        boolean replaceAll = text.getSelectionCount() == text.getCharCount();
        File f = new File(this.getTextControl(this.parent).getText());
        if (!f.exists()) {
            f = null;
        }
        if ((d = this.getDirectory(f)) == null) {
            return null;
        }
        String dirPath = d.getAbsolutePath();
        if (replaceAll) {
            return dirPath;
        }
        int prevSep = curText.lastIndexOf(59, sel.x);
        if (prevSep < 0) {
            prevSep = 0;
        }
        String string = leadingPart = prevSep > 0 ? String.valueOf(curText.substring(0, prevSep)) + ';' : "";
        if (replace) {
            int followSep = curText.indexOf(59, sel.y);
            if (followSep < 0) {
                followSep = curText.length();
            }
            return String.valueOf(leadingPart) + dirPath + curText.substring(followSep);
        }
        if (sel.x == text.getCharCount()) {
            return String.valueOf(curText) + ';' + dirPath;
        }
        return String.valueOf(leadingPart) + dirPath + (prevSep > 0 ? "" : ";") + curText.substring(prevSep);
    }

    protected boolean doCheckState() {
        String path = this.getTextControl(this.parent).getText();
        if ((path = (path = this.preferencesService.performSubstitutions(path)) != null ? path.trim() : "").length() == 0 && !this.emptyStringAllowed) {
            this.setErrorMessage(String.valueOf(this.getFieldMessagePrefix()) + "Path length is zero when empty string is not allowed");
            return false;
        }
        Stack<String> stack = new Stack<String>();
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '\'') {
                if (!stack.empty() && "'".equals(stack.peek())) {
                    stack.pop();
                } else {
                    stack.push("'");
                }
            }
            if (path.charAt(i) == '\"') {
                if (!stack.empty() && "\"".equals(stack.peek())) {
                    stack.pop();
                } else {
                    stack.push("\"");
                }
            }
            ++i;
        }
        if (stack.size() != 0) {
            this.setErrorMessage(String.valueOf(this.getFieldMessagePrefix()) + "Path has quotes that are not balanced");
            return false;
        }
        path = path.replace("\"", "'");
        String[] splits = path.split("'");
        boolean splitsVerified = true;
        int i2 = 0;
        while (i2 < splits.length) {
            boolean bl = splitsVerified = splitsVerified && this.doCheckState(splits[i2]);
            if (!splitsVerified) {
                if (!this.hasErrorMessage()) {
                    this.setErrorMessage(String.valueOf(this.getFieldMessagePrefix()) + "Path segment \"splits[i]\" failed verification\t");
                }
                return false;
            }
            ++i2;
        }
        this.clearErrorMessage();
        return true;
    }

    protected boolean doCheckState(String path) {
        if (path.length() == 0) {
            return true;
        }
        String[] pathElems = path.split(";");
        int i = 0;
        while (i < pathElems.length) {
            String pathElem = pathElems[i].trim();
            File dir = new File(pathElem);
            if (!dir.isDirectory()) {
                this.setErrorMessage(String.valueOf(this.getFieldMessagePrefix()) + "Path list contains a name that is not a directory name");
                return false;
            }
            ++i;
        }
        return true;
    }

    private File getDirectory(File startingDirectory) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }
}

