/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.launch;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessage;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessageEx;
import org.eclipse.m2m.internal.qvt.oml.common.ui.IModelParameterInfo;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.IUriGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.UriGroupIn;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.UriGroupInOut;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.UriGroupOut;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TransformationControls {
    public static final int GRID = 2;
    public static final int TEXT_GRID = 1;

    private TransformationControls() {
    }

    public static IUriGroup createUriGroup(Composite parent, IModelParameterInfo paramInfo, ResourceSet validationRS) {
        Group group = new Group(parent, 0);
        group.setText(TransformationControls.getParameterName(paramInfo));
        group.setLayout((Layout)new FillLayout());
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        if (paramInfo.isInParameter()) {
            UriGroupIn uriGroup = new UriGroupIn((Composite)group, Messages.TargetUriSelector_Uri, validationRS);
            return uriGroup;
        }
        if (paramInfo.isInOutParameter()) {
            UriGroupInOut uriGroup = new UriGroupInOut((Composite)group, Messages.TargetUriSelector_Uri, validationRS);
            return uriGroup;
        }
        UriGroupOut uriGroup = new UriGroupOut((Composite)group, Messages.TargetUriSelector_Uri, validationRS);
        return uriGroup;
    }

    private static String getParameterName(IModelParameterInfo paramInfo) {
        String typeName;
        if (paramInfo.getDirection() == IModelParameterInfo.Direction.out || paramInfo.getEntryParamType() == null) {
            typeName = paramInfo.getModelTypeName();
            if (paramInfo.getMetamodel() != null && paramInfo.getMetamodel().getNsURI().length() > 0) {
                typeName = String.valueOf(typeName) + " (" + paramInfo.getMetamodel().getNsURI() + ")";
            }
        } else {
            typeName = EmfUtil.getFullName((EClassifier)paramInfo.getEntryParamType());
            typeName = String.valueOf(typeName) + '@';
            typeName = String.valueOf(typeName) + paramInfo.getModelTypeName();
        }
        return String.valueOf(paramInfo.getDirection().name().toUpperCase()) + "  " + paramInfo.getName() + " : " + typeName;
    }

    public static Button createButton(Composite parent, String text) {
        return TransformationControls.createButton(parent, text, 8, 1);
    }

    public static Button createButton(Composite parent, String text, int style, int gridData) {
        Button button = new Button(parent, style);
        button.setText(text);
        GridData data = new GridData(gridData);
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createCheckBox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData data = new GridData(768);
        data.horizontalSpan = span;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Text createText(Composite parent, int span) {
        return TransformationControls.createText(parent, 2048, span);
    }

    public static Text createText(Composite parent, int style, int span) {
        Text text = new Text(parent, style);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        text.setLayoutData((Object)gd);
        return text;
    }

    public static IStatus makeStatus(int code, String message) {
        return new Status(code, "org.eclipse.m2m.qvt.oml.common", code, message, null);
    }

    public static boolean statusToTab(IStatus status, ISetMessage tab) {
        tab.setMessage(null);
        tab.setErrorMessage(null);
        if (status == null) {
            return true;
        }
        switch (status.getSeverity()) {
            case 4: {
                tab.setErrorMessage(status.getMessage());
                return false;
            }
            case 2: {
                if (tab instanceof ISetMessageEx) {
                    ((ISetMessageEx)tab).setWarningMessage(status.getMessage());
                } else {
                    tab.setMessage(status.getMessage());
                }
                return true;
            }
        }
        if (tab instanceof ISetMessageEx) {
            tab.setMessage(status.getMessage());
        }
        return true;
    }
}

