/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.evaluator.InternalEvaluator;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtGenericEvaluationVisitor;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitor;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitorImpl;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTODebuggerShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IterateBreakpointHelper;
import org.eclipse.m2m.qvt.oml.debug.core.vm.UnitLocation;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMBreakpoint;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMBreakpointManager;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMStackFrame;
import org.eclipse.m2m.qvt.oml.debug.core.vm.ValidBreakpointLocator;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResumeEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResumeRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStartEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMSuspendEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMSuspendRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMTerminateRequest;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QVTODebugEvaluator
extends QvtOperationalEvaluationVisitorImpl {
    private final IQVTODebuggerShell fDebugShell;
    private final VMBreakpointManager fBPM;
    private final IterateBreakpointHelper fIterateBPHelper;
    private final List<UnitLocation> fLocationStack;
    private UnitLocation fCurrentLocation;
    private int fCurrentStepMode;

    private QVTODebugEvaluator(QvtOperationalEvaluationVisitorImpl parent, QvtOperationalEvaluationEnv nestedEvalEnv) {
        super(parent, nestedEvalEnv);
        QVTODebugEvaluator debugParent = (QVTODebugEvaluator)parent;
        this.fDebugShell = debugParent.fDebugShell;
        this.fBPM = debugParent.fBPM;
        this.fIterateBPHelper = debugParent.fIterateBPHelper;
        this.fLocationStack = debugParent.fLocationStack;
        this.fCurrentLocation = debugParent.fCurrentLocation;
        this.fCurrentStepMode = debugParent.fCurrentStepMode;
    }

    public QVTODebugEvaluator(QvtOperationalEnv env, QvtOperationalEvaluationEnv evalEnv, IQVTODebuggerShell shell) {
        super(env, evalEnv);
        this.fDebugShell = shell;
        this.fBPM = shell.getBreakPointManager();
        this.fIterateBPHelper = new IterateBreakpointHelper(this.fBPM);
        this.fLocationStack = new ArrayList<UnitLocation>();
        this.fCurrentLocation = null;
        this.fCurrentStepMode = 0;
        this.fDebugShell.sessionStarted(this);
        VMRequest request = null;
        try {
            QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/evaluator", "Debug evaluator going to initial SUSPEND state");
            request = shell.waitAndPopRequest(new VMStartEvent(this.getMainModuleName(), true));
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
            this.terminate();
        }
        if (!(request instanceof VMResumeRequest)) {
            this.terminate();
        }
    }

    public QvtOperationalEvaluationVisitor createDebugInterceptor() {
        return new DebugInterceptor((QvtOperationalEvaluationVisitor)this);
    }

    protected QvtOperationalEvaluationVisitorImpl createNestedEvaluationVisitor(QvtOperationalEvaluationVisitorImpl parent, QvtOperationalEvaluationEnv nestedEvalEnv) {
        return new QVTODebugEvaluator(parent, nestedEvalEnv);
    }

    protected void poppedStack() {
        this.popLocation();
    }

    protected void pushedStack(QvtOperationalEvaluationEnv env) {
        InternalEvaluationEnv internEnv = (InternalEvaluationEnv)env.getAdapter(InternalEvaluationEnv.class);
        ASTNode currentIP = (ASTNode)internEnv.getCurrentIP();
        UnitLocation startLocation = this.newLocalLocation(env, currentIP, currentIP.getStartPosition(), currentIP.getEndPosition() - currentIP.getStartPosition());
        this.pushLocation(startLocation);
    }

    protected void addToEnv(String varName, Object value, EClassifier declaredType) {
        this.getOperationalEvaluationEnv().add(varName, value, declaredType);
    }

    protected void replaceInEnv(String varName, Object value, EClassifier declaredType) {
        this.getOperationalEvaluationEnv().replace(varName, value, declaredType);
    }

    protected void processDeferredTasks() {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        TransformationInstance transformation = ((InternalEvaluationEnv)evalEnv.getAdapter(InternalEvaluationEnv.class)).getCurrentTransformation();
        Module module = transformation.getModule();
        UnitLocation startLocation = this.newLocalLocation(evalEnv, (ASTNode)module, module.getEndPosition(), 0);
        try {
            this.pushLocation(startLocation);
            super.processDeferredTasks();
        }
        finally {
            this.popLocation();
        }
    }

    public void notifyAfterDeferredAssign(AssignExp asssignExp, Object assignLeftValue) {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        UnitLocation startLocation = this.newLocalLocation(evalEnv, (ASTNode)asssignExp, asssignExp.getStartPosition(), QVTODebugEvaluator.getNodeLength((ASTNode)asssignExp));
        this.setCurrentLocation((ASTNode)asssignExp, startLocation, false);
        this.processDebugRequest(startLocation);
        UnitLocation endLocation = this.newLocalLocation(evalEnv, (ASTNode)asssignExp, asssignExp.getStartPosition() + QVTODebugEvaluator.getNodeLength((ASTNode)asssignExp) - 1, 1);
        this.setCurrentLocation((ASTNode)asssignExp, endLocation, true);
    }

    public Object navigateProperty(EStructuralFeature property, Object target) {
        OCLExpression body = this.getPropertyBody(property);
        if (body != null) {
            return super.navigate(property, body, target);
        }
        return this.getEvaluationEnvironment().navigateProperty((Object)property, null, target);
    }

    public Object visitVariable(Variable<EClassifier, EParameter> vd) {
        Object result = super.visitVariable(vd);
        EClassifier declaredType = (EClassifier)vd.getType();
        String name = vd.getName();
        QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
        env.replace(name, env.getValueOf(name), declaredType);
        return result;
    }

    public List<UnitLocation> getLocationStack() {
        return this.fLocationStack;
    }

    protected Object preElementVisit(ASTNode element) {
        this.setCurrentEnvInstructionPointer((EObject)element);
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        if (element instanceof Module) {
            this.fCurrentLocation = this.newLocalLocation(evalEnv, element, element.getStartPosition(), QVTODebugEvaluator.getNodeLength(element));
        } else if (!(element instanceof ImperativeOperation) && !(element instanceof EStructuralFeature)) {
            if (element instanceof LoopExp) {
                boolean skipIterate;
                LoopExp loop = (LoopExp)element;
                UnitLocation topLocation = this.getCurrentLocation();
                boolean bl = skipIterate = this.fCurrentStepMode == 0 || this.fCurrentStepMode == 2 && topLocation.getStackDepth() > this.fCurrentLocation.getStackDepth();
                if (!skipIterate) {
                    return this.fIterateBPHelper.stepIterateElement(loop, topLocation);
                }
            } else if (ValidBreakpointLocator.isBreakpointableElementStart(element)) {
                UnitLocation startLocation = this.newLocalLocation(evalEnv, element, element.getStartPosition(), QVTODebugEvaluator.getNodeLength(element));
                this.setCurrentLocation(element, startLocation, false);
                this.processDebugRequest(startLocation);
            } else {
                this.setCurrentLocation(element, this.newLocalLocation(evalEnv, element, element.getStartPosition(), QVTODebugEvaluator.getNodeLength(element)), false);
            }
        }
        return this.result;
    }

    protected Object postElementVisit(ASTNode element, Object preState, Object result) {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        if (!(element instanceof Module)) {
            if (element instanceof ImperativeOperation) {
                UnitLocation endLocation = this.newLocalLocation(evalEnv, element, element.getStartPosition() + QVTODebugEvaluator.getNodeLength(element), 1);
                this.setCurrentLocation(element, endLocation, true);
            } else if (!(element instanceof EStructuralFeature)) {
                if (element instanceof LoopExp) {
                    if (preState instanceof VMBreakpoint) {
                        this.fIterateBPHelper.removeIterateBreakpoint((VMBreakpoint)preState);
                    }
                } else {
                    UnitLocation el = this.newLocalLocation(evalEnv, element, element.getStartPosition() + QVTODebugEvaluator.getNodeLength(element) - 1, 1);
                    this.setCurrentLocation(element, el, true);
                }
            }
        }
        return result;
    }

    private void processDebugRequest(UnitLocation location) {
        VMRequest event = this.fDebugShell.popRequest();
        if (event == null) {
            return;
        }
        this.doProcessRequest(location, event);
    }

    private void doProcessRequest(UnitLocation location, VMRequest request) {
        if (request instanceof VMResumeRequest) {
            VMResumeRequest resumeRequest = (VMResumeRequest)request;
            this.fCurrentLocation = this.getCurrentLocation();
            this.fCurrentStepMode = resumeRequest.detail;
            if (this.fCurrentStepMode == 0) {
                this.fIterateBPHelper.removeAllIterateBreakpoints();
            }
        } else if (request instanceof VMSuspendRequest) {
            VMSuspendRequest suspendRequest = (VMSuspendRequest)request;
            this.suspendAndWaitForResume(location, suspendRequest.detail);
        } else if (request instanceof VMTerminateRequest) {
            this.terminate();
        } else {
            throw new IllegalArgumentException("Unsupported debug request: " + request);
        }
    }

    protected void handleLocationChanged(ASTNode element, UnitLocation location, boolean isElementEnd) {
        if (this.fCurrentLocation == null) {
            return;
        }
        if (!isElementEnd ? !ValidBreakpointLocator.isBreakpointableElementStart(element) : !ValidBreakpointLocator.isBreakpointableElementEnd(element)) {
            return;
        }
        switch (this.fCurrentStepMode) {
            case 2: {
                if (location.getStackDepth() > this.fCurrentLocation.getStackDepth() || location.isTheSameLine(this.fCurrentLocation)) break;
                this.fCurrentLocation = null;
                this.suspendAndWaitForResume(location, this.fCurrentStepMode);
                return;
            }
            case 1: {
                if (location.isTheSameLine(this.fCurrentLocation)) break;
                this.fCurrentLocation = null;
                this.suspendAndWaitForResume(location, this.fCurrentStepMode);
                return;
            }
            case 4: {
                if (location.getStackDepth() >= this.fCurrentLocation.getStackDepth()) break;
                this.fCurrentLocation = null;
                this.suspendAndWaitForResume(location, this.fCurrentStepMode);
                return;
            }
        }
        for (VMBreakpoint breakpoint : this.fBPM.getBreakpoints(element)) {
            if (breakpoint.getLineNumber() != location.getLineNum()) continue;
            Boolean isTriggered = null;
            try {
                isTriggered = breakpoint.hitAndCheckIfTriggered(this);
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                String reason = null;
                if (status.getCode() == 100) {
                    reason = "Breakpoint condition compilation failed";
                } else if (status.getCode() == 110) {
                    reason = "Breakpoint condition evaluation failed";
                }
                if (reason != null) {
                    VMSuspendEvent suspendOnBpConditionErrr = this.createVMSuspendEvent(42);
                    suspendOnBpConditionErrr.setBreakpointID(breakpoint.getID());
                    suspendOnBpConditionErrr.setReason(reason, status.getMessage());
                    this.suspendAndWaitForResume(location, suspendOnBpConditionErrr);
                    continue;
                }
                QVTODebugCore.log(e.getStatus());
                continue;
            }
            if (!Boolean.TRUE.equals(isTriggered)) continue;
            boolean isIterateBp = this.fIterateBPHelper.isIterateBreakpoint(breakpoint);
            int eventDetail = isIterateBp ? this.fCurrentStepMode : 16;
            this.suspendAndWaitForResume(location, eventDetail);
            if (!isIterateBp) continue;
            this.fBPM.removeBreakpoint(breakpoint);
        }
    }

    private VMSuspendEvent createVMSuspendEvent(int eventDetail) {
        VMStackFrame[] vmStack = VMStackFrame.create(this.getLocationStack());
        assert (vmStack.length > 0);
        return new VMSuspendEvent(vmStack, eventDetail);
    }

    private void suspendAndWaitForResume(UnitLocation location, int eventDetail) {
        this.suspendAndWaitForResume(location, this.createVMSuspendEvent(eventDetail));
    }

    private void suspendAndWaitForResume(UnitLocation location, VMSuspendEvent suspendEvent) {
        try {
            VMSuspendEvent vmSuspend = suspendEvent;
            VMRequest nextRequest = this.fDebugShell.waitAndPopRequest(vmSuspend);
            assert (nextRequest != null);
            if (nextRequest instanceof VMResumeRequest) {
                this.fDebugShell.handleVMEvent(new VMResumeEvent());
            }
            this.doProcessRequest(location, nextRequest);
        }
        catch (InterruptedException interruptedException) {
            this.terminate();
        }
    }

    private UnitLocation newLocalLocation(QvtOperationalEvaluationEnv evalEnv, ASTNode node, int offset, int length) {
        return new UnitLocation(offset, evalEnv, node);
    }

    private void setCurrentLocation(ASTNode element, UnitLocation newLocation, boolean atEnd) {
        if (this.fLocationStack.isEmpty()) {
            return;
        }
        if (newLocation.getOffset() < 0) {
            return;
        }
        this.fLocationStack.set(0, newLocation);
        this.handleLocationChanged(element, newLocation, atEnd);
    }

    private void pushLocation(UnitLocation location) {
        this.fLocationStack.add(0, location);
    }

    private UnitLocation popLocation() {
        UnitLocation removed = this.fLocationStack.remove(0);
        return removed;
    }

    UnitLocation getCurrentLocation() {
        return !this.fLocationStack.isEmpty() ? this.fLocationStack.get(0) : null;
    }

    static int getNodeLength(ASTNode element) {
        return element.getEndPosition() - element.getStartPosition();
    }

    private void terminate() throws QvtInterruptedExecutionException {
        InternalEvaluationEnv currentEnv = (InternalEvaluationEnv)this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
        currentEnv.throwQVTException((QvtRuntimeException)new QvtInterruptedExecutionException("User termination request"));
    }

    private String getMainModuleName() {
        CompiledUnit mainUnit = this.fBPM.getUnitManager().getMainUnit();
        if (mainUnit.getModules().isEmpty()) {
            return "<null>";
        }
        return ((Module)mainUnit.getModules().get(0)).getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DebugInterceptor
    extends QvtGenericEvaluationVisitor
    implements InternalEvaluator {
        public ModuleInstance callTransformationImplicitConstructor(OperationalTransformation transformation, List<ModelInstance> args) {
            return QVTODebugEvaluator.this.callTransformationImplicitConstructor(transformation, args);
        }

        public QvtOperationalEvaluationVisitorImpl.OperationCallResult runMainEntry(OperationalTransformation transformation, List<Object> args) {
            return QVTODebugEvaluator.this.runMainEntry(transformation, args);
        }

        public Object execute(OperationalTransformation transformation) throws QvtRuntimeException {
            QVTODebugEvaluator.this.fCurrentLocation = QVTODebugEvaluator.this.newLocalLocation(this.getOperationalEvaluationEnv(), (ASTNode)transformation, transformation.getStartPosition(), QVTODebugEvaluator.getNodeLength((ASTNode)transformation));
            return QVTODebugEvaluator.this.execute(transformation);
        }

        private DebugInterceptor(QvtOperationalEvaluationVisitor qvtExtVisitor) {
            super(qvtExtVisitor);
        }

        public void setOperationalEvaluationEnv(QvtOperationalEvaluationEnv evalEnv) {
            QVTODebugEvaluator.this.setOperationalEvaluationEnv(evalEnv);
        }

        public QvtOperationalEvaluationEnv getOperationalEvaluationEnv() {
            return QVTODebugEvaluator.this.getOperationalEvaluationEnv();
        }

        public IContext getContext() {
            return QVTODebugEvaluator.this.getContext();
        }

        protected Object genericPreVisitAST(ASTNode visited) {
            if (this.getContext().getMonitor() != null && this.getContext().getMonitor().isCanceled()) {
                QVTODebugEvaluator.this.throwQVTException((QvtRuntimeException)new QvtInterruptedExecutionException());
            }
            return QVTODebugEvaluator.this.preElementVisit(visited);
        }

        protected Object genericPostVisitAST(ASTNode element, Object preVisitState, Object result) {
            return QVTODebugEvaluator.this.postElementVisit(element, preVisitState, result);
        }
    }
}

