/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.debug.ui.views;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.common.TraceActionBarContributor;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.common.TraceWorkbenchPart;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOStackFrame;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOThread;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class TraceViewPart
extends AbstractDebugView
implements IDebugContextListener {
    private static final String ID = "org.eclipse.m2m.internal.qvt.oml.debug.ui.views.trace";
    private final TraceWorkbenchPart myTraceWorkbenchPart = new TraceWorkbenchPart((IWorkbenchPart)this);
    private final TraceActionBarContributor myTraceActionBarContributor = new TraceActionBarContributor();

    protected Viewer createViewer(Composite parent) {
        this.myTraceWorkbenchPart.createPartControl(parent);
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        TreeViewer viewer = this.myTraceWorkbenchPart.getViewer();
        this.myTraceActionBarContributor.setViewer(viewer);
        return viewer;
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        super.dispose();
    }

    protected String getHelpContextId() {
        return ID;
    }

    protected void configureToolBar(IToolBarManager toolBarManager) {
        this.myTraceActionBarContributor.contributeToToolBar(toolBarManager);
    }

    protected void createActions() {
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void becomesHidden() {
        this.myTraceWorkbenchPart.setInput(null);
    }

    protected void becomesVisible() {
        ISelection selection = DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).getActiveContext();
        this.contextActivated(selection);
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    private void contextActivated(ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            QvtOperationalEvaluationEnv evalEnv;
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement == null) {
                return;
            }
            QVTOStackFrame qvtStackFrame = null;
            if (firstElement instanceof QVTOThread) {
                QVTOThread qvtThread = (QVTOThread)firstElement;
                try {
                    IStackFrame[] stackFrames = qvtThread.getStackFrames();
                    if (stackFrames.length == 0) {
                        return;
                    }
                    qvtStackFrame = (QVTOStackFrame)stackFrames[0];
                }
                catch (DebugException e) {
                    QVTODebugCore.log((Throwable)e);
                }
            }
            if (firstElement instanceof QVTOStackFrame) {
                qvtStackFrame = (QVTOStackFrame)firstElement;
            }
            if (qvtStackFrame != null && (evalEnv = (QvtOperationalEvaluationEnv)qvtStackFrame.getDebugTarget().getAdapter(QvtOperationalEvaluationEnv.class)) != null) {
                InternalEvaluationEnv internEnv = (InternalEvaluationEnv)evalEnv.getAdapter(InternalEvaluationEnv.class);
                Trace trace = internEnv.getTraces();
                this.activate(trace);
                return;
            }
        }
        this.deactivate();
    }

    private void activate(Trace trace) {
        if (trace == this.myTraceWorkbenchPart.getInput()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TraceViewPart.this.myTraceWorkbenchPart.getViewer().refresh();
                }
            });
        } else {
            this.myTraceWorkbenchPart.setInput(trace);
            this.setEnabled(true);
        }
    }

    private void deactivate() {
        this.myTraceWorkbenchPart.setInput(null);
        this.setEnabled(false);
    }

    private void setEnabled(boolean enabled) {
        this.getDefaultPage().getControl().setVisible(enabled);
        IAction[] iActionArray = this.myTraceActionBarContributor.getActions();
        int n = iActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            action.setEnabled(enabled);
            ++n2;
        }
    }
}

