/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class ViewRepresentationCheckboxAction
extends Action {
    private final IDialogSettings myDialogSettings;
    private final String myStorageKey;
    private final TreeViewer myViewer;

    public ViewRepresentationCheckboxAction(TreeViewer outlineViewer, IDialogSettings dialogSettings, String storageKey, String text, String toolTipText, String description, String icon, String helpContextId) {
        super(text, 2);
        this.myDialogSettings = dialogSettings;
        this.myStorageKey = storageKey;
        this.setToolTipText(toolTipText);
        this.setDescription(description);
        this.setImageDescriptors(icon);
        this.myViewer = outlineViewer;
        boolean checked = dialogSettings.getBoolean(storageKey);
        this.setChecked(checked);
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, helpContextId);
        }
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(boolean on, boolean store) {
        this.setChecked(on);
        BusyIndicator.showWhile((Display)this.myViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ViewRepresentationCheckboxAction.this.myViewer.refresh(true);
            }
        });
        if (store) {
            this.myDialogSettings.put(this.myStorageKey, on);
        }
    }

    private void setImageDescriptors(String descriptorKey) {
        ImageDescriptor descriptor = CompletionProposalUtil.getImageDescriptor(descriptorKey);
        if (descriptor != null) {
            this.setDisabledImageDescriptor(descriptor);
            this.setHoverImageDescriptor(descriptor);
            this.setImageDescriptor(descriptor);
        }
    }
}

